/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.testdata;

import com.google.common.collect.ImmutableSet;
import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.FlyteExecConf;
import com.spotify.styx.model.FlyteIdentifier;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowConfiguration;
import com.spotify.styx.model.WorkflowConfigurationBuilder;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class TestData {
    public static final String VALID_SHA = "00000ef508c1cb905e360590ce3e7e9193f6b370";
    public static final String INVALID_SHA = "XXXXXef508c1cb905e360590ce3e7e9193f6b370";
    public static final Set<String> RESOURCE_IDS = ImmutableSet.of((Object)"foo-resource", (Object)"bar-resource");
    public static final String EXECUTION_ID = "test";
    public static final String FLYTE_EXECUTION_ID = "abc";
    public static final WorkflowId WORKFLOW_ID = WorkflowId.create("styx", "styx.TestEndpoint");
    public static final WorkflowId WORKFLOW_ID_2 = WorkflowId.create("ranic", "ranic");
    public static final WorkflowInstance WORKFLOW_INSTANCE = WorkflowInstance.create(WORKFLOW_ID, "2016-09-01");
    public static final WorkflowConfiguration MINIMAL_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("wf").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").schedule(Schedule.HOURS).build();
    public static final WorkflowConfiguration HOURLY_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.HOURS).build();
    public static final WorkflowConfiguration HOURLY_WORKFLOW_CONFIGURATION_WITH_RESOURCES = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.HOURS).resources((Collection<? extends String>)RESOURCE_IDS).build();
    public static final WorkflowConfiguration HOURLY_WORKFLOW_CONFIGURATION_WITH_RESOURCES_2 = WorkflowConfiguration.builder().id("ranic").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.HOURS).resources((Collection<? extends String>)RESOURCE_IDS).build();
    public static final WorkflowConfiguration HOURLY_WORKFLOW_CONFIGURATION_WITH_INVALID_OFFSET = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.HOURS).offset("P1D2H").build();
    public static final WorkflowConfiguration HOURLY_WORKFLOW_CONFIGURATION_WITH_VALID_OFFSET = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.HOURS).offset("P30DT30M").build();
    public static final WorkflowConfiguration DAILY_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.DAYS).build();
    public static final WorkflowConfiguration WEEKLY_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.WEEKS).build();
    public static final WorkflowConfiguration MONTHLY_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.MONTHS).build();
    public static final WorkflowConfiguration YEARLY_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.YEARS).build();
    public static final WorkflowConfiguration FULL_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").schedule(Schedule.DAYS).dockerImage("busybox").dockerArgs(List.of("x", "y")).serviceAccount("foo@bar.baz.quux").retryCondition("#exitCode == 1 && (#tries < 3 || #consecutiveFailures < 4) && #triggerType == \"natural\"").build();
    public static final FlyteExecConf FLYTE_EXEC_CONF = FlyteExecConf.builder().referenceId(FlyteIdentifier.builder().resourceType("LAUNCH_PLAN").project("flyte-test").domain("production").name("test-workflow").version("1.0").build()).inputFields("foo", "bar").build();
    public static final WorkflowConfiguration FLYTE_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").schedule(Schedule.DAYS).serviceAccount("foo@bar.baz.quux").flyteExecConf(FLYTE_EXEC_CONF).runningTimeout(Duration.parse("PT20H")).retryCondition("#tries<2").env("foo", "bar").build();
    public static final WorkflowConfiguration DOCKER_AND_FLYTE_CONFLICTING_CONFIGURATION = WorkflowConfigurationBuilder.from(FLYTE_WORKFLOW_CONFIGURATION).dockerImage("gcr.io/image").dockerArgs(List.of("other", "args")).build();
    public static final WorkflowConfiguration HOURLY_WORKFLOW_CONFIGURATION_WITH_RESOURCES_RUNNING_TIMEOUT = WorkflowConfiguration.builder().id("styx.TestEndpoint").commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").dockerImage("busybox").schedule(Schedule.HOURS).resources((Collection<? extends String>)RESOURCE_IDS).runningTimeout(Duration.ofMillis(2L)).build();
    public static final ExecutionDescription EXECUTION_DESCRIPTION = ExecutionDescription.builder().dockerImage("busybox:1.1").dockerArgs(List.of("foo", "bar")).commitSha("00000ef508c1cb905e360590ce3e7e9193f6b370").build();
    public static final ExecutionDescription FLYTE_EXECUTION_DESCRIPTION = ExecutionDescription.builder().flyteExecConf(FLYTE_EXEC_CONF).flyteExecutionId("abc").build();
    public static final Workflow WORKFLOW_WITH_RESOURCES = Workflow.create(WORKFLOW_ID.componentId(), HOURLY_WORKFLOW_CONFIGURATION_WITH_RESOURCES);
    public static final Workflow WORKFLOW_WITH_RESOURCES_2 = Workflow.create(WORKFLOW_ID_2.componentId(), HOURLY_WORKFLOW_CONFIGURATION_WITH_RESOURCES_2);
    public static final Workflow WORKFLOW_WITH_RESOURCES_RUNNING_TIMEOUT = Workflow.create(WORKFLOW_ID.componentId(), HOURLY_WORKFLOW_CONFIGURATION_WITH_RESOURCES_RUNNING_TIMEOUT);

    private TestData() {
        throw new UnsupportedOperationException();
    }
}

