/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class FutureUtil {
    private FutureUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> List<T> gatherIO(List<? extends CompletableFuture<? extends T>> futures, CompletionStage<Void> timeout) throws IOException {
        timeout.thenRun(() -> futures.forEach(f -> f.completeExceptionally(new TimeoutException())));
        ImmutableList.Builder values = ImmutableList.builder();
        for (CompletableFuture<T> future : futures) {
            try {
                values.add(future.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Throwables.propagateIfPossible((Throwable)cause, IOException.class);
                if (cause instanceof TimeoutException) {
                    throw new IOException(cause);
                }
                throw new RuntimeException(cause);
            }
        }
        return values.build();
    }
}

