/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.DeploymentSource;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class DeploymentSourceBuilder {
    private Optional<String> repository;
    private String source;

    public DeploymentSourceBuilder() {
        this.repository = Optional.empty();
    }

    private DeploymentSourceBuilder(DeploymentSource v) {
        this.repository = v.repository();
        this.source = v.source();
    }

    private DeploymentSourceBuilder(DeploymentSourceBuilder v) {
        this.repository = v.repository;
        this.source = v.source;
    }

    public Optional<String> repository() {
        return this.repository;
    }

    public DeploymentSourceBuilder repository(String repository) {
        return this.repository(Optional.ofNullable(repository));
    }

    public DeploymentSourceBuilder repository(Optional<? extends String> repository) {
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        this.repository = repository;
        return this;
    }

    public String source() {
        return this.source;
    }

    public DeploymentSourceBuilder source(String source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.source = source;
        return this;
    }

    public DeploymentSource build() {
        return new Value(this.repository, this.source);
    }

    public static DeploymentSourceBuilder from(DeploymentSource v) {
        return new DeploymentSourceBuilder(v);
    }

    public static DeploymentSourceBuilder from(DeploymentSourceBuilder v) {
        return new DeploymentSourceBuilder(v);
    }

    private static final class Value
    implements DeploymentSource {
        private final Optional<String> repository;
        private final String source;

        private Value(@AutoMatter.Field(value="repository") Optional<String> repository, @AutoMatter.Field(value="source") String source) {
            if (repository == null) {
                throw new NullPointerException("repository");
            }
            if (source == null) {
                throw new NullPointerException("source");
            }
            this.repository = repository;
            this.source = source;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> repository() {
            return this.repository;
        }

        @Override
        @AutoMatter.Field
        public String source() {
            return this.source;
        }

        @Override
        public DeploymentSourceBuilder builder() {
            return new DeploymentSourceBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeploymentSource)) {
                return false;
            }
            DeploymentSource that = (DeploymentSource)o;
            if (this.repository != null ? !this.repository.equals(that.repository()) : that.repository() != null) {
                return false;
            }
            return !(this.source != null ? !this.source.equals(that.source()) : that.source() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.repository != null ? this.repository.hashCode() : 0);
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DeploymentSource{repository=" + this.repository + ", source=" + this.source + "}";
        }
    }
}

