/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.DockerExecConf;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;

public final class DockerExecConfBuilder {
    private Optional<String> dockerImage;
    private Optional<List<String>> dockerArgs;
    private boolean dockerTerminationLogging;

    public DockerExecConfBuilder() {
        this.dockerImage = Optional.empty();
        this.dockerArgs = Optional.empty();
    }

    private DockerExecConfBuilder(DockerExecConf v) {
        this.dockerImage = v.dockerImage();
        this.dockerArgs = v.dockerArgs();
        this.dockerTerminationLogging = v.dockerTerminationLogging();
    }

    private DockerExecConfBuilder(DockerExecConfBuilder v) {
        this.dockerImage = v.dockerImage;
        this.dockerArgs = v.dockerArgs;
        this.dockerTerminationLogging = v.dockerTerminationLogging;
    }

    public Optional<String> dockerImage() {
        return this.dockerImage;
    }

    public DockerExecConfBuilder dockerImage(String dockerImage) {
        return this.dockerImage(Optional.ofNullable(dockerImage));
    }

    public DockerExecConfBuilder dockerImage(Optional<? extends String> dockerImage) {
        if (dockerImage == null) {
            throw new NullPointerException("dockerImage");
        }
        this.dockerImage = dockerImage;
        return this;
    }

    public Optional<List<String>> dockerArgs() {
        return this.dockerArgs;
    }

    public DockerExecConfBuilder dockerArgs(List<String> dockerArgs) {
        return this.dockerArgs(Optional.ofNullable(dockerArgs));
    }

    public DockerExecConfBuilder dockerArgs(Optional<? extends List<String>> dockerArgs) {
        if (dockerArgs == null) {
            throw new NullPointerException("dockerArgs");
        }
        this.dockerArgs = dockerArgs;
        return this;
    }

    public boolean dockerTerminationLogging() {
        return this.dockerTerminationLogging;
    }

    public DockerExecConfBuilder dockerTerminationLogging(boolean dockerTerminationLogging) {
        this.dockerTerminationLogging = dockerTerminationLogging;
        return this;
    }

    public DockerExecConf build() {
        return new Value(this.dockerImage, this.dockerArgs, this.dockerTerminationLogging);
    }

    public static DockerExecConfBuilder from(DockerExecConf v) {
        return new DockerExecConfBuilder(v);
    }

    public static DockerExecConfBuilder from(DockerExecConfBuilder v) {
        return new DockerExecConfBuilder(v);
    }

    private static final class Value
    implements DockerExecConf {
        private final Optional<String> dockerImage;
        private final Optional<List<String>> dockerArgs;
        private final boolean dockerTerminationLogging;

        private Value(@AutoMatter.Field(value="dockerImage") Optional<String> dockerImage, @AutoMatter.Field(value="dockerArgs") Optional<List<String>> dockerArgs, @AutoMatter.Field(value="dockerTerminationLogging") boolean dockerTerminationLogging) {
            if (dockerImage == null) {
                throw new NullPointerException("dockerImage");
            }
            if (dockerArgs == null) {
                throw new NullPointerException("dockerArgs");
            }
            this.dockerImage = dockerImage;
            this.dockerArgs = dockerArgs;
            this.dockerTerminationLogging = dockerTerminationLogging;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> dockerImage() {
            return this.dockerImage;
        }

        @Override
        @AutoMatter.Field
        public Optional<List<String>> dockerArgs() {
            return this.dockerArgs;
        }

        @Override
        @AutoMatter.Field
        public boolean dockerTerminationLogging() {
            return this.dockerTerminationLogging;
        }

        @Override
        public DockerExecConfBuilder builder() {
            return new DockerExecConfBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DockerExecConf)) {
                return false;
            }
            DockerExecConf that = (DockerExecConf)o;
            if (this.dockerImage != null ? !this.dockerImage.equals(that.dockerImage()) : that.dockerImage() != null) {
                return false;
            }
            if (this.dockerArgs != null ? !this.dockerArgs.equals(that.dockerArgs()) : that.dockerArgs() != null) {
                return false;
            }
            return this.dockerTerminationLogging == that.dockerTerminationLogging();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.dockerImage != null ? this.dockerImage.hashCode() : 0);
            result = 31 * result + (this.dockerArgs != null ? this.dockerArgs.hashCode() : 0);
            result = 31 * result + (this.dockerTerminationLogging ? 1231 : 1237);
            return result;
        }

        public String toString() {
            return "DockerExecConf{dockerImage=" + this.dockerImage + ", dockerArgs=" + this.dockerArgs + ", dockerTerminationLogging=" + this.dockerTerminationLogging + "}";
        }
    }
}

