/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.TriggerParameters;
import com.spotify.styx.model.TriggerResponse;
import com.spotify.styx.model.WorkflowId;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class TriggerResponseBuilder {
    private WorkflowId workflowId;
    private String parameter;
    private Optional<TriggerParameters> triggerParameters;
    private String triggerId;

    public TriggerResponseBuilder() {
        this.triggerParameters = Optional.empty();
    }

    private TriggerResponseBuilder(TriggerResponse v) {
        this.workflowId = v.workflowId();
        this.parameter = v.parameter();
        this.triggerParameters = v.triggerParameters();
        this.triggerId = v.triggerId();
    }

    private TriggerResponseBuilder(TriggerResponseBuilder v) {
        this.workflowId = v.workflowId;
        this.parameter = v.parameter;
        this.triggerParameters = v.triggerParameters;
        this.triggerId = v.triggerId;
    }

    public WorkflowId workflowId() {
        return this.workflowId;
    }

    public TriggerResponseBuilder workflowId(WorkflowId workflowId) {
        if (workflowId == null) {
            throw new NullPointerException("workflowId");
        }
        this.workflowId = workflowId;
        return this;
    }

    public String parameter() {
        return this.parameter;
    }

    public TriggerResponseBuilder parameter(String parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        this.parameter = parameter;
        return this;
    }

    public Optional<TriggerParameters> triggerParameters() {
        return this.triggerParameters;
    }

    public TriggerResponseBuilder triggerParameters(TriggerParameters triggerParameters) {
        return this.triggerParameters(Optional.ofNullable(triggerParameters));
    }

    public TriggerResponseBuilder triggerParameters(Optional<? extends TriggerParameters> triggerParameters) {
        if (triggerParameters == null) {
            throw new NullPointerException("triggerParameters");
        }
        this.triggerParameters = triggerParameters;
        return this;
    }

    public String triggerId() {
        return this.triggerId;
    }

    public TriggerResponseBuilder triggerId(String triggerId) {
        if (triggerId == null) {
            throw new NullPointerException("triggerId");
        }
        this.triggerId = triggerId;
        return this;
    }

    public TriggerResponse build() {
        return new Value(this.workflowId, this.parameter, this.triggerParameters, this.triggerId);
    }

    public static TriggerResponseBuilder from(TriggerResponse v) {
        return new TriggerResponseBuilder(v);
    }

    public static TriggerResponseBuilder from(TriggerResponseBuilder v) {
        return new TriggerResponseBuilder(v);
    }

    private static final class Value
    implements TriggerResponse {
        private final WorkflowId workflowId;
        private final String parameter;
        private final Optional<TriggerParameters> triggerParameters;
        private final String triggerId;

        private Value(@AutoMatter.Field(value="workflowId") WorkflowId workflowId, @AutoMatter.Field(value="parameter") String parameter, @AutoMatter.Field(value="triggerParameters") Optional<TriggerParameters> triggerParameters, @AutoMatter.Field(value="triggerId") String triggerId) {
            if (workflowId == null) {
                throw new NullPointerException("workflowId");
            }
            if (parameter == null) {
                throw new NullPointerException("parameter");
            }
            if (triggerParameters == null) {
                throw new NullPointerException("triggerParameters");
            }
            if (triggerId == null) {
                throw new NullPointerException("triggerId");
            }
            this.workflowId = workflowId;
            this.parameter = parameter;
            this.triggerParameters = triggerParameters;
            this.triggerId = triggerId;
        }

        @Override
        @AutoMatter.Field
        public WorkflowId workflowId() {
            return this.workflowId;
        }

        @Override
        @AutoMatter.Field
        public String parameter() {
            return this.parameter;
        }

        @Override
        @AutoMatter.Field
        public Optional<TriggerParameters> triggerParameters() {
            return this.triggerParameters;
        }

        @Override
        @AutoMatter.Field
        public String triggerId() {
            return this.triggerId;
        }

        public TriggerResponseBuilder builder() {
            return new TriggerResponseBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TriggerResponse)) {
                return false;
            }
            TriggerResponse that = (TriggerResponse)o;
            if (this.workflowId != null ? !this.workflowId.equals(that.workflowId()) : that.workflowId() != null) {
                return false;
            }
            if (this.parameter != null ? !this.parameter.equals(that.parameter()) : that.parameter() != null) {
                return false;
            }
            if (this.triggerParameters != null ? !this.triggerParameters.equals(that.triggerParameters()) : that.triggerParameters() != null) {
                return false;
            }
            return !(this.triggerId != null ? !this.triggerId.equals(that.triggerId()) : that.triggerId() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.workflowId != null ? this.workflowId.hashCode() : 0);
            result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
            result = 31 * result + (this.triggerParameters != null ? this.triggerParameters.hashCode() : 0);
            result = 31 * result + (this.triggerId != null ? this.triggerId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TriggerResponse{workflowId=" + this.workflowId + ", parameter=" + this.parameter + ", triggerParameters=" + this.triggerParameters + ", triggerId=" + this.triggerId + "}";
        }
    }
}

