/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.DeploymentSource;
import com.spotify.styx.model.FlyteExecConf;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.WorkflowConfiguration;
import io.norberg.automatter.AutoMatter;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class WorkflowConfigurationBuilder {
    private String id;
    private Schedule schedule;
    private Optional<String> offset;
    private Optional<String> commitSha;
    private Optional<String> dockerImage;
    private Optional<List<String>> dockerArgs;
    private boolean dockerTerminationLogging;
    private Optional<String> serviceAccount;
    private List<String> resources;
    private Map<String, String> env;
    private Optional<Duration> runningTimeout;
    private Optional<String> retryCondition;
    private Optional<FlyteExecConf> flyteExecConf;
    private Optional<DeploymentSource> deploymentSource;
    private Optional<Instant> deploymentTime;

    public WorkflowConfigurationBuilder() {
        this.offset = Optional.empty();
        this.commitSha = Optional.empty();
        this.dockerImage = Optional.empty();
        this.dockerArgs = Optional.empty();
        this.serviceAccount = Optional.empty();
        this.runningTimeout = Optional.empty();
        this.retryCondition = Optional.empty();
        this.flyteExecConf = Optional.empty();
        this.deploymentSource = Optional.empty();
        this.deploymentTime = Optional.empty();
    }

    private WorkflowConfigurationBuilder(WorkflowConfiguration v) {
        this.id = v.id();
        this.schedule = v.schedule();
        this.offset = v.offset();
        this.commitSha = v.commitSha();
        this.dockerImage = v.dockerImage();
        this.dockerArgs = v.dockerArgs();
        this.dockerTerminationLogging = v.dockerTerminationLogging();
        this.serviceAccount = v.serviceAccount();
        List<String> _resources = v.resources();
        this.resources = _resources == null ? null : new ArrayList<String>(_resources);
        Map<String, String> _env = v.env();
        this.env = _env == null ? null : new HashMap<String, String>(_env);
        this.runningTimeout = v.runningTimeout();
        this.retryCondition = v.retryCondition();
        this.flyteExecConf = v.flyteExecConf();
        this.deploymentSource = v.deploymentSource();
        this.deploymentTime = v.deploymentTime();
    }

    private WorkflowConfigurationBuilder(WorkflowConfigurationBuilder v) {
        this.id = v.id;
        this.schedule = v.schedule;
        this.offset = v.offset;
        this.commitSha = v.commitSha;
        this.dockerImage = v.dockerImage;
        this.dockerArgs = v.dockerArgs;
        this.dockerTerminationLogging = v.dockerTerminationLogging;
        this.serviceAccount = v.serviceAccount;
        this.resources = v.resources == null ? null : new ArrayList<String>(v.resources);
        this.env = v.env == null ? null : new HashMap<String, String>(v.env);
        this.runningTimeout = v.runningTimeout;
        this.retryCondition = v.retryCondition;
        this.flyteExecConf = v.flyteExecConf;
        this.deploymentSource = v.deploymentSource;
        this.deploymentTime = v.deploymentTime;
    }

    public String id() {
        return this.id;
    }

    public WorkflowConfigurationBuilder id(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        return this;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public WorkflowConfigurationBuilder schedule(Schedule schedule) {
        if (schedule == null) {
            throw new NullPointerException("schedule");
        }
        this.schedule = schedule;
        return this;
    }

    public Optional<String> offset() {
        return this.offset;
    }

    public WorkflowConfigurationBuilder offset(String offset) {
        return this.offset(Optional.ofNullable(offset));
    }

    public WorkflowConfigurationBuilder offset(Optional<? extends String> offset) {
        if (offset == null) {
            throw new NullPointerException("offset");
        }
        this.offset = offset;
        return this;
    }

    public Optional<String> commitSha() {
        return this.commitSha;
    }

    public WorkflowConfigurationBuilder commitSha(String commitSha) {
        return this.commitSha(Optional.ofNullable(commitSha));
    }

    public WorkflowConfigurationBuilder commitSha(Optional<? extends String> commitSha) {
        if (commitSha == null) {
            throw new NullPointerException("commitSha");
        }
        this.commitSha = commitSha;
        return this;
    }

    public Optional<String> dockerImage() {
        return this.dockerImage;
    }

    public WorkflowConfigurationBuilder dockerImage(String dockerImage) {
        return this.dockerImage(Optional.ofNullable(dockerImage));
    }

    public WorkflowConfigurationBuilder dockerImage(Optional<? extends String> dockerImage) {
        if (dockerImage == null) {
            throw new NullPointerException("dockerImage");
        }
        this.dockerImage = dockerImage;
        return this;
    }

    public Optional<List<String>> dockerArgs() {
        return this.dockerArgs;
    }

    public WorkflowConfigurationBuilder dockerArgs(List<String> dockerArgs) {
        return this.dockerArgs(Optional.ofNullable(dockerArgs));
    }

    public WorkflowConfigurationBuilder dockerArgs(Optional<? extends List<String>> dockerArgs) {
        if (dockerArgs == null) {
            throw new NullPointerException("dockerArgs");
        }
        this.dockerArgs = dockerArgs;
        return this;
    }

    public boolean dockerTerminationLogging() {
        return this.dockerTerminationLogging;
    }

    public WorkflowConfigurationBuilder dockerTerminationLogging(boolean dockerTerminationLogging) {
        this.dockerTerminationLogging = dockerTerminationLogging;
        return this;
    }

    public Optional<String> serviceAccount() {
        return this.serviceAccount;
    }

    public WorkflowConfigurationBuilder serviceAccount(String serviceAccount) {
        return this.serviceAccount(Optional.ofNullable(serviceAccount));
    }

    public WorkflowConfigurationBuilder serviceAccount(Optional<? extends String> serviceAccount) {
        if (serviceAccount == null) {
            throw new NullPointerException("serviceAccount");
        }
        this.serviceAccount = serviceAccount;
        return this;
    }

    public List<String> resources() {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        return this.resources;
    }

    public WorkflowConfigurationBuilder resources(List<? extends String> resources) {
        return this.resources((Collection<? extends String>)resources);
    }

    public WorkflowConfigurationBuilder resources(Collection<? extends String> resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        for (String string : resources) {
            if (string != null) continue;
            throw new NullPointerException("resources: null item");
        }
        this.resources = new ArrayList<String>(resources);
        return this;
    }

    public WorkflowConfigurationBuilder resources(Iterable<? extends String> resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        if (resources instanceof Collection) {
            return this.resources((Collection)resources);
        }
        return this.resources(resources.iterator());
    }

    public WorkflowConfigurationBuilder resources(Iterator<? extends String> resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        this.resources = new ArrayList<String>();
        while (resources.hasNext()) {
            String item = resources.next();
            if (item == null) {
                throw new NullPointerException("resources: null item");
            }
            this.resources.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final WorkflowConfigurationBuilder resources(String ... resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        return this.resources(Arrays.asList(resources));
    }

    public WorkflowConfigurationBuilder addResource(String resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resource);
        return this;
    }

    public Map<String, String> env() {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        return this.env;
    }

    public WorkflowConfigurationBuilder env(Map<? extends String, ? extends String> env) {
        if (env == null) {
            throw new NullPointerException("env");
        }
        for (Map.Entry<? extends String, ? extends String> entry : env.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("env: null key");
            }
            if (entry.getValue() != null) continue;
            throw new NullPointerException("env: null value");
        }
        this.env = new HashMap<String, String>(env);
        return this;
    }

    public WorkflowConfigurationBuilder env(String k1, String v1) {
        if (k1 == null) {
            throw new NullPointerException("env: k1");
        }
        if (v1 == null) {
            throw new NullPointerException("env: v1");
        }
        this.env = new HashMap<String, String>();
        this.env.put(k1, v1);
        return this;
    }

    public WorkflowConfigurationBuilder env(String k1, String v1, String k2, String v2) {
        this.env(k1, v1);
        if (k2 == null) {
            throw new NullPointerException("env: k2");
        }
        if (v2 == null) {
            throw new NullPointerException("env: v2");
        }
        this.env.put(k2, v2);
        return this;
    }

    public WorkflowConfigurationBuilder env(String k1, String v1, String k2, String v2, String k3, String v3) {
        this.env(k1, v1, k2, v2);
        if (k3 == null) {
            throw new NullPointerException("env: k3");
        }
        if (v3 == null) {
            throw new NullPointerException("env: v3");
        }
        this.env.put(k3, v3);
        return this;
    }

    public WorkflowConfigurationBuilder env(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4) {
        this.env(k1, v1, k2, v2, k3, v3);
        if (k4 == null) {
            throw new NullPointerException("env: k4");
        }
        if (v4 == null) {
            throw new NullPointerException("env: v4");
        }
        this.env.put(k4, v4);
        return this;
    }

    public WorkflowConfigurationBuilder env(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4, String k5, String v5) {
        this.env(k1, v1, k2, v2, k3, v3, k4, v4);
        if (k5 == null) {
            throw new NullPointerException("env: k5");
        }
        if (v5 == null) {
            throw new NullPointerException("env: v5");
        }
        this.env.put(k5, v5);
        return this;
    }

    public Optional<Duration> runningTimeout() {
        return this.runningTimeout;
    }

    public WorkflowConfigurationBuilder runningTimeout(Duration runningTimeout) {
        return this.runningTimeout(Optional.ofNullable(runningTimeout));
    }

    public WorkflowConfigurationBuilder runningTimeout(Optional<? extends Duration> runningTimeout) {
        if (runningTimeout == null) {
            throw new NullPointerException("runningTimeout");
        }
        this.runningTimeout = runningTimeout;
        return this;
    }

    public Optional<String> retryCondition() {
        return this.retryCondition;
    }

    public WorkflowConfigurationBuilder retryCondition(String retryCondition) {
        return this.retryCondition(Optional.ofNullable(retryCondition));
    }

    public WorkflowConfigurationBuilder retryCondition(Optional<? extends String> retryCondition) {
        if (retryCondition == null) {
            throw new NullPointerException("retryCondition");
        }
        this.retryCondition = retryCondition;
        return this;
    }

    public Optional<FlyteExecConf> flyteExecConf() {
        return this.flyteExecConf;
    }

    public WorkflowConfigurationBuilder flyteExecConf(FlyteExecConf flyteExecConf) {
        return this.flyteExecConf(Optional.ofNullable(flyteExecConf));
    }

    public WorkflowConfigurationBuilder flyteExecConf(Optional<? extends FlyteExecConf> flyteExecConf) {
        if (flyteExecConf == null) {
            throw new NullPointerException("flyteExecConf");
        }
        this.flyteExecConf = flyteExecConf;
        return this;
    }

    public Optional<DeploymentSource> deploymentSource() {
        return this.deploymentSource;
    }

    public WorkflowConfigurationBuilder deploymentSource(DeploymentSource deploymentSource) {
        return this.deploymentSource(Optional.ofNullable(deploymentSource));
    }

    public WorkflowConfigurationBuilder deploymentSource(Optional<? extends DeploymentSource> deploymentSource) {
        if (deploymentSource == null) {
            throw new NullPointerException("deploymentSource");
        }
        this.deploymentSource = deploymentSource;
        return this;
    }

    public Optional<Instant> deploymentTime() {
        return this.deploymentTime;
    }

    public WorkflowConfigurationBuilder deploymentTime(Instant deploymentTime) {
        return this.deploymentTime(Optional.ofNullable(deploymentTime));
    }

    public WorkflowConfigurationBuilder deploymentTime(Optional<? extends Instant> deploymentTime) {
        if (deploymentTime == null) {
            throw new NullPointerException("deploymentTime");
        }
        this.deploymentTime = deploymentTime;
        return this;
    }

    public WorkflowConfiguration build() {
        List<String> _resources = this.resources != null ? Collections.unmodifiableList(new ArrayList<String>(this.resources)) : Collections.emptyList();
        Map<String, String> _env = this.env != null ? Collections.unmodifiableMap(new HashMap<String, String>(this.env)) : Collections.emptyMap();
        return new Value(this.id, this.schedule, this.offset, this.commitSha, this.dockerImage, this.dockerArgs, this.dockerTerminationLogging, this.serviceAccount, _resources, _env, this.runningTimeout, this.retryCondition, this.flyteExecConf, this.deploymentSource, this.deploymentTime);
    }

    public static WorkflowConfigurationBuilder from(WorkflowConfiguration v) {
        return new WorkflowConfigurationBuilder(v);
    }

    public static WorkflowConfigurationBuilder from(WorkflowConfigurationBuilder v) {
        return new WorkflowConfigurationBuilder(v);
    }

    private static final class Value
    implements WorkflowConfiguration {
        private final String id;
        private final Schedule schedule;
        private final Optional<String> offset;
        private final Optional<String> commitSha;
        private final Optional<String> dockerImage;
        private final Optional<List<String>> dockerArgs;
        private final boolean dockerTerminationLogging;
        private final Optional<String> serviceAccount;
        private final List<String> resources;
        private final Map<String, String> env;
        private final Optional<Duration> runningTimeout;
        private final Optional<String> retryCondition;
        private final Optional<FlyteExecConf> flyteExecConf;
        private final Optional<DeploymentSource> deploymentSource;
        private final Optional<Instant> deploymentTime;

        private Value(@AutoMatter.Field(value="id") String id, @AutoMatter.Field(value="schedule") Schedule schedule, @AutoMatter.Field(value="offset") Optional<String> offset, @AutoMatter.Field(value="commitSha") Optional<String> commitSha, @AutoMatter.Field(value="dockerImage") Optional<String> dockerImage, @AutoMatter.Field(value="dockerArgs") Optional<List<String>> dockerArgs, @AutoMatter.Field(value="dockerTerminationLogging") boolean dockerTerminationLogging, @AutoMatter.Field(value="serviceAccount") Optional<String> serviceAccount, @AutoMatter.Field(value="resources") List<String> resources, @AutoMatter.Field(value="env") Map<String, String> env, @AutoMatter.Field(value="runningTimeout") Optional<Duration> runningTimeout, @AutoMatter.Field(value="retryCondition") Optional<String> retryCondition, @AutoMatter.Field(value="flyteExecConf") Optional<FlyteExecConf> flyteExecConf, @AutoMatter.Field(value="deploymentSource") Optional<DeploymentSource> deploymentSource, @AutoMatter.Field(value="deploymentTime") Optional<Instant> deploymentTime) {
            if (id == null) {
                throw new NullPointerException("id");
            }
            if (schedule == null) {
                throw new NullPointerException("schedule");
            }
            if (offset == null) {
                throw new NullPointerException("offset");
            }
            if (commitSha == null) {
                throw new NullPointerException("commitSha");
            }
            if (dockerImage == null) {
                throw new NullPointerException("dockerImage");
            }
            if (dockerArgs == null) {
                throw new NullPointerException("dockerArgs");
            }
            if (serviceAccount == null) {
                throw new NullPointerException("serviceAccount");
            }
            if (runningTimeout == null) {
                throw new NullPointerException("runningTimeout");
            }
            if (retryCondition == null) {
                throw new NullPointerException("retryCondition");
            }
            if (flyteExecConf == null) {
                throw new NullPointerException("flyteExecConf");
            }
            if (deploymentSource == null) {
                throw new NullPointerException("deploymentSource");
            }
            if (deploymentTime == null) {
                throw new NullPointerException("deploymentTime");
            }
            this.id = id;
            this.schedule = schedule;
            this.offset = offset;
            this.commitSha = commitSha;
            this.dockerImage = dockerImage;
            this.dockerArgs = dockerArgs;
            this.dockerTerminationLogging = dockerTerminationLogging;
            this.serviceAccount = serviceAccount;
            this.resources = resources != null ? resources : Collections.emptyList();
            this.env = env != null ? env : Collections.emptyMap();
            this.runningTimeout = runningTimeout;
            this.retryCondition = retryCondition;
            this.flyteExecConf = flyteExecConf;
            this.deploymentSource = deploymentSource;
            this.deploymentTime = deploymentTime;
        }

        @Override
        @AutoMatter.Field
        public String id() {
            return this.id;
        }

        @Override
        @AutoMatter.Field
        public Schedule schedule() {
            return this.schedule;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> offset() {
            return this.offset;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> commitSha() {
            return this.commitSha;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> dockerImage() {
            return this.dockerImage;
        }

        @Override
        @AutoMatter.Field
        public Optional<List<String>> dockerArgs() {
            return this.dockerArgs;
        }

        @Override
        @AutoMatter.Field
        public boolean dockerTerminationLogging() {
            return this.dockerTerminationLogging;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> serviceAccount() {
            return this.serviceAccount;
        }

        @Override
        @AutoMatter.Field
        public List<String> resources() {
            return this.resources;
        }

        @Override
        @AutoMatter.Field
        public Map<String, String> env() {
            return this.env;
        }

        @Override
        @AutoMatter.Field
        public Optional<Duration> runningTimeout() {
            return this.runningTimeout;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> retryCondition() {
            return this.retryCondition;
        }

        @Override
        @AutoMatter.Field
        public Optional<FlyteExecConf> flyteExecConf() {
            return this.flyteExecConf;
        }

        @Override
        @AutoMatter.Field
        public Optional<DeploymentSource> deploymentSource() {
            return this.deploymentSource;
        }

        @Override
        @AutoMatter.Field
        public Optional<Instant> deploymentTime() {
            return this.deploymentTime;
        }

        @Override
        public WorkflowConfigurationBuilder builder() {
            return new WorkflowConfigurationBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WorkflowConfiguration)) {
                return false;
            }
            WorkflowConfiguration that = (WorkflowConfiguration)o;
            if (this.id != null ? !this.id.equals(that.id()) : that.id() != null) {
                return false;
            }
            if (this.schedule != null ? !this.schedule.equals(that.schedule()) : that.schedule() != null) {
                return false;
            }
            if (this.offset != null ? !this.offset.equals(that.offset()) : that.offset() != null) {
                return false;
            }
            if (this.commitSha != null ? !this.commitSha.equals(that.commitSha()) : that.commitSha() != null) {
                return false;
            }
            if (this.dockerImage != null ? !this.dockerImage.equals(that.dockerImage()) : that.dockerImage() != null) {
                return false;
            }
            if (this.dockerArgs != null ? !this.dockerArgs.equals(that.dockerArgs()) : that.dockerArgs() != null) {
                return false;
            }
            if (this.dockerTerminationLogging != that.dockerTerminationLogging()) {
                return false;
            }
            if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount()) : that.serviceAccount() != null) {
                return false;
            }
            if (this.resources != null ? !this.resources.equals(that.resources()) : that.resources() != null) {
                return false;
            }
            if (this.env != null ? !this.env.equals(that.env()) : that.env() != null) {
                return false;
            }
            if (this.runningTimeout != null ? !this.runningTimeout.equals(that.runningTimeout()) : that.runningTimeout() != null) {
                return false;
            }
            if (this.retryCondition != null ? !this.retryCondition.equals(that.retryCondition()) : that.retryCondition() != null) {
                return false;
            }
            if (this.flyteExecConf != null ? !this.flyteExecConf.equals(that.flyteExecConf()) : that.flyteExecConf() != null) {
                return false;
            }
            if (this.deploymentSource != null ? !this.deploymentSource.equals(that.deploymentSource()) : that.deploymentSource() != null) {
                return false;
            }
            return !(this.deploymentTime != null ? !this.deploymentTime.equals(that.deploymentTime()) : that.deploymentTime() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
            result = 31 * result + (this.commitSha != null ? this.commitSha.hashCode() : 0);
            result = 31 * result + (this.dockerImage != null ? this.dockerImage.hashCode() : 0);
            result = 31 * result + (this.dockerArgs != null ? this.dockerArgs.hashCode() : 0);
            result = 31 * result + (this.dockerTerminationLogging ? 1231 : 1237);
            result = 31 * result + (this.serviceAccount != null ? this.serviceAccount.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.runningTimeout != null ? this.runningTimeout.hashCode() : 0);
            result = 31 * result + (this.retryCondition != null ? this.retryCondition.hashCode() : 0);
            result = 31 * result + (this.flyteExecConf != null ? this.flyteExecConf.hashCode() : 0);
            result = 31 * result + (this.deploymentSource != null ? this.deploymentSource.hashCode() : 0);
            result = 31 * result + (this.deploymentTime != null ? this.deploymentTime.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "WorkflowConfiguration{id=" + this.id + ", schedule=" + this.schedule + ", offset=" + this.offset + ", commitSha=" + this.commitSha + ", dockerImage=" + this.dockerImage + ", dockerArgs=" + this.dockerArgs + ", dockerTerminationLogging=" + this.dockerTerminationLogging + ", serviceAccount=" + this.serviceAccount + ", resources=" + this.resources + ", env=" + this.env + ", runningTimeout=" + this.runningTimeout + ", retryCondition=" + this.retryCondition + ", flyteExecConf=" + this.flyteExecConf + ", deploymentSource=" + this.deploymentSource + ", deploymentTime=" + this.deploymentTime + "}";
        }
    }
}

