/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.spotify.styx.model.FlyteExecConf;
import com.spotify.styx.model.data.AutoValue_Execution;
import com.spotify.styx.model.data.ExecStatus;
import java.util.List;
import java.util.Optional;

@AutoValue
public abstract class Execution {
    @JsonProperty
    public abstract Optional<String> executionId();

    @JsonProperty
    public abstract Optional<String> dockerImage();

    @JsonProperty
    public abstract Optional<String> commitSha();

    @JsonProperty
    public abstract Optional<FlyteExecConf> flyteExecConf();

    @JsonProperty
    public abstract Optional<String> flyteExecutionId();

    @JsonProperty
    public abstract Optional<String> runnerId();

    @JsonProperty
    public abstract List<ExecStatus> statuses();

    @JsonCreator
    public static Execution create(@JsonProperty(value="execution_id") Optional<String> executionId, @JsonProperty(value="docker_image") Optional<String> dockerImage, @JsonProperty(value="commit_sha") Optional<String> commitSha, @JsonProperty(value="flyte_exec_conf") Optional<FlyteExecConf> flyteExecConf, @JsonProperty(value="runner_id") Optional<String> runnerId, @JsonProperty(value="statuses") List<ExecStatus> statuses, @JsonProperty(value="flyte_execution_id") Optional<String> flyteExecutionId) {
        if (dockerImage.isPresent() && flyteExecConf.isPresent()) {
            throw new IllegalArgumentException("Conflicting configuration: Both docker image and flyte conf specified for exec id: " + executionId.orElse("unknown"));
        }
        return new AutoValue_Execution(executionId, dockerImage, commitSha, flyteExecConf, flyteExecutionId, runnerId, statuses);
    }

    public static Execution create(Optional<String> executionId, Optional<String> dockerImage, Optional<String> commitSha, Optional<String> runnerId, List<ExecStatus> statuses) {
        return Execution.create(executionId, dockerImage, commitSha, Optional.empty(), runnerId, statuses, Optional.empty());
    }

    public static Execution create(Optional<String> executionId, Optional<FlyteExecConf> flyteExecConf, Optional<String> runnerId, List<ExecStatus> statuses, Optional<String> flyteExecutionId) {
        return Execution.create(executionId, Optional.empty(), Optional.empty(), flyteExecConf, runnerId, statuses, flyteExecutionId);
    }
}

