/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.HttpResponseException;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class GoogleApiClientUtil {
    private static final WaitStrategy DEFAULT_RETRY_WAIT_STRATEGY = WaitStrategies.exponentialWait();
    private static final StopStrategy DEFAULT_RETRY_STOP_STRATEGY = StopStrategies.stopAfterDelay((long)30L, (TimeUnit)TimeUnit.SECONDS);

    private GoogleApiClientUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> T executeWithRetries(AbstractGoogleClientRequest<T> request) throws IOException {
        return GoogleApiClientUtil.executeWithRetries(request, DEFAULT_RETRY_WAIT_STRATEGY, DEFAULT_RETRY_STOP_STRATEGY);
    }

    public static <T> T executeWithRetries(AbstractGoogleClientRequest<T> request, WaitStrategy waitStrategy, StopStrategy stopStrategy) throws IOException {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException(GoogleApiClientUtil::isRetryableRequestFailure).withWaitStrategy(waitStrategy).withStopStrategy(stopStrategy).build();
        try {
            return (T)retryer.call(() -> request.execute());
        }
        catch (RetryException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw new IOException(e);
        }
    }

    private static boolean isRetryableRequestFailure(Throwable t) {
        if (t instanceof HttpResponseException) {
            int statusCode = ((HttpResponseException)t).getStatusCode();
            if (statusCode == 429) {
                return true;
            }
            return statusCode / 100 == 5;
        }
        return t instanceof IOException;
    }
}

