/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.TriggerParameters;
import com.spotify.styx.model.WorkflowId;
import io.norberg.automatter.AutoMatter;
import java.time.Instant;
import java.util.Optional;

public final class BackfillBuilder {
    private String id;
    private Instant start;
    private Instant end;
    private WorkflowId workflowId;
    private int concurrency;
    private Optional<String> description;
    private Instant nextTrigger;
    private Schedule schedule;
    private boolean allTriggered;
    private boolean halted;
    private boolean reverse;
    private Optional<TriggerParameters> triggerParameters;

    public BackfillBuilder() {
        this.description = Optional.empty();
        this.triggerParameters = Optional.empty();
    }

    private BackfillBuilder(Backfill v) {
        this.id = v.id();
        this.start = v.start();
        this.end = v.end();
        this.workflowId = v.workflowId();
        this.concurrency = v.concurrency();
        this.description = v.description();
        this.nextTrigger = v.nextTrigger();
        this.schedule = v.schedule();
        this.allTriggered = v.allTriggered();
        this.halted = v.halted();
        this.reverse = v.reverse();
        this.triggerParameters = v.triggerParameters();
    }

    private BackfillBuilder(BackfillBuilder v) {
        this.id = v.id;
        this.start = v.start;
        this.end = v.end;
        this.workflowId = v.workflowId;
        this.concurrency = v.concurrency;
        this.description = v.description;
        this.nextTrigger = v.nextTrigger;
        this.schedule = v.schedule;
        this.allTriggered = v.allTriggered;
        this.halted = v.halted;
        this.reverse = v.reverse;
        this.triggerParameters = v.triggerParameters;
    }

    public String id() {
        return this.id;
    }

    public BackfillBuilder id(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        return this;
    }

    public Instant start() {
        return this.start;
    }

    public BackfillBuilder start(Instant start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        this.start = start;
        return this;
    }

    public Instant end() {
        return this.end;
    }

    public BackfillBuilder end(Instant end) {
        if (end == null) {
            throw new NullPointerException("end");
        }
        this.end = end;
        return this;
    }

    public WorkflowId workflowId() {
        return this.workflowId;
    }

    public BackfillBuilder workflowId(WorkflowId workflowId) {
        if (workflowId == null) {
            throw new NullPointerException("workflowId");
        }
        this.workflowId = workflowId;
        return this;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public BackfillBuilder concurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public Optional<String> description() {
        return this.description;
    }

    public BackfillBuilder description(String description) {
        return this.description(Optional.ofNullable(description));
    }

    public BackfillBuilder description(Optional<? extends String> description) {
        if (description == null) {
            throw new NullPointerException("description");
        }
        this.description = description;
        return this;
    }

    public Instant nextTrigger() {
        return this.nextTrigger;
    }

    public BackfillBuilder nextTrigger(Instant nextTrigger) {
        if (nextTrigger == null) {
            throw new NullPointerException("nextTrigger");
        }
        this.nextTrigger = nextTrigger;
        return this;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public BackfillBuilder schedule(Schedule schedule) {
        if (schedule == null) {
            throw new NullPointerException("schedule");
        }
        this.schedule = schedule;
        return this;
    }

    public boolean allTriggered() {
        return this.allTriggered;
    }

    public BackfillBuilder allTriggered(boolean allTriggered) {
        this.allTriggered = allTriggered;
        return this;
    }

    public boolean halted() {
        return this.halted;
    }

    public BackfillBuilder halted(boolean halted) {
        this.halted = halted;
        return this;
    }

    public boolean reverse() {
        return this.reverse;
    }

    public BackfillBuilder reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public Optional<TriggerParameters> triggerParameters() {
        return this.triggerParameters;
    }

    public BackfillBuilder triggerParameters(TriggerParameters triggerParameters) {
        return this.triggerParameters(Optional.ofNullable(triggerParameters));
    }

    public BackfillBuilder triggerParameters(Optional<? extends TriggerParameters> triggerParameters) {
        if (triggerParameters == null) {
            throw new NullPointerException("triggerParameters");
        }
        this.triggerParameters = triggerParameters;
        return this;
    }

    public BackfillBuilder builder() {
        return new BackfillBuilder(this);
    }

    public Backfill build() {
        return new Value(this.id, this.start, this.end, this.workflowId, this.concurrency, this.description, this.nextTrigger, this.schedule, this.allTriggered, this.halted, this.reverse, this.triggerParameters);
    }

    public static BackfillBuilder from(Backfill v) {
        return new BackfillBuilder(v);
    }

    public static BackfillBuilder from(BackfillBuilder v) {
        return new BackfillBuilder(v);
    }

    private static final class Value
    implements Backfill {
        private final String id;
        private final Instant start;
        private final Instant end;
        private final WorkflowId workflowId;
        private final int concurrency;
        private final Optional<String> description;
        private final Instant nextTrigger;
        private final Schedule schedule;
        private final boolean allTriggered;
        private final boolean halted;
        private final boolean reverse;
        private final Optional<TriggerParameters> triggerParameters;

        private Value(@AutoMatter.Field(value="id") String id, @AutoMatter.Field(value="start") Instant start, @AutoMatter.Field(value="end") Instant end, @AutoMatter.Field(value="workflowId") WorkflowId workflowId, @AutoMatter.Field(value="concurrency") int concurrency, @AutoMatter.Field(value="description") Optional<String> description, @AutoMatter.Field(value="nextTrigger") Instant nextTrigger, @AutoMatter.Field(value="schedule") Schedule schedule, @AutoMatter.Field(value="allTriggered") boolean allTriggered, @AutoMatter.Field(value="halted") boolean halted, @AutoMatter.Field(value="reverse") boolean reverse, @AutoMatter.Field(value="triggerParameters") Optional<TriggerParameters> triggerParameters) {
            if (id == null) {
                throw new NullPointerException("id");
            }
            if (start == null) {
                throw new NullPointerException("start");
            }
            if (end == null) {
                throw new NullPointerException("end");
            }
            if (workflowId == null) {
                throw new NullPointerException("workflowId");
            }
            if (description == null) {
                throw new NullPointerException("description");
            }
            if (nextTrigger == null) {
                throw new NullPointerException("nextTrigger");
            }
            if (schedule == null) {
                throw new NullPointerException("schedule");
            }
            if (triggerParameters == null) {
                throw new NullPointerException("triggerParameters");
            }
            this.id = id;
            this.start = start;
            this.end = end;
            this.workflowId = workflowId;
            this.concurrency = concurrency;
            this.description = description;
            this.nextTrigger = nextTrigger;
            this.schedule = schedule;
            this.allTriggered = allTriggered;
            this.halted = halted;
            this.reverse = reverse;
            this.triggerParameters = triggerParameters;
        }

        @Override
        @AutoMatter.Field
        public String id() {
            return this.id;
        }

        @Override
        @AutoMatter.Field
        public Instant start() {
            return this.start;
        }

        @Override
        @AutoMatter.Field
        public Instant end() {
            return this.end;
        }

        @Override
        @AutoMatter.Field
        public WorkflowId workflowId() {
            return this.workflowId;
        }

        @Override
        @AutoMatter.Field
        public int concurrency() {
            return this.concurrency;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> description() {
            return this.description;
        }

        @Override
        @AutoMatter.Field
        public Instant nextTrigger() {
            return this.nextTrigger;
        }

        @Override
        @AutoMatter.Field
        public Schedule schedule() {
            return this.schedule;
        }

        @Override
        @AutoMatter.Field
        public boolean allTriggered() {
            return this.allTriggered;
        }

        @Override
        @AutoMatter.Field
        public boolean halted() {
            return this.halted;
        }

        @Override
        @AutoMatter.Field
        public boolean reverse() {
            return this.reverse;
        }

        @Override
        @AutoMatter.Field
        public Optional<TriggerParameters> triggerParameters() {
            return this.triggerParameters;
        }

        @Override
        public BackfillBuilder builder() {
            return new BackfillBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Backfill)) {
                return false;
            }
            Backfill that = (Backfill)o;
            if (this.id != null ? !this.id.equals(that.id()) : that.id() != null) {
                return false;
            }
            if (this.start != null ? !this.start.equals(that.start()) : that.start() != null) {
                return false;
            }
            if (this.end != null ? !this.end.equals(that.end()) : that.end() != null) {
                return false;
            }
            if (this.workflowId != null ? !this.workflowId.equals(that.workflowId()) : that.workflowId() != null) {
                return false;
            }
            if (this.concurrency != that.concurrency()) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description()) : that.description() != null) {
                return false;
            }
            if (this.nextTrigger != null ? !this.nextTrigger.equals(that.nextTrigger()) : that.nextTrigger() != null) {
                return false;
            }
            if (this.schedule != null ? !this.schedule.equals(that.schedule()) : that.schedule() != null) {
                return false;
            }
            if (this.allTriggered != that.allTriggered()) {
                return false;
            }
            if (this.halted != that.halted()) {
                return false;
            }
            if (this.reverse != that.reverse()) {
                return false;
            }
            return !(this.triggerParameters != null ? !this.triggerParameters.equals(that.triggerParameters()) : that.triggerParameters() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            result = 31 * result + (this.workflowId != null ? this.workflowId.hashCode() : 0);
            result = 31 * result + this.concurrency;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.nextTrigger != null ? this.nextTrigger.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.allTriggered ? 1231 : 1237);
            result = 31 * result + (this.halted ? 1231 : 1237);
            result = 31 * result + (this.reverse ? 1231 : 1237);
            result = 31 * result + (this.triggerParameters != null ? this.triggerParameters.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Backfill{id=" + this.id + ", start=" + this.start + ", end=" + this.end + ", workflowId=" + this.workflowId + ", concurrency=" + this.concurrency + ", description=" + this.description + ", nextTrigger=" + this.nextTrigger + ", schedule=" + this.schedule + ", allTriggered=" + this.allTriggered + ", halted=" + this.halted + ", reverse=" + this.reverse + ", triggerParameters=" + this.triggerParameters + "}";
        }
    }
}

