/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.WorkflowConfiguration;
import io.norberg.automatter.AutoMatter;

public final class SecretBuilder {
    private String name;
    private String mountPath;

    public SecretBuilder() {
    }

    private SecretBuilder(WorkflowConfiguration.Secret v) {
        this.name = v.name();
        this.mountPath = v.mountPath();
    }

    private SecretBuilder(SecretBuilder v) {
        this.name = v.name;
        this.mountPath = v.mountPath;
    }

    public String name() {
        return this.name;
    }

    public SecretBuilder name(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        return this;
    }

    public String mountPath() {
        return this.mountPath;
    }

    public SecretBuilder mountPath(String mountPath) {
        if (mountPath == null) {
            throw new NullPointerException("mountPath");
        }
        this.mountPath = mountPath;
        return this;
    }

    public WorkflowConfiguration.Secret build() {
        return new Value(this.name, this.mountPath);
    }

    public static SecretBuilder from(WorkflowConfiguration.Secret v) {
        return new SecretBuilder(v);
    }

    public static SecretBuilder from(SecretBuilder v) {
        return new SecretBuilder(v);
    }

    private static final class Value
    implements WorkflowConfiguration.Secret {
        private final String name;
        private final String mountPath;

        private Value(@AutoMatter.Field(value="name") String name, @AutoMatter.Field(value="mountPath") String mountPath) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (mountPath == null) {
                throw new NullPointerException("mountPath");
            }
            this.name = name;
            this.mountPath = mountPath;
        }

        @Override
        @AutoMatter.Field
        public String name() {
            return this.name;
        }

        @Override
        @AutoMatter.Field
        public String mountPath() {
            return this.mountPath;
        }

        @Override
        public SecretBuilder builder() {
            return new SecretBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WorkflowConfiguration.Secret)) {
                return false;
            }
            WorkflowConfiguration.Secret that = (WorkflowConfiguration.Secret)o;
            if (this.name != null ? !this.name.equals(that.name()) : that.name() != null) {
                return false;
            }
            return !(this.mountPath != null ? !this.mountPath.equals(that.mountPath()) : that.mountPath() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.mountPath != null ? this.mountPath.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "WorkflowConfiguration.Secret{name=" + this.name + ", mountPath=" + this.mountPath + "}";
        }
    }
}

