/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.common.base.Preconditions;
import com.spotify.styx.model.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
    private static final String HOURLY_CRON = "0 * * * *";
    private static final String DAILY_CRON = "0 0 * * *";
    private static final String WEEKLY_CRON = "0 0 * * MON";
    private static final String MONTHLY_CRON = "0 0 1 * *";
    private static final String YEARLY_CRON = "0 0 1 1 *";
    private static final Pattern OFFSET_PATTERN = Pattern.compile("([-+]?)P([-+0-9YMWD]+)?(T([-+0-9HMS.,]+)?)?", 2);

    private TimeUtil() {
        throw new UnsupportedOperationException();
    }

    public static Instant lastInstant(Instant instant, Schedule schedule) {
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        ZonedDateTime utcDateTime = instant.atZone(ZoneOffset.UTC);
        return instant.truncatedTo(ChronoUnit.MINUTES).equals(instant) && executionTime.isMatch(utcDateTime) ? instant : ((ZonedDateTime)executionTime.lastExecution(utcDateTime).orElseThrow(IllegalArgumentException::new)).toInstant();
    }

    public static Instant previousInstant(Instant instant, Schedule schedule) {
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        ZonedDateTime utcDateTime = instant.atZone(ZoneOffset.UTC);
        return ((ZonedDateTime)executionTime.lastExecution(utcDateTime).orElseThrow(IllegalArgumentException::new)).toInstant();
    }

    public static Instant nextInstant(Instant instant, Schedule schedule) {
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        ZonedDateTime utcDateTime = instant.atZone(ZoneOffset.UTC);
        return ((ZonedDateTime)executionTime.nextExecution(utcDateTime).orElseThrow(IllegalArgumentException::new)).toInstant();
    }

    public static List<Instant> instantsInRange(Instant firstInstant, Instant lastInstant, Schedule schedule) {
        Preconditions.checkArgument((TimeUtil.isAligned(firstInstant, schedule) && TimeUtil.isAligned(lastInstant, schedule) ? 1 : 0) != 0, (Object)"unaligned instant");
        Preconditions.checkArgument((!lastInstant.isBefore(firstInstant) ? 1 : 0) != 0, (Object)"last instant should not be before first instant");
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        ArrayList<Instant> instants = new ArrayList<Instant>();
        Instant currentInstant = firstInstant;
        while (currentInstant.isBefore(lastInstant)) {
            instants.add(currentInstant);
            ZonedDateTime utcDateTime = currentInstant.atZone(ZoneOffset.UTC);
            currentInstant = ((ZonedDateTime)executionTime.nextExecution(utcDateTime).orElseThrow(IllegalArgumentException::new)).toInstant();
        }
        return instants;
    }

    public static List<Instant> instantsInReversedRange(Instant firstInstant, Instant lastInstant, Schedule schedule) {
        Preconditions.checkArgument((TimeUtil.isAligned(firstInstant, schedule) && TimeUtil.isAligned(lastInstant, schedule) ? 1 : 0) != 0, (Object)"unaligned instant");
        Preconditions.checkArgument((!lastInstant.isAfter(firstInstant) ? 1 : 0) != 0, (Object)"last instant should not be after first instant");
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        ArrayList<Instant> instants = new ArrayList<Instant>();
        Instant currentInstant = firstInstant;
        while (currentInstant.isAfter(lastInstant)) {
            instants.add(currentInstant);
            ZonedDateTime utcDateTime = currentInstant.atZone(ZoneOffset.UTC);
            currentInstant = ((ZonedDateTime)executionTime.lastExecution(utcDateTime).orElseThrow(IllegalArgumentException::new)).toInstant();
        }
        return instants;
    }

    public static boolean isAligned(Instant instant, Schedule schedule) {
        if (!instant.truncatedTo(ChronoUnit.MINUTES).equals(instant)) {
            return false;
        }
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        ZonedDateTime utcDateTime = instant.atZone(ZoneOffset.UTC);
        return executionTime.isMatch(utcDateTime);
    }

    public static ZonedDateTime addOffset(ZonedDateTime time, String offset) {
        Matcher matcher = OFFSET_PATTERN.matcher(offset);
        if (!matcher.matches()) {
            throw new DateTimeParseException("Unable to parse offset period", offset, 0);
        }
        String sign = matcher.group(1);
        String periodOffset = sign + "P" + Optional.ofNullable(matcher.group(2)).orElse("0D");
        String durationOffset = sign + "PT" + Optional.ofNullable(matcher.group(4)).orElse("0S");
        Period dateAmount = Period.parse(periodOffset);
        Duration timeAmount = Duration.parse(durationOffset);
        return time.plus(dateAmount).plus(timeAmount);
    }

    public static ZonedDateTime subtractOffset(ZonedDateTime time, String offset) {
        if (offset.startsWith("-")) {
            return TimeUtil.addOffset(time, offset.substring(1));
        }
        return TimeUtil.addOffset(time, "-" + offset);
    }

    public static Cron cron(Schedule schedule) {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
        return new CronParser(cronDefinition).parse(TimeUtil.cronExpression(schedule));
    }

    private static String cronExpression(Schedule schedule) {
        switch (schedule.wellKnown()) {
            case HOURLY: {
                return HOURLY_CRON;
            }
            case DAILY: {
                return DAILY_CRON;
            }
            case WEEKLY: {
                return WEEKLY_CRON;
            }
            case MONTHLY: {
                return MONTHLY_CRON;
            }
            case YEARLY: {
                return YEARLY_CRON;
            }
        }
        return schedule.expression();
    }

    public static Instant offsetInstant(Instant origin, Schedule schedule, int offset) {
        Preconditions.checkArgument((boolean)TimeUtil.isAligned(origin, schedule), (Object)"unaligned origin");
        return schedule.wellKnown().unit().map(unit -> {
            try {
                return origin.plus((long)offset, (TemporalUnit)unit);
            }
            catch (UnsupportedTemporalTypeException ignored) {
                return null;
            }
        }).orElseGet(() -> {
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
            ZonedDateTime time = origin.atZone(ZoneOffset.UTC);
            for (int i = 0; i < Math.abs(offset); ++i) {
                Optional execution = offset <= 0 ? executionTime.lastExecution(time) : executionTime.nextExecution(time);
                time = (ZonedDateTime)execution.orElseThrow(AssertionError::new);
            }
            return time.toInstant();
        });
    }
}

