/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.flyte.client;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.spotify.styx.flyte.client.FlyteInputsUtils;
import flyteidl.admin.Common;
import flyteidl.admin.ExecutionOuterClass;
import flyteidl.admin.LaunchPlanOuterClass;
import flyteidl.admin.ProjectOuterClass;
import flyteidl.core.IdentifierOuterClass;
import flyteidl.core.Interface;
import flyteidl.service.AdminServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlyteAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(FlyteAdminClient.class);
    private static final String TRIGGERING_PRINCIPAL = "styx";
    private static final int USER_TRIGGERED_EXECUTION_NESTING = 0;
    private final AdminServiceGrpc.AdminServiceBlockingStub stub;

    public FlyteAdminClient(AdminServiceGrpc.AdminServiceBlockingStub stub) {
        this.stub = Objects.requireNonNull(stub, "stub");
    }

    public static FlyteAdminClient create(String target, boolean insecure) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forTarget((String)target);
        if (insecure) {
            builder.usePlaintext();
        }
        ManagedChannel channel = builder.build();
        return new FlyteAdminClient(AdminServiceGrpc.newBlockingStub((Channel)channel));
    }

    public ExecutionOuterClass.ExecutionCreateResponse createExecution(String project, String domain, String name, IdentifierOuterClass.Identifier launchPlanId, ExecutionOuterClass.ExecutionMetadata.ExecutionMode executionMode, Map<String, String> annotations, String parameter) {
        LOG.debug("createExecution {} {} {}", new Object[]{project, domain, launchPlanId});
        ExecutionOuterClass.ExecutionMetadata metadata = ExecutionOuterClass.ExecutionMetadata.newBuilder().setMode(executionMode).setPrincipal(TRIGGERING_PRINCIPAL).setNesting(0).build();
        LaunchPlanOuterClass.LaunchPlan launchPlan = this.getLaunchPlan(launchPlanId);
        Interface.ParameterMap inputs = launchPlan.getSpec().getDefaultInputs();
        ExecutionOuterClass.ExecutionSpec spec = ExecutionOuterClass.ExecutionSpec.newBuilder().setLaunchPlan(launchPlanId).setMetadata(metadata).setAnnotations(Common.Annotations.newBuilder().putAllValues(annotations).build()).build();
        ExecutionOuterClass.ExecutionCreateResponse response = this.stub.createExecution(ExecutionOuterClass.ExecutionCreateRequest.newBuilder().setDomain(domain).setProject(project).setName(name).setSpec(spec).setInputs(FlyteInputsUtils.fillParameterInInputs(inputs, parameter)).build());
        Verify.verifyNotNull((Object)response, (String)"Unexpected null response when creating execution %s on project %s domain %s for %s", (Object[])new Object[]{name, project, domain, launchPlanId});
        return response;
    }

    LaunchPlanOuterClass.LaunchPlan getLaunchPlan(IdentifierOuterClass.Identifier launchPlanId) {
        LOG.debug("getLaunchPlan {}", (Object)launchPlanId);
        Common.ObjectGetRequest request = Common.ObjectGetRequest.newBuilder().setId(launchPlanId).build();
        return this.stub.getLaunchPlan(request);
    }

    public ExecutionOuterClass.Execution getExecution(String project, String domain, String name) {
        LOG.debug("getExecution {} {} {}", new Object[]{project, domain, name});
        ExecutionOuterClass.WorkflowExecutionGetRequest request = ExecutionOuterClass.WorkflowExecutionGetRequest.newBuilder().setId(IdentifierOuterClass.WorkflowExecutionIdentifier.newBuilder().setProject(project).setDomain(domain).setName(name).build()).build();
        return this.stub.getExecution(request);
    }

    public ExecutionOuterClass.ExecutionTerminateResponse terminateExecution(String project, String domain, String name, String cause) {
        LOG.debug("terminateExecution {} {} {}", new Object[]{project, domain, name});
        ExecutionOuterClass.ExecutionTerminateRequest request = ExecutionOuterClass.ExecutionTerminateRequest.newBuilder().setId(IdentifierOuterClass.WorkflowExecutionIdentifier.newBuilder().setProject(project).setDomain(domain).setName(name).build()).setCause(cause).build();
        return this.stub.terminateExecution(request);
    }

    public ExecutionOuterClass.ExecutionList listExecutions(String project, String domain, int limit, String token, String filters) {
        LOG.debug("listExecutions {} {} {} {}", new Object[]{project, domain, limit, token});
        Common.ResourceListRequest request = Common.ResourceListRequest.newBuilder().setId(Common.NamedEntityIdentifier.newBuilder().setProject(project).setDomain(domain).build()).setLimit(limit).setToken(Strings.nullToEmpty((String)token)).setFilters(Strings.nullToEmpty((String)filters)).build();
        return this.stub.listExecutions(request);
    }

    public ProjectOuterClass.Projects listProjects() {
        LOG.debug("listProjects");
        return this.stub.listProjects(ProjectOuterClass.ProjectListRequest.getDefaultInstance());
    }
}

