/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.flyte.client;

import com.google.common.collect.ImmutableMap;
import com.spotify.styx.util.ParameterUtil;
import flyteidl.core.Interface;
import flyteidl.core.Literals;
import flyteidl.core.Types;
import java.util.Map;

public class FlyteInputsUtils {
    private FlyteInputsUtils() {
        throw new UnsupportedOperationException();
    }

    static Literals.Literal literalOf(String key, String value, Types.LiteralType literalType) {
        if (literalType.getTypeCase() != Types.LiteralType.TypeCase.SIMPLE) {
            String message = String.format("Can't get default value for input [%s]. Only DATETIME/STRING/BOOLEAN is supported but got [%s]", key, literalType);
            throw new UnsupportedOperationException(message);
        }
        switch (literalType.getSimple()) {
            case DATETIME: {
                return FlyteInputsUtils.datetimeLiteralOf(value);
            }
            case STRING: {
                return FlyteInputsUtils.stringLiteralOf(value);
            }
            case BOOLEAN: {
                return FlyteInputsUtils.booleanLiteralOf(value);
            }
        }
        String message = String.format("Can't get default value for input [%s]. Only DATETIME/STRING/BOOLEAN is supported but got [%s]", new Object[]{key, literalType.getSimple()});
        throw new UnsupportedOperationException(message);
    }

    static Literals.Literal datetimeLiteralOf(String value) {
        Literals.Primitive primitive = Literals.Primitive.newBuilder().setDatetime(ParameterUtil.parseBest((String)value)).build();
        return Literals.Literal.newBuilder().setScalar(Literals.Scalar.newBuilder().setPrimitive(primitive).build()).build();
    }

    static Literals.Literal booleanLiteralOf(String value) {
        Literals.Primitive primitive = Literals.Primitive.newBuilder().setBoolean(Boolean.parseBoolean(value)).build();
        return Literals.Literal.newBuilder().setScalar(Literals.Scalar.newBuilder().setPrimitive(primitive).build()).build();
    }

    static Literals.Literal stringLiteralOf(String value) {
        Literals.Primitive primitive = Literals.Primitive.newBuilder().setStringValue(value).build();
        return Literals.Literal.newBuilder().setScalar(Literals.Scalar.newBuilder().setPrimitive(primitive).build()).build();
    }

    static Literals.Literal getDefaultValue(String key, Interface.Parameter parameter, Map<String, String> extraDefaultInputs) {
        String lowercaseKey = key.toLowerCase();
        String extraDefaultInput = extraDefaultInputs.get(lowercaseKey);
        if (extraDefaultInput != null) {
            return FlyteInputsUtils.literalOf(key, extraDefaultInput, parameter.getVar().getType());
        }
        if (parameter.hasDefault()) {
            return parameter.getDefault();
        }
        throw new UnsupportedOperationException("Can't find default value for launch plan input: " + key);
    }

    static Literals.LiteralMap fillParameterInInputs(Interface.ParameterMap parameterMap, Map<String, String> extraDefaultInputs) {
        Literals.LiteralMap.Builder literalMapBuilder = Literals.LiteralMap.newBuilder();
        ImmutableMap lowercaseExtraDefaultInputs = (ImmutableMap)extraDefaultInputs.entrySet().stream().collect(ImmutableMap.toImmutableMap(x -> ((String)x.getKey()).toLowerCase(), Map.Entry::getValue));
        parameterMap.getParametersMap().forEach((key, parameter) -> literalMapBuilder.putLiterals((String)key, FlyteInputsUtils.getDefaultValue(key, parameter, (Map<String, String>)lowercaseExtraDefaultInputs)));
        return literalMapBuilder.build();
    }
}

