/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.flyte.client;

import com.google.common.collect.ImmutableMap;
import com.spotify.styx.util.ParameterUtil;
import flyteidl.core.Interface;
import flyteidl.core.Literals;
import flyteidl.core.Types;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class FlyteInputsUtils {
    private FlyteInputsUtils() {
        throw new UnsupportedOperationException();
    }

    static Literals.Literal literalOf(String key, String value, Types.LiteralType literalType) {
        if (literalType.getTypeCase() != Types.LiteralType.TypeCase.SIMPLE) {
            String message = String.format("Can't get default value for input [%s]. Only DATETIME/STRING/BOOLEAN is supported but got [%s]", key, literalType);
            throw new UnsupportedOperationException(message);
        }
        switch (literalType.getSimple()) {
            case DATETIME: {
                return FlyteInputsUtils.datetimeLiteralOf(value);
            }
            case STRING: {
                return FlyteInputsUtils.stringLiteralOf(value);
            }
            case BOOLEAN: {
                return FlyteInputsUtils.booleanLiteralOf(value);
            }
        }
        String message = String.format("Can't get default value for input [%s]. Only DATETIME/STRING/BOOLEAN is supported but got [%s]", new Object[]{key, literalType.getSimple()});
        throw new UnsupportedOperationException(message);
    }

    static Literals.Literal datetimeLiteralOf(String value) {
        Literals.Primitive primitive = Literals.Primitive.newBuilder().setDatetime(ParameterUtil.parseBest((String)value)).build();
        return Literals.Literal.newBuilder().setScalar(Literals.Scalar.newBuilder().setPrimitive(primitive).build()).build();
    }

    static Literals.Literal booleanLiteralOf(String value) {
        Literals.Primitive primitive = Literals.Primitive.newBuilder().setBoolean(Boolean.parseBoolean(value)).build();
        return Literals.Literal.newBuilder().setScalar(Literals.Scalar.newBuilder().setPrimitive(primitive).build()).build();
    }

    static Literals.Literal stringLiteralOf(String value) {
        Literals.Primitive primitive = Literals.Primitive.newBuilder().setStringValue(value).build();
        return Literals.Literal.newBuilder().setScalar(Literals.Scalar.newBuilder().setPrimitive(primitive).build()).build();
    }

    static Literals.Literal getDefaultValue(String key, Interface.Parameter parameter, Map<String, String> extraDefaultInputs, Map<String, String> triggerParameters) {
        String lowercaseKey = key.toLowerCase();
        String triggerParam = triggerParameters.get(lowercaseKey);
        if (triggerParam != null) {
            return FlyteInputsUtils.literalOf(key, triggerParam, parameter.getVar().getType());
        }
        String extraDefaultInput = extraDefaultInputs.get(lowercaseKey);
        if (extraDefaultInput != null) {
            return FlyteInputsUtils.literalOf(key, extraDefaultInput, parameter.getVar().getType());
        }
        if (parameter.hasDefault()) {
            return parameter.getDefault();
        }
        throw new UnsupportedOperationException("Can't find default value for launch plan input: " + key);
    }

    static Literals.LiteralMap fillParameterInInputs(Interface.ParameterMap parameterMap, Map<String, String> userDefinedInputs, Map<String, String> styxVariables, Map<String, String> triggerParams) {
        Set lowercaseInputs;
        Set paramsKeysInLowercase = parameterMap.getParametersMap().keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (!paramsKeysInLowercase.containsAll(lowercaseInputs = userDefinedInputs.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet()))) {
            List unMatchedInputKeys = userDefinedInputs.keySet().stream().filter(key -> !paramsKeysInLowercase.contains(key.toLowerCase())).collect(Collectors.toList());
            throw new UnsupportedOperationException("Inputs don't correspond with launch plans inputs: " + unMatchedInputKeys);
        }
        Literals.LiteralMap.Builder literalMapBuilder = Literals.LiteralMap.newBuilder();
        ImmutableMap combinedInputsLowerCase = (ImmutableMap)FlyteInputsUtils.combineMapsCaseInsensitiveWithOrder(userDefinedInputs, styxVariables).entrySet().stream().collect(ImmutableMap.toImmutableMap(x -> ((String)x.getKey()).toLowerCase(), Map.Entry::getValue));
        ImmutableMap triggerParamsToLowerCase = (ImmutableMap)triggerParams.entrySet().stream().collect(ImmutableMap.toImmutableMap(x -> ((String)x.getKey()).toLowerCase(), Map.Entry::getValue));
        parameterMap.getParametersMap().forEach((key, parameter) -> literalMapBuilder.putLiterals((String)key, FlyteInputsUtils.getDefaultValue(key, parameter, (Map<String, String>)combinedInputsLowerCase, (Map<String, String>)triggerParamsToLowerCase)));
        return literalMapBuilder.build();
    }

    public static Map<String, String> combineMapsCaseInsensitiveWithOrder(Map<String, String> map1, Map<String, String> map2) {
        TreeMap<String, String> inputsMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        inputsMap.putAll(map1);
        inputsMap.putAll(map2);
        return ImmutableMap.copyOf(inputsMap);
    }
}

