/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.flyte.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class GrpcClientMetadataInterceptor
implements ClientInterceptor {
    private final String rpcOriginValue;
    static final Metadata.Key<String> RPC_ORIGIN_HEADER_KEY = Metadata.Key.of((String)"rpc-origin", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    private GrpcClientMetadataInterceptor(String rpcOriginValue) {
        this.rpcOriginValue = rpcOriginValue;
    }

    public static GrpcClientMetadataInterceptor create(String rpcOriginValue) {
        return new GrpcClientMetadataInterceptor(rpcOriginValue);
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                Metadata metadata = new Metadata();
                metadata.put(RPC_ORIGIN_HEADER_KEY, (Object)GrpcClientMetadataInterceptor.this.rpcOriginValue);
                headers.merge(metadata);
                super.start(responseListener, headers);
            }
        };
    }
}

