/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.flyte.client;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class RpcHelper {
    private RpcHelper() {
    }

    public static String getExecutionsListFilter(Instant timeNow, Duration since, Duration to) {
        String dateSince = timeNow.minus(since).atZone(ZoneId.of("UTC")).toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        String dateTo = timeNow.minus(to).atZone(ZoneId.of("UTC")).toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        return String.format("value_in(phase,RUNNING)+gte(started_at,%s)+lte(started_at,%s)", dateSince, dateTo);
    }
}

