/*
 * -\-\-
 * Spotify Styx Scheduler Service
 * --
 * Copyright (C) 2018 Spotify AB
 * --
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -/-/-
 */

package com.spotify.styx.util;

import java.util.UUID;
import org.hamcrest.Description;

import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class StringIsValidUuid extends TypeSafeMatcher<String> {

  @Override
  protected boolean matchesSafely(String s) {
    final String uuid = !s.contains("-")
        ? s.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")
        : s;
    try {
      UUID.fromString(uuid);
      return true;
    } catch (IllegalArgumentException e) {
      return false;
    }
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("a string that is a valid UUID");
  }

  public static Matcher<String> isValidUuid() {
    return new StringIsValidUuid();
  }
}
