/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import java.util.UUID;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class StringIsValidUuid
extends TypeSafeMatcher<String> {
    protected boolean matchesSafely(String s) {
        String uuid = !s.contains("-") ? s.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5") : s;
        try {
            UUID.fromString(uuid);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a string that is a valid UUID");
    }

    @Factory
    public static Matcher<String> isValidUuid() {
        return new StringIsValidUuid();
    }
}

