/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.bigtable.hbase.adapters.read.RowCell;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class BigtableMocker {
    private final Connection bigtable;
    private int numFailures = 0;
    private final Map<TableName, List<Cell>> tableCells = Maps.newHashMap();

    public BigtableMocker(Connection bigtable) {
        this.bigtable = bigtable;
    }

    private void addRowsToTable(TableName tableName, List<Cell> moreCells) throws IOException {
        this.tableCells.merge(tableName, moreCells, (oldValue, value) -> {
            oldValue.addAll(moreCells);
            return oldValue;
        });
        this.finalizeMocking();
    }

    private void removeRowsFromTable(TableName tableName, List<Cell> removeCells) throws IOException {
        this.tableCells.computeIfPresent(tableName, (key, value) -> {
            ArrayList newCells = Lists.newArrayList();
            value.removeAll(removeCells);
            return newCells;
        });
        this.finalizeMocking();
    }

    public BigtableMocker setupTable(TableName tableName) {
        this.tableCells.put(tableName, Lists.newArrayList());
        return this;
    }

    public void finalizeMocking() throws IOException {
        for (Map.Entry<TableName, List<Cell>> tableEntry : this.tableCells.entrySet()) {
            TableName tableName = tableEntry.getKey();
            List<Cell> cells = tableEntry.getValue();
            Table table = (Table)Mockito.mock(Table.class);
            Mockito.when((Object)this.bigtable.getTable(tableName)).thenReturn((Object)table);
            Mockito.when((Object)table.get((Get)ArgumentMatchers.any(Get.class))).thenAnswer(invocation -> this.resultOfGet(cells, (Get)invocation.getArgument(0)));
            Mockito.when((Object)table.getScanner((byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.any(byte[].class))).thenAnswer(invocation -> this.resultOfFullScan(cells, (byte[])invocation.getArgument(0), (byte[])invocation.getArgument(1)));
            Mockito.when((Object)table.getScanner((Scan)ArgumentMatchers.any(Scan.class))).thenAnswer(invocation -> this.resultOfScan(cells, (Scan)invocation.getArgument(0)));
            ((Table)Mockito.doAnswer(invocation -> {
                if (this.numFailures > 0) {
                    --this.numFailures;
                    throw new IOException("Something went wrong in performing put operation");
                }
                Put put = (Put)invocation.getArgument(0);
                ArrayList list = Lists.newArrayList();
                put.getFamilyCellMap().values().forEach(list2 -> list2.forEach(kv -> {
                    Cell cell = this.getCell((Cell)kv);
                    list.add(cell);
                }));
                this.addRowsToTable(tableName, list);
                return null;
            }).when((Object)table)).put((Put)ArgumentMatchers.any(Put.class));
            ((Table)Mockito.doAnswer(invocation -> {
                if (this.numFailures > 0) {
                    --this.numFailures;
                    throw new IOException("Something went wrong in performing delete operation");
                }
                Delete delete = (Delete)invocation.getArgument(0);
                ArrayList list = Lists.newArrayList();
                delete.getFamilyCellMap().values().forEach(list2 -> list2.forEach(kv -> {
                    Cell cell = this.getCell((Cell)kv);
                    list.add(cell);
                }));
                this.removeRowsFromTable(tableName, list);
                return null;
            }).when((Object)table)).delete((Delete)ArgumentMatchers.any(Delete.class));
        }
    }

    private Cell getCell(Cell kv) {
        byte[] rowArray = Arrays.copyOfRange(kv.getRowArray(), kv.getRowOffset(), kv.getRowOffset() + kv.getRowLength());
        byte[] familyArray = Arrays.copyOfRange(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyOffset() + kv.getFamilyLength());
        byte[] qualifierArray = Arrays.copyOfRange(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierOffset() + kv.getQualifierLength());
        long timestamp = kv.getTimestamp();
        byte[] valueArray = Arrays.copyOfRange(kv.getValueArray(), kv.getValueOffset(), kv.getValueOffset() + kv.getValueLength());
        return new RowCell(rowArray, familyArray, qualifierArray, timestamp, valueArray);
    }

    private Result resultOfGet(List<Cell> cells, Get get) {
        byte[] row = get.getRow();
        return cells.stream().filter(cell -> Bytes.equals((byte[])cell.getRowArray(), (byte[])row)).findFirst().map(cell -> Result.create((Cell[])new Cell[]{cell})).orElseGet(() -> Result.create(Collections.emptyList()));
    }

    private ResultScanner resultOfScan(List<Cell> cells, Scan scan) throws IOException {
        byte[] startRow = scan.getStartRow();
        byte[] stopRow = scan.getStopRow();
        List inRangeResults = cells.stream().filter(cell -> Bytes.compareTo((byte[])startRow, (byte[])cell.getRowArray()) <= 0 && Bytes.compareTo((byte[])stopRow, (byte[])cell.getRowArray()) > 0).map(cell -> Result.create((Cell[])new Cell[]{cell})).collect(Collectors.toList());
        ResultScanner resultScanner = (ResultScanner)Mockito.mock(ResultScanner.class);
        Mockito.when((Object)resultScanner.iterator()).thenReturn(inRangeResults.iterator());
        if (!inRangeResults.isEmpty()) {
            Result first = (Result)inRangeResults.get(0);
            Object[] rest = inRangeResults.subList(1, inRangeResults.size()).toArray(new Result[inRangeResults.size()]);
            rest[rest.length - 1] = null;
            Mockito.when((Object)resultScanner.next()).thenReturn((Object)first, rest);
        }
        return resultScanner;
    }

    private ResultScanner resultOfFullScan(List<Cell> cells, byte[] family, byte[] qualifier) {
        List inRangeResults = cells.stream().filter(cell -> Bytes.equals((byte[])family, (byte[])cell.getFamilyArray()) && Bytes.equals((byte[])qualifier, (byte[])cell.getQualifierArray())).map(cell -> Result.create((Cell[])new Cell[]{cell})).collect(Collectors.toList());
        ResultScanner resultScanner = (ResultScanner)Mockito.mock(ResultScanner.class);
        Mockito.when((Object)resultScanner.iterator()).thenReturn(inRangeResults.iterator());
        return resultScanner;
    }

    public BigtableMocker setNumFailures(int numFailures) {
        this.numFailures = numFailures;
        return this;
    }
}

