/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.testing.LocalDatastoreHelper;
import com.google.cloud.testing.BaseEmulatorHelper;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaslang.control.Try;
import org.junit.rules.ExternalResource;

public class DatastoreEmulator
extends ExternalResource {
    private final LocalDatastoreHelper helper;

    public DatastoreEmulator(double consistency) {
        this.helper = LocalDatastoreHelper.create((double)consistency);
    }

    public DatastoreEmulator() {
        this(1.0);
    }

    protected void before() {
        Try.run(() -> ((LocalDatastoreHelper)this.helper).start()).get();
        this.assertGcloudDatastoreEmulator();
    }

    protected void after() {
        Try.run(() -> ((LocalDatastoreHelper)this.helper).stop()).get();
    }

    public DatastoreOptions options() {
        return ((DatastoreOptions.Builder)this.helper.getOptions().toBuilder().setRetrySettings(DatastoreOptions.getDefaultRetrySettings())).build();
    }

    public Datastore client() {
        return (Datastore)this.options().getService();
    }

    public void reset() {
        Try.run(() -> ((LocalDatastoreHelper)this.helper).reset()).get();
    }

    private void assertGcloudDatastoreEmulator() {
        Class runnerClass = (Class)Try.of(() -> {
            Field activeRunnerField = BaseEmulatorHelper.class.getDeclaredField("activeRunner");
            activeRunnerField.setAccessible(true);
            Object activeRunner = activeRunnerField.get(this.helper);
            return activeRunner.getClass();
        }).get();
        if (!runnerClass.getName().equals("com.google.cloud.testing.BaseEmulatorHelper$GcloudEmulatorRunner")) {
            throw new AssertionError((Object)"Not using gcloud sdk datastore emulator, please run: gcloud components install beta cloud-datastore-emulator");
        }
    }

    static {
        Logger.getLogger(LocalDatastoreHelper.class.getName()).setLevel(Level.OFF);
    }
}

