/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.voyager.jni;

import com.spotify.voyager.jni.utils.JniLibExtractor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Index
implements Closeable {
    private final long nativeHandle = 0L;

    private Index() {
    }

    public Index(SpaceType space, int numDimensions) {
        this.nativeConstructor(space, numDimensions, 16L, 200L, 1L, 1L, StorageDataType.Float32);
    }

    public Index(SpaceType space, int numDimensions, long indexM, long efConstruction, long randomSeed, long maxElements, StorageDataType storageDataType) {
        this.nativeConstructor(space, numDimensions, indexM, efConstruction, randomSeed, maxElements, storageDataType);
    }

    public static Index load(String filename, SpaceType space, int numDimensions, StorageDataType storageDataType) {
        Index index = new Index();
        index.nativeLoadFromFile(filename, space, numDimensions, storageDataType);
        return index;
    }

    public static Index load(InputStream inputStream, SpaceType space, int numDimensions, StorageDataType storageDataType) {
        Index index = new Index();
        index.nativeLoadFromInputStream(inputStream, space, numDimensions, storageDataType);
        return index;
    }

    @Override
    public void close() throws IOException {
        this.nativeDestructor();
    }

    private native void nativeConstructor(SpaceType var1, int var2, long var3, long var5, long var7, long var9, StorageDataType var11);

    private native void nativeLoadFromFile(String var1, SpaceType var2, int var3, StorageDataType var4);

    private native void nativeLoadFromInputStream(InputStream var1, SpaceType var2, int var3, StorageDataType var4);

    private native void nativeDestructor();

    public native void setEf(long var1);

    public native int getEf();

    public native SpaceType getSpace();

    public native int getNumDimensions();

    public native void setNumThreads(int var1);

    public native int getNumThreads();

    public native void saveIndex(String var1);

    public native void saveIndex(OutputStream var1);

    public native void addItem(float[] var1);

    public native void addItem(float[] var1, long var2);

    public native void addItems(float[][] var1, int var2);

    public native void addItems(float[][] var1, long[] var2, int var3);

    public native float[] getVector(long var1);

    public native float[][] getVectors(long[] var1);

    public native long[] getIDs();

    public QueryResults query(float[] queryVector, int k) {
        return this.query(queryVector, k, -1L);
    }

    public QueryResults[] query(float[][] queryVectors, int k, int numThreads) {
        return this.query(queryVectors, k, numThreads, -1L);
    }

    public native QueryResults query(float[] var1, int var2, long var3);

    public native QueryResults[] query(float[][] var1, int var2, int var3, long var4);

    public native void markDeleted(long var1);

    public native void unmarkDeleted(long var1);

    public native void resizeIndex(long var1);

    public native long getMaxElements();

    public native long getNumElements();

    public native long getEfConstruction();

    public native long getM();

    static {
        System.load(JniLibExtractor.extractBinaries("voyager"));
    }

    public static class QueryResults {
        public final long[] labels;
        public final float[] distances;

        public QueryResults(long[] labels, float[] distances) {
            if (labels.length != distances.length) {
                throw new IllegalArgumentException("Labels and distances must have matching length!");
            }
            this.labels = labels;
            this.distances = distances;
        }

        public String toString() {
            return "QueryResult(labels=" + Arrays.toString(this.labels) + ", distances=" + Arrays.toString(this.distances) + ")";
        }

        public long[] getLabels() {
            return this.labels;
        }

        public float[] getDistances() {
            return this.distances;
        }
    }

    public static enum StorageDataType {
        Float8,
        Float32,
        E4M3;

    }

    public static enum SpaceType {
        Euclidean,
        InnerProduct,
        Cosine;

    }
}

