/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.voyager.jni;

import com.spotify.voyager.jni.Index;
import com.spotify.voyager.jni.utils.TinyJson;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StringIndex
implements Closeable {
    private static final String INDEX_FILE_NAME = "index.hnsw";
    private static final String NAMES_LIST_FILE_NAME = "names.json";
    private static final int DEFAULT_BUFFER_SIZE = 0x6400000;
    private final Index index;
    private final List<String> names;

    public StringIndex(Index.SpaceType spaceType, int numDimensions) {
        this.index = new Index(spaceType, numDimensions);
        this.names = new ArrayList<String>();
    }

    public StringIndex(Index.SpaceType spaceType, int numDimensions, long indexM, long efConstruction, long randomSeed, long maxElements, Index.StorageDataType storageDataType) {
        this.index = new Index(spaceType, numDimensions, indexM, efConstruction, randomSeed, maxElements, storageDataType);
        this.names = new ArrayList<String>();
    }

    private StringIndex(Index index, List<String> names) {
        this.index = index;
        this.names = names;
    }

    public static StringIndex load(String indexFilename, String nameListFilename, Index.SpaceType spaceType, int numDimensions, Index.StorageDataType storageDataType) {
        List<String> names;
        Index index = Index.load(indexFilename, spaceType, numDimensions, storageDataType);
        try {
            names = TinyJson.readStringList(Files.newInputStream(Paths.get(nameListFilename, new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading names list from: " + nameListFilename, e);
        }
        return new StringIndex(index, names);
    }

    public static StringIndex load(InputStream indexInputStream, InputStream nameListInputStream, Index.SpaceType spaceType, int numDimensions, Index.StorageDataType storageDataType) {
        Index index = Index.load(new BufferedInputStream(indexInputStream, 0x6400000), spaceType, numDimensions, storageDataType);
        List<String> names = TinyJson.readStringList(new BufferedInputStream(nameListInputStream, 0x6400000));
        return new StringIndex(index, names);
    }

    public void saveIndex(String outputDirectory) throws IOException {
        Path indexPath = Paths.get(outputDirectory, INDEX_FILE_NAME);
        Path namesPath = Paths.get(outputDirectory, NAMES_LIST_FILE_NAME);
        try {
            this.index.saveIndex(indexPath.toString());
            OutputStream outputStream = Files.newOutputStream(namesPath, new OpenOption[0]);
            TinyJson.writeStringList(this.names, outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            Files.deleteIfExists(indexPath);
            Files.deleteIfExists(namesPath);
            throw e;
        }
    }

    public void saveIndex(OutputStream indexOutputStream, OutputStream namesListOutputStream) throws IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(indexOutputStream, 0x6400000);
        this.index.saveIndex(outputStream);
        TinyJson.writeStringList(this.names, namesListOutputStream);
        outputStream.flush();
        outputStream.close();
        namesListOutputStream.flush();
        namesListOutputStream.close();
    }

    public void addItem(String name, float[] vector) {
        int nextIndex = this.names.size();
        this.index.addItem(vector, nextIndex);
        this.names.add(name);
    }

    public void addItem(String name, List<Float> vector) {
        this.addItem(name, this.toPrimitive(vector));
    }

    public void addItems(Map<String, List<Float>> vectors) {
        int numVectors = vectors.size();
        ArrayList<String> newNames = new ArrayList<String>(numVectors);
        float[][] primitiveVectors = new float[numVectors][this.index.getNumDimensions()];
        long[] labels = new long[numVectors];
        Iterator<Map.Entry<String, List<Float>>> iterator = vectors.entrySet().iterator();
        for (int i = 0; i < numVectors; ++i) {
            Map.Entry<String, List<Float>> nextVector = iterator.next();
            newNames.add(nextVector.getKey());
            this.assignPrimitive(nextVector.getValue(), primitiveVectors[i]);
            labels[i] = this.names.size() + i;
        }
        this.names.addAll(newNames);
        this.index.addItems(primitiveVectors, labels, -1);
    }

    private float[] toPrimitive(List<Float> vector) {
        float[] vectorValues = new float[vector.size()];
        this.assignPrimitive(vector, vectorValues);
        return vectorValues;
    }

    private void assignPrimitive(List<Float> vector, float[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = vector.get(i).floatValue();
        }
    }

    public QueryResults query(float[] queryVector, int numNeighbors, int ef) {
        String[] resultNames = new String[numNeighbors];
        float[] distances = new float[numNeighbors];
        Index.QueryResults idxResults = this.index.query(queryVector, numNeighbors, (long)ef);
        for (int i = 0; i < idxResults.getLabels().length; ++i) {
            String name;
            long indexId = idxResults.getLabels()[i];
            float dist = idxResults.getDistances()[i];
            if (indexId > Integer.MAX_VALUE || indexId < Integer.MIN_VALUE) {
                throw new ArrayIndexOutOfBoundsException("Voyager index returned a label (" + indexId + ") which is out of range for StringIndex. This index may not be compatible with Voyager's Java bindings, or the index file may be corrupt.");
            }
            resultNames[i] = name = this.names.get((int)indexId);
            distances[i] = dist;
        }
        return new QueryResults(resultNames, distances);
    }

    @Override
    public void close() throws IOException {
        this.index.close();
    }

    public static class QueryResults {
        private final String[] names;
        private final float[] distances;

        public QueryResults(String[] names, float[] distances) {
            this.names = names;
            this.distances = distances;
        }

        public String[] getNames() {
            return this.names;
        }

        public float[] getDistances() {
            return this.distances;
        }

        public String getName(int index) {
            return this.names[index];
        }

        public float getDistance(int index) {
            return this.distances[index];
        }

        public int getNumResults() {
            return this.names.length;
        }

        public String toString() {
            return "QueryResults{names=" + Arrays.toString(this.names) + ", distances=" + Arrays.toString(this.distances) + '}';
        }
    }
}

