/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.voyager.jni.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class JniLibExtractor {
    public static String extractBinaries(String libname) {
        String mappedLibname = System.mapLibraryName(libname);
        String libPath = String.format("/%s/%s", JniLibExtractor.platform(), mappedLibname);
        InputStream library = JniLibExtractor.class.getResourceAsStream(libPath);
        if (library == null) {
            throw new RuntimeException("Could not find JNI library file to load at path: " + libPath);
        }
        try {
            Path temp = Files.createTempDirectory("", new FileAttribute[0]).resolve(mappedLibname);
            Files.copy(library, temp, new CopyOption[0]);
            temp.toFile().deleteOnExit();
            return temp.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String platform() {
        String osArch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name").toLowerCase();
        if (osArch.equals("x86_64") || osArch.equals("amd64")) {
            osArch = "x64";
        }
        if (osName.contains("mac")) {
            return "mac-" + osArch;
        }
        if (osName.contains("linux")) {
            return "linux-" + osArch;
        }
        if (osName.contains("win")) {
            return "win-" + osArch;
        }
        throw new RuntimeException("com.spotify.voyager currently only runs on macOS, Linux, and Windows.");
    }
}

