/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.voyager.jni.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class TinyJson {
    public static List<String> readStringList(InputStream stream) {
        String token;
        Scanner scanner = new Scanner(stream).useDelimiter("\"");
        ArrayList<String> outputList = new ArrayList<String>();
        boolean insideString = false;
        while (true) {
            token = scanner.next();
            if (insideString) {
                outputList.add(token);
                insideString = false;
                continue;
            }
            if (!(token = token.trim()).equals(",") && !token.equals("[")) break;
            insideString = true;
        }
        if (!token.equals("]") && !token.equals("[]")) {
            throw new IllegalArgumentException("Unexpected token found when parsing JSON list: " + token);
        }
        return outputList;
    }

    public static void writeStringList(Iterable<String> items, OutputStream stream) throws IOException {
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(stream));
        output.write("[");
        boolean isFirst = true;
        for (String item : items) {
            if (!isFirst) {
                output.write(44);
            }
            isFirst = false;
            output.write(34);
            if (item.contains("\\") || item.contains("\"")) {
                throw new IllegalArgumentException("Voyager string keys may not contain backslashes or double quotes, but found key: " + item);
            }
            output.write(item);
            output.write(34);
        }
        output.write("]");
        output.flush();
    }
}

