/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.mediarouter.v7.api.media;

import android.support.v7.media.MediaItemStatus;
import org.assertj.android.internal.BitmaskUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class MediaItemStatusAssert
extends AbstractAssert<MediaItemStatusAssert, MediaItemStatus> {
    public MediaItemStatusAssert(MediaItemStatus actual) {
        super((Object)actual, MediaItemStatusAssert.class);
    }

    public MediaItemStatusAssert hasContentDuration(long duration) {
        this.isNotNull();
        long actualDuration = ((MediaItemStatus)this.actual).getContentDuration();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDuration).overridingErrorMessage("Expected content duration <%s> but was <%s>.", new Object[]{duration, actualDuration})).isEqualTo(duration);
        return this;
    }

    public MediaItemStatusAssert hasContentPosition(long position) {
        this.isNotNull();
        long actualPosition = ((MediaItemStatus)this.actual).getContentPosition();
        ((AbstractLongAssert)Assertions.assertThat((long)actualPosition).overridingErrorMessage("Expected content position <%s> but was <%s>.", new Object[]{position, actualPosition})).isEqualTo(position);
        return this;
    }

    public MediaItemStatusAssert hasPlaybackState(int state) {
        this.isNotNull();
        int actualState = ((MediaItemStatus)this.actual).getPlaybackState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualState).overridingErrorMessage("Expected playback state <%s> but was <%s>.", new Object[]{MediaItemStatusAssert.playbackStateToString(state), MediaItemStatusAssert.playbackStateToString(actualState)})).isEqualTo(state);
        return this;
    }

    public MediaItemStatusAssert hasTimestamp(long timestamp) {
        this.isNotNull();
        long actualTimestamp = ((MediaItemStatus)this.actual).getTimestamp();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTimestamp).overridingErrorMessage("Expected timestamp <%s> but was <%s>.", new Object[]{timestamp, actualTimestamp})).isEqualTo(timestamp);
        return this;
    }

    public static String playbackStateToString(int playbackState) {
        return BitmaskUtils.buildNamedValueString((long)playbackState).value(3L, "buffering").value(5L, "canceled").value(7L, "error").value(4L, "finished").value(6L, "invalidated").value(2L, "paused").value(0L, "pending").value(1L, "playing").get();
    }
}

