/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.mediarouter.v7.api.media;

import android.support.v7.media.MediaSessionStatus;
import org.assertj.android.internal.BitmaskUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class MediaSessionStatusAssert
extends AbstractAssert<MediaSessionStatusAssert, MediaSessionStatus> {
    public MediaSessionStatusAssert(MediaSessionStatus actual) {
        super((Object)actual, MediaSessionStatusAssert.class);
    }

    public MediaSessionStatusAssert hasSessionState(int state) {
        this.isNotNull();
        int actualState = ((MediaSessionStatus)this.actual).getSessionState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualState).overridingErrorMessage("Expected session state <%s> but was <%s>.", new Object[]{MediaSessionStatusAssert.sessionStateToString(state), MediaSessionStatusAssert.sessionStateToString(actualState)})).isEqualTo(state);
        return this;
    }

    public MediaSessionStatusAssert hasTimestamp(long timestamp) {
        this.isNotNull();
        long actualTimestamp = ((MediaSessionStatus)this.actual).getTimestamp();
        ((AbstractLongAssert)Assertions.assertThat((long)actualTimestamp).overridingErrorMessage("Expected timestamp <%s> but was <%s>.", new Object[]{timestamp, actualTimestamp})).isEqualTo(timestamp);
        return this;
    }

    public MediaSessionStatusAssert hasQueuePaused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MediaSessionStatus)this.actual).isQueuePaused()).overridingErrorMessage("Expected queue to be paused but was not.", new Object[0])).isTrue();
        return this;
    }

    public MediaSessionStatusAssert doesNotHaveQueuePaused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MediaSessionStatus)this.actual).isQueuePaused()).overridingErrorMessage("Expected queue to not be paused but was.", new Object[0])).isFalse();
        return this;
    }

    public static String sessionStateToString(int state) {
        return BitmaskUtils.buildNamedValueString((long)state).value(0L, "active").value(1L, "ended").value(2L, "invalidated").get();
    }
}

