/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.mediarouter.v7.api.media;

import android.support.v7.media.RemotePlaybackClient;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;

public class RemotePlaybackClientAssert
extends AbstractAssert<RemotePlaybackClientAssert, RemotePlaybackClient> {
    public RemotePlaybackClientAssert(RemotePlaybackClient actual) {
        super((Object)actual, RemotePlaybackClientAssert.class);
    }

    public RemotePlaybackClientAssert hasSessionId(String sessionId) {
        this.isNotNull();
        String actualSessionId = ((RemotePlaybackClient)this.actual).getSessionId();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualSessionId).overridingErrorMessage("Expected session ID <%s> but was <%s>.", new Object[]{sessionId, actualSessionId})).isEqualTo((Object)sessionId);
        return this;
    }

    public RemotePlaybackClientAssert hasSession() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RemotePlaybackClient)this.actual).hasSession()).overridingErrorMessage("Expected to have session but did not.", new Object[0])).isTrue();
        return this;
    }

    public RemotePlaybackClientAssert doesNotHaveSession() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RemotePlaybackClient)this.actual).hasSession()).overridingErrorMessage("Expected to not have session but did.", new Object[0])).isFalse();
        return this;
    }

    public RemotePlaybackClientAssert hasQueuingSupported() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RemotePlaybackClient)this.actual).isQueuingSupported()).overridingErrorMessage("Expected to have queuing supported but did not.", new Object[0])).isTrue();
        return this;
    }

    public RemotePlaybackClientAssert doesNotHaveQueuingSupported() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RemotePlaybackClient)this.actual).isQueuingSupported()).overridingErrorMessage("Expected to not have queuing supported but did.", new Object[0])).isFalse();
        return this;
    }

    public RemotePlaybackClientAssert hasRemotePlaybackSupported() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RemotePlaybackClient)this.actual).isRemotePlaybackSupported()).overridingErrorMessage("Expected to have remote playback supported but did not.", new Object[0])).isTrue();
        return this;
    }

    public RemotePlaybackClientAssert doesNotHaveRemotePlaybackSupported() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RemotePlaybackClient)this.actual).isRemotePlaybackSupported()).overridingErrorMessage("Expected to not have remote playback supported but did.", new Object[0])).isFalse();
        return this;
    }

    public RemotePlaybackClientAssert hasSessionManagementSupported() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RemotePlaybackClient)this.actual).isSessionManagementSupported()).overridingErrorMessage("Expected to have session management supported but did not.", new Object[0])).isTrue();
        return this;
    }

    public RemotePlaybackClientAssert doesNotHaveSessionManagementSupported() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RemotePlaybackClient)this.actual).isSessionManagementSupported()).overridingErrorMessage("Expected to not have session management supported but did.", new Object[0])).isFalse();
        return this;
    }
}

