/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.recyclerview.v7.api.widget;

import android.support.v7.widget.RecyclerView;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class RecyclerViewAdapterAssert<VH extends RecyclerView.ViewHolder>
extends AbstractAssert<RecyclerViewAdapterAssert<VH>, RecyclerView.Adapter<VH>> {
    public RecyclerViewAdapterAssert(RecyclerView.Adapter<VH> actual) {
        super(actual, RecyclerViewAdapterAssert.class);
    }

    public RecyclerViewAdapterAssert<VH> hasItemCount(int count) {
        this.isNotNull();
        int actualCount = ((RecyclerView.Adapter)this.actual).getItemCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected item count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public RecyclerViewAdapterAssert<VH> hasStableIds() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.Adapter)this.actual).hasStableIds()).overridingErrorMessage("Expected to have stable IDs but did not.", new Object[0])).isTrue();
        return this;
    }

    public RecyclerViewAdapterAssert<VH> doesNotHaveStableIds() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.Adapter)this.actual).hasStableIds()).overridingErrorMessage("Expected to not have stable IDs but did.", new Object[0])).isFalse();
        return this;
    }

    public RecyclerViewAdapterAssert<VH> hasObservers() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.Adapter)this.actual).hasObservers()).overridingErrorMessage("Expected to have observers but did not.", new Object[0])).isTrue();
        return this;
    }

    public RecyclerViewAdapterAssert<VH> doesNotHaveObservers() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.Adapter)this.actual).hasObservers()).overridingErrorMessage("Expected to not have observers but did.", new Object[0])).isFalse();
        return this;
    }
}

