/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.recyclerview.v7.api.widget;

import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import org.assertj.android.api.view.AbstractViewGroupAssert;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class RecyclerViewAssert
extends AbstractViewGroupAssert<RecyclerViewAssert, RecyclerView> {
    public RecyclerViewAssert(RecyclerView actual) {
        super((ViewGroup)actual, RecyclerViewAssert.class);
    }

    public <VH extends RecyclerView.ViewHolder> RecyclerViewAssert hasAdapter(RecyclerView.Adapter<VH> adapter) {
        this.isNotNull();
        RecyclerView.Adapter actualAdapter = ((RecyclerView)this.actual).getAdapter();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualAdapter).overridingErrorMessage("Expected adapter <%s> but was <%s>.", new Object[]{adapter, actualAdapter})).isEqualTo(adapter);
        return this;
    }

    public RecyclerViewAssert hasItemAnimator(RecyclerView.ItemAnimator itemAnimator) {
        this.isNotNull();
        RecyclerView.ItemAnimator actualItemAnimator = ((RecyclerView)this.actual).getItemAnimator();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualItemAnimator).overridingErrorMessage("Expected item animator <%s> but was <%s>.", new Object[]{itemAnimator, actualItemAnimator})).isEqualTo((Object)itemAnimator);
        return this;
    }

    public RecyclerViewAssert hasLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.isNotNull();
        RecyclerView.LayoutManager actualLayoutManager = ((RecyclerView)this.actual).getLayoutManager();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualLayoutManager).overridingErrorMessage("Expected layout manager <%s> but was <%s>.", new Object[]{layoutManager, actualLayoutManager})).isEqualTo((Object)layoutManager);
        return this;
    }

    public RecyclerViewAssert hasRecycledViewPool(RecyclerView.RecycledViewPool recycledViewPool) {
        this.isNotNull();
        RecyclerView.RecycledViewPool actualRecycledViewPool = ((RecyclerView)this.actual).getRecycledViewPool();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualRecycledViewPool).overridingErrorMessage("Expected recycled view pool <%s> but was <%s>", new Object[]{recycledViewPool, actualRecycledViewPool})).isEqualTo((Object)recycledViewPool);
        return this;
    }

    public RecyclerViewAssert hasScrollState(int scrollState) {
        this.isNotNull();
        int actualScrollState = ((RecyclerView)this.actual).getScrollState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualScrollState).overridingErrorMessage("Expected scroll state <%s> but was <%s>.", new Object[]{RecyclerViewAssert.scrollStateToString(scrollState), RecyclerViewAssert.scrollStateToString(actualScrollState)})).isEqualTo(scrollState);
        return this;
    }

    public RecyclerViewAssert hasFixedSize() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView)this.actual).hasFixedSize()).overridingErrorMessage("Expected to have fixed size but did not.", new Object[0])).isTrue();
        return this;
    }

    public RecyclerViewAssert doesNotHaveFixedSize() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView)this.actual).hasFixedSize()).overridingErrorMessage("Expected to not have fixed size but did.", new Object[0])).isFalse();
        return this;
    }

    public static String scrollStateToString(int scrollState) {
        return IntegerUtils.buildNamedValueString((int)scrollState).value(1, "dragging").value(0, "idle").value(2, "settling").get();
    }
}

