/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.recyclerview.v7.api.widget;

import android.support.v7.widget.RecyclerView;
import org.assertj.android.api.view.AbstractViewAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class RecyclerViewLayoutManagerAssert
extends AbstractAssert<RecyclerViewLayoutManagerAssert, RecyclerView.LayoutManager> {
    public RecyclerViewLayoutManagerAssert(RecyclerView.LayoutManager actual) {
        super((Object)actual, RecyclerViewLayoutManagerAssert.class);
    }

    public RecyclerViewLayoutManagerAssert supportsPredictiveItemAnimations() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).supportsPredictiveItemAnimations()).overridingErrorMessage("Expected to support predictive item animations but did not.", new Object[0])).isTrue();
        return this;
    }

    public RecyclerViewLayoutManagerAssert doesNotSupportPredictiveItemAnimations() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).supportsPredictiveItemAnimations()).overridingErrorMessage("Expected to not support predictive item animations but did.", new Object[0])).isFalse();
        return this;
    }

    public RecyclerViewLayoutManagerAssert canScrollHorizontally() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).canScrollHorizontally()).overridingErrorMessage("Expected to be able to scroll horizontally but can not.", new Object[0])).isTrue();
        return this;
    }

    public RecyclerViewLayoutManagerAssert canNotScrollHorizontally() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).canScrollHorizontally()).overridingErrorMessage("Expected to not be able to scroll horizontally but can.", new Object[0])).isFalse();
        return this;
    }

    public RecyclerViewLayoutManagerAssert canScrollVertically() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).canScrollVertically()).overridingErrorMessage("Expected to be able to scroll verticall but can not.", new Object[0])).isTrue();
        return this;
    }

    public RecyclerViewLayoutManagerAssert canNotScrollVertically() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).canScrollVertically()).overridingErrorMessage("Expected to not be able to scroll horizontally but can.", new Object[0])).isFalse();
        return this;
    }

    public RecyclerViewLayoutManagerAssert isSmoothScrolling() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).isSmoothScrolling()).overridingErrorMessage("Expected to be smooth scrolling but was not.", new Object[0])).isTrue();
        return this;
    }

    public RecyclerViewLayoutManagerAssert isNotSmoothScrolling() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).isSmoothScrolling()).overridingErrorMessage("Expected to not be smooth scrolling but was.", new Object[0])).isFalse();
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasLayoutDirection(int direction) {
        this.isNotNull();
        int actualDirection = ((RecyclerView.LayoutManager)this.actual).getLayoutDirection();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDirection).overridingErrorMessage("Expected layout direction <%s> but was <%s>.", new Object[]{AbstractViewAssert.layoutDirectionToString((int)direction), AbstractViewAssert.layoutDirectionToString((int)actualDirection)})).isEqualTo(direction);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasChildCount(int count) {
        this.isNotNull();
        int actualCount = ((RecyclerView.LayoutManager)this.actual).getChildCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected child count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((RecyclerView.LayoutManager)this.actual).getWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((RecyclerView.LayoutManager)this.actual).getHeight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasPaddingLeft(int padding) {
        this.isNotNull();
        int actualPadding = ((RecyclerView.LayoutManager)this.actual).getPaddingLeft();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding left <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasPaddingTop(int padding) {
        this.isNotNull();
        int actualPadding = ((RecyclerView.LayoutManager)this.actual).getPaddingTop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding top <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasPaddingRight(int padding) {
        this.isNotNull();
        int actualPadding = ((RecyclerView.LayoutManager)this.actual).getPaddingRight();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding right <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasPaddingBottom(int padding) {
        this.isNotNull();
        int actualPadding = ((RecyclerView.LayoutManager)this.actual).getPaddingBottom();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding bottom <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasPaddingStart(int padding) {
        this.isNotNull();
        int actualPadding = ((RecyclerView.LayoutManager)this.actual).getPaddingStart();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding start <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasPaddingEnd(int padding) {
        this.isNotNull();
        int actualPadding = ((RecyclerView.LayoutManager)this.actual).getPaddingEnd();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding end <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    public RecyclerViewLayoutManagerAssert isFocused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).isFocused()).overridingErrorMessage("Expected to be focused but was not.", new Object[0])).isTrue();
        return this;
    }

    public RecyclerViewLayoutManagerAssert isNotFocused() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).isFocused()).overridingErrorMessage("Expected to not be focused but was.", new Object[0])).isFalse();
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasFocus() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).hasFocus()).overridingErrorMessage("Expected to have focus but did not.", new Object[0])).isTrue();
        return this;
    }

    public RecyclerViewLayoutManagerAssert doesNotHaveFocus() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((RecyclerView.LayoutManager)this.actual).hasFocus()).overridingErrorMessage("Expected to not have focus but did.", new Object[0])).isFalse();
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasItemCount(int count) {
        this.isNotNull();
        int actualCount = ((RecyclerView.LayoutManager)this.actual).getItemCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected item count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasMinimumWidth(int width) {
        this.isNotNull();
        int actualWidth = ((RecyclerView.LayoutManager)this.actual).getMinimumWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected minimum width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(actualWidth);
        return this;
    }

    public RecyclerViewLayoutManagerAssert hasMinimumHeight(int height) {
        this.isNotNull();
        int actualHeight = ((RecyclerView.LayoutManager)this.actual).getMinimumWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected minimum height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(actualHeight);
        return this;
    }
}

