/*
 * Decompiled with CFR 0.152.
 */
package misk.backoff;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import misk.backoff.Backoff;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmisk/backoff/ExponentialBackoff;", "Lmisk/backoff/Backoff;", "baseDelay", "Lkotlin/Function0;", "Ljava/time/Duration;", "maxDelay", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "jitter", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;)V", "(Ljava/time/Duration;Ljava/time/Duration;)V", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "consecutiveRetryCount", "", "maxRetryCount", "nextRetry", "randomJitter", "", "reset", "", "misk-core"})
public final class ExponentialBackoff
implements Backoff {
    @NotNull
    private final Function0<Duration> baseDelay;
    @NotNull
    private final Function0<Duration> maxDelay;
    @NotNull
    private final Function0<Duration> jitter;
    private int consecutiveRetryCount;
    private int maxRetryCount;

    public ExponentialBackoff(@NotNull Function0<Duration> baseDelay, @NotNull Function0<Duration> maxDelay, @NotNull Function0<Duration> jitter) {
        Intrinsics.checkNotNullParameter(baseDelay, (String)"baseDelay");
        Intrinsics.checkNotNullParameter(maxDelay, (String)"maxDelay");
        Intrinsics.checkNotNullParameter(jitter, (String)"jitter");
        this.baseDelay = baseDelay;
        this.maxDelay = maxDelay;
        this.jitter = jitter;
        this.maxRetryCount = Integer.MAX_VALUE;
    }

    public ExponentialBackoff(@NotNull Function0<Duration> baseDelay, @NotNull Function0<Duration> maxDelay) {
        Intrinsics.checkNotNullParameter(baseDelay, (String)"baseDelay");
        Intrinsics.checkNotNullParameter(maxDelay, (String)"maxDelay");
        this(baseDelay, maxDelay, (Function0<Duration>)((Function0)1.INSTANCE));
    }

    public ExponentialBackoff(final @NotNull Duration baseDelay, final @NotNull Duration maxDelay, final @NotNull Duration jitter) {
        Intrinsics.checkNotNullParameter((Object)baseDelay, (String)"baseDelay");
        Intrinsics.checkNotNullParameter((Object)maxDelay, (String)"maxDelay");
        Intrinsics.checkNotNullParameter((Object)jitter, (String)"jitter");
        this((Function0<Duration>)((Function0)new Function0<Duration>(){

            @NotNull
            public final Duration invoke() {
                return baseDelay;
            }
        }), (Function0<Duration>)((Function0)new Function0<Duration>(){

            @NotNull
            public final Duration invoke() {
                return maxDelay;
            }
        }), (Function0<Duration>)((Function0)new Function0<Duration>(){

            @NotNull
            public final Duration invoke() {
                return jitter;
            }
        }));
    }

    public ExponentialBackoff(@NotNull Duration baseDelay, @NotNull Duration maxDelay) {
        Intrinsics.checkNotNullParameter((Object)baseDelay, (String)"baseDelay");
        Intrinsics.checkNotNullParameter((Object)maxDelay, (String)"maxDelay");
        Duration duration = Duration.ofMillis(0L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(0)");
        this(baseDelay, maxDelay, duration);
    }

    @Override
    public void reset() {
        this.consecutiveRetryCount = 0;
    }

    @Override
    @NotNull
    public Duration nextRetry() {
        this.consecutiveRetryCount = Math.min(this.consecutiveRetryCount + 1, this.maxRetryCount);
        long backOff = (long)Math.pow(2.0, this.consecutiveRetryCount - 1);
        long maxDelayMs = ((Duration)this.maxDelay.invoke()).toMillis();
        long delayMs = Math.min(maxDelayMs, ((Duration)this.baseDelay.invoke()).toMillis() * backOff);
        if (delayMs == maxDelayMs) {
            this.maxRetryCount = this.consecutiveRetryCount;
        }
        Duration duration = Duration.ofMillis(delayMs + this.randomJitter());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(delayMs + randomJitter())");
        return duration;
    }

    private final long randomJitter() {
        long maxJitterMs = ((Duration)this.jitter.invoke()).toMillis();
        return maxJitterMs == 0L ? 0L : Math.floorMod(ThreadLocalRandom.current().nextLong(), maxJitterMs);
    }
}

