/*
 * Decompiled with CFR 0.152.
 */
package misk.sampling;

import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import misk.concurrent.Sleeper;
import misk.sampling.RateLimiter;
import misk.sampling.Sampler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmisk/sampling/RateLimitingSampler;", "Lmisk/sampling/Sampler;", "ratePerSecond", "", "(J)V", "rateLimiter", "Lmisk/sampling/RateLimiter;", "(Lmisk/sampling/RateLimiter;)V", "sample", "", "misk-core"})
public final class RateLimitingSampler
implements Sampler {
    @NotNull
    private final RateLimiter rateLimiter;

    public RateLimitingSampler(@NotNull RateLimiter rateLimiter) {
        Intrinsics.checkNotNullParameter((Object)rateLimiter, (String)"rateLimiter");
        this.rateLimiter = rateLimiter;
    }

    public RateLimitingSampler(long ratePerSecond) {
        Ticker ticker = Ticker.systemTicker();
        Intrinsics.checkNotNullExpressionValue((Object)ticker, (String)"systemTicker()");
        this(new RateLimiter.Factory(ticker, Sleeper.Companion.getDEFAULT()).create(1L));
    }

    @Override
    public boolean sample() {
        return this.rateLimiter.tryAcquire(1L, 0L, TimeUnit.SECONDS);
    }

    @Override
    public void sampledCall(@NotNull Function0<Unit> f) {
        Sampler.DefaultImpls.sampledCall(this, f);
    }
}

