/*
 * Decompiled with CFR 0.152.
 */
package misk.security.ssl;

import jakarta.inject.Inject;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import misk.security.ssl.CertStoreConfig;
import misk.security.ssl.SslLoader;
import misk.security.ssl.TrustStoreConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.security.ssl.CertStore;
import wisp.security.ssl.TrustStore;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012H\u0007J \u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0014H\u0007J\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0010\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lmisk/security/ssl/SslContextFactory;", "", "sslLoader", "Lmisk/security/ssl/SslLoader;", "(Lmisk/security/ssl/SslLoader;)V", "delegate", "Lwisp/security/ssl/SslContextFactory;", "getDelegate", "()Lwisp/security/ssl/SslContextFactory;", "create", "Ljavax/net/ssl/SSLContext;", "certStore", "Lwisp/security/ssl/CertStore;", "Lmisk/security/ssl/CertStore;", "pin", "", "trustStore", "Lwisp/security/ssl/TrustStore;", "Lmisk/security/ssl/TrustStore;", "Lmisk/security/ssl/CertStoreConfig;", "Lmisk/security/ssl/TrustStoreConfig;", "loadTrustManagers", "", "Ljavax/net/ssl/TrustManager;", "Ljava/security/KeyStore;", "(Ljava/security/KeyStore;)[Ljavax/net/ssl/TrustManager;", "misk-core"})
public final class SslContextFactory {
    @NotNull
    private final SslLoader sslLoader;
    @NotNull
    private final wisp.security.ssl.SslContextFactory delegate;

    @Inject
    public SslContextFactory(@NotNull SslLoader sslLoader) {
        Intrinsics.checkNotNullParameter((Object)sslLoader, (String)"sslLoader");
        this.sslLoader = sslLoader;
        this.delegate = new wisp.security.ssl.SslContextFactory(this.sslLoader.getDelegate());
    }

    @NotNull
    public final wisp.security.ssl.SslContextFactory getDelegate() {
        return this.delegate;
    }

    @JvmOverloads
    @NotNull
    public final SSLContext create(@Nullable CertStoreConfig certStore, @Nullable TrustStoreConfig trustStore) {
        CertStoreConfig certStoreConfig = certStore;
        TrustStoreConfig trustStoreConfig = trustStore;
        return this.delegate.create((wisp.security.ssl.CertStoreConfig)(certStoreConfig != null ? certStoreConfig.toWispConfig() : null), (wisp.security.ssl.TrustStoreConfig)(trustStoreConfig != null ? trustStoreConfig.toWispConfig() : null));
    }

    public static /* synthetic */ SSLContext create$default(SslContextFactory sslContextFactory, CertStoreConfig certStoreConfig, TrustStoreConfig trustStoreConfig, int n, Object object) {
        if ((n & 1) != 0) {
            certStoreConfig = null;
        }
        if ((n & 2) != 0) {
            trustStoreConfig = null;
        }
        return sslContextFactory.create(certStoreConfig, trustStoreConfig);
    }

    @JvmOverloads
    @NotNull
    public final SSLContext create(@Nullable CertStore certStore, @Nullable char[] pin, @Nullable TrustStore trustStore) {
        return this.delegate.create(certStore, pin, trustStore);
    }

    public static /* synthetic */ SSLContext create$default(SslContextFactory sslContextFactory, CertStore certStore, char[] cArray, TrustStore trustStore, int n, Object object) {
        if ((n & 4) != 0) {
            trustStore = null;
        }
        return sslContextFactory.create(certStore, cArray, trustStore);
    }

    @NotNull
    public final TrustManager[] loadTrustManagers(@NotNull KeyStore trustStore) {
        Intrinsics.checkNotNullParameter((Object)trustStore, (String)"trustStore");
        return this.delegate.loadTrustManagers(trustStore);
    }

    @JvmOverloads
    @NotNull
    public final SSLContext create(@Nullable CertStoreConfig certStore) {
        return SslContextFactory.create$default(this, certStore, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final SSLContext create() {
        return SslContextFactory.create$default(this, null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final SSLContext create(@Nullable CertStore certStore, @Nullable char[] pin) {
        return SslContextFactory.create$default(this, certStore, pin, null, 4, null);
    }
}

