/*
 * Decompiled with CFR 0.152.
 */
package misk.web.mediatype;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002-.Ba\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003J\u0015\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c2\u0003Ji\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n2\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010\u001b\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0019H\u00d6\u0001J\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lmisk/web/mediatype/MediaRange;", "", "type", "", "subtype", "charset", "Ljava/nio/charset/Charset;", "qualityFactor", "", "parameters", "", "extensions", "rawText", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/charset/Charset;DLjava/util/Map;Ljava/util/Map;Ljava/lang/String;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getExtensions", "()Ljava/util/Map;", "getParameters", "getQualityFactor", "()D", "getSubtype", "()Ljava/lang/String;", "getType", "wildcardCount", "", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "", "hashCode", "matcher", "Lmisk/web/mediatype/MediaRange$Matcher;", "mediaType", "Lokhttp3/MediaType;", "toString", "Companion", "Matcher", "misk-core"})
public final class MediaRange
implements Comparable<MediaRange> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final String subtype;
    @Nullable
    private final Charset charset;
    private final double qualityFactor;
    @NotNull
    private final Map<String, String> parameters;
    @NotNull
    private final Map<String, String> extensions;
    @NotNull
    private final String rawText;
    private final int wildcardCount;
    @NotNull
    public static final String WILDCARD = "*";
    @NotNull
    private static final MediaRange ALL_MEDIA = new MediaRange("*", "*", null, 0.0, null, null, "*/*", 60, null);

    @JvmOverloads
    public MediaRange(@NotNull String type, @NotNull String subtype, @Nullable Charset charset, double qualityFactor, @NotNull Map<String, String> parameters, @NotNull Map<String, String> extensions, @NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        this.type = type;
        this.subtype = subtype;
        this.charset = charset;
        this.qualityFactor = qualityFactor;
        this.parameters = parameters;
        this.extensions = extensions;
        this.rawText = rawText;
        this.wildcardCount = Intrinsics.areEqual((Object)this.type, (Object)WILDCARD) ? 2 : (Intrinsics.areEqual((Object)this.subtype, (Object)WILDCARD) ? 1 : 0);
    }

    public /* synthetic */ MediaRange(String string, String string2, Charset charset, double d, Map map, Map map2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            charset = null;
        }
        if ((n & 8) != 0) {
            d = 1.0;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(string, string2, charset, d, map, map2, string3);
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getSubtype() {
        return this.subtype;
    }

    @Nullable
    public final Charset getCharset() {
        return this.charset;
    }

    public final double getQualityFactor() {
        return this.qualityFactor;
    }

    @NotNull
    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    @NotNull
    public final Map<String, String> getExtensions() {
        return this.extensions;
    }

    @Override
    public int compareTo(@NotNull MediaRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int wildcardDiff = this.wildcardCount - other.wildcardCount;
        if (wildcardDiff != 0) {
            return wildcardDiff;
        }
        int parameterDiff = other.parameters.size() - this.parameters.size();
        if (parameterDiff != 0) {
            return parameterDiff;
        }
        int extensionDiff = other.extensions.size() - this.extensions.size();
        if (extensionDiff != 0) {
            return extensionDiff;
        }
        return 0;
    }

    @NotNull
    public String toString() {
        return this.rawText;
    }

    @Nullable
    public final Matcher matcher(@NotNull MediaType mediaType) {
        boolean subtypeMatches;
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        boolean typeMatches = Intrinsics.areEqual((Object)this.type, (Object)mediaType.type()) || Intrinsics.areEqual((Object)this.type, (Object)WILDCARD) || Intrinsics.areEqual((Object)mediaType.type(), (Object)WILDCARD);
        boolean bl = subtypeMatches = Intrinsics.areEqual((Object)this.subtype, (Object)mediaType.subtype()) || Intrinsics.areEqual((Object)this.subtype, (Object)WILDCARD) || Intrinsics.areEqual((Object)mediaType.subtype(), (Object)WILDCARD);
        if (!typeMatches || !subtypeMatches) {
            return null;
        }
        if (this.charset == null || MediaType.charset$default((MediaType)mediaType, null, (int)1, null) == null) {
            return new Matcher(this, false, 2, null);
        }
        if (!Intrinsics.areEqual((Object)this.charset, (Object)MediaType.charset$default((MediaType)mediaType, null, (int)1, null))) {
            return null;
        }
        return new Matcher(this, true);
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.subtype;
    }

    @Nullable
    public final Charset component3() {
        return this.charset;
    }

    public final double component4() {
        return this.qualityFactor;
    }

    @NotNull
    public final Map<String, String> component5() {
        return this.parameters;
    }

    @NotNull
    public final Map<String, String> component6() {
        return this.extensions;
    }

    private final String component7() {
        return this.rawText;
    }

    @NotNull
    public final MediaRange copy(@NotNull String type, @NotNull String subtype, @Nullable Charset charset, double qualityFactor, @NotNull Map<String, String> parameters, @NotNull Map<String, String> extensions, @NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        return new MediaRange(type, subtype, charset, qualityFactor, parameters, extensions, rawText);
    }

    public static /* synthetic */ MediaRange copy$default(MediaRange mediaRange, String string, String string2, Charset charset, double d, Map map, Map map2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = mediaRange.type;
        }
        if ((n & 2) != 0) {
            string2 = mediaRange.subtype;
        }
        if ((n & 4) != 0) {
            charset = mediaRange.charset;
        }
        if ((n & 8) != 0) {
            d = mediaRange.qualityFactor;
        }
        if ((n & 0x10) != 0) {
            map = mediaRange.parameters;
        }
        if ((n & 0x20) != 0) {
            map2 = mediaRange.extensions;
        }
        if ((n & 0x40) != 0) {
            string3 = mediaRange.rawText;
        }
        return mediaRange.copy(string, string2, charset, d, map, map2, string3);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.subtype.hashCode();
        result = result * 31 + (this.charset == null ? 0 : this.charset.hashCode());
        result = result * 31 + Double.hashCode(this.qualityFactor);
        result = result * 31 + ((Object)this.parameters).hashCode();
        result = result * 31 + ((Object)this.extensions).hashCode();
        result = result * 31 + this.rawText.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaRange)) {
            return false;
        }
        MediaRange mediaRange = (MediaRange)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)mediaRange.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subtype, (Object)mediaRange.subtype)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.charset, (Object)mediaRange.charset)) {
            return false;
        }
        if (Double.compare(this.qualityFactor, mediaRange.qualityFactor) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual(this.parameters, mediaRange.parameters)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.extensions, mediaRange.extensions)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.rawText, (Object)mediaRange.rawText);
    }

    @JvmOverloads
    public MediaRange(@NotNull String type, @NotNull String subtype, @Nullable Charset charset, double qualityFactor, @NotNull Map<String, String> parameters, @NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        this(type, subtype, charset, qualityFactor, parameters, null, rawText, 32, null);
    }

    @JvmOverloads
    public MediaRange(@NotNull String type, @NotNull String subtype, @Nullable Charset charset, double qualityFactor, @NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        this(type, subtype, charset, qualityFactor, null, null, rawText, 48, null);
    }

    @JvmOverloads
    public MediaRange(@NotNull String type, @NotNull String subtype, @Nullable Charset charset, @NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        this(type, subtype, charset, 0.0, null, null, rawText, 56, null);
    }

    @JvmOverloads
    public MediaRange(@NotNull String type, @NotNull String subtype, @NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        this(type, subtype, null, 0.0, null, null, rawText, 60, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\n\u001a\u00020\bH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmisk/web/mediatype/MediaRange$Companion;", "", "()V", "ALL_MEDIA", "Lmisk/web/mediatype/MediaRange;", "getALL_MEDIA", "()Lmisk/web/mediatype/MediaRange;", "WILDCARD", "", "parse", "s", "parseNameValue", "Lkotlin/Pair;", "parseRanges", "", "swallowExceptions", "", "misk-core"})
    @SourceDebugExtension(value={"SMAP\nMediaRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaRange.kt\nmisk/web/mediatype/MediaRange$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1603#2,9:162\n1855#2:171\n1856#2:173\n1612#2:174\n1549#2:176\n1620#2,3:177\n1#3:172\n1#3:175\n*S KotlinDebug\n*F\n+ 1 MediaRange.kt\nmisk/web/mediatype/MediaRange$Companion\n*L\n81#1:162,9\n81#1:171\n81#1:173\n81#1:174\n108#1:176\n108#1:177,3\n81#1:172\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MediaRange getALL_MEDIA() {
            return ALL_MEDIA;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<MediaRange> parseRanges(@NotNull String s, boolean swallowExceptions) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            char[] cArray = new char[]{','};
            Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                MediaRange it$iv$iv;
                MediaRange mediaRange;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                try {
                    mediaRange = Companion.parse(it);
                }
                catch (Throwable th) {
                    if (!swallowExceptions) {
                        throw th;
                    }
                    mediaRange = null;
                }
                if (mediaRange == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List parseRanges$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.parseRanges(string, bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MediaRange parse(@NotNull String s) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            char[] cArray = new char[]{';'};
            List typeParametersAndExtensions = StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            char[] cArray2 = new char[]{'/'};
            List typeParts = StringsKt.split$default((CharSequence)((CharSequence)typeParametersAndExtensions.get(0)), (char[])cArray2, (boolean)false, (int)0, (int)6, null);
            if (!(typeParts.size() == 2)) {
                boolean $i$a$-require-MediaRange$Companion$parse$72 = false;
                String $i$a$-require-MediaRange$Companion$parse$72 = s + " is not a valid media range";
                throw new IllegalArgumentException($i$a$-require-MediaRange$Companion$parse$72.toString());
            }
            String type = ((Object)StringsKt.trim((CharSequence)((String)typeParts.get(0)))).toString();
            String subtype = ((Object)StringsKt.trim((CharSequence)((String)typeParts.get(1)))).toString();
            if (!(((CharSequence)type).length() > 0)) {
                boolean $i$a$-require-MediaRange$Companion$parse$82 = false;
                String $i$a$-require-MediaRange$Companion$parse$82 = s + " is not a valid media range";
                throw new IllegalArgumentException($i$a$-require-MediaRange$Companion$parse$82.toString());
            }
            if (!(((CharSequence)subtype).length() > 0)) {
                boolean $i$a$-require-MediaRange$Companion$parse$92 = false;
                String $i$a$-require-MediaRange$Companion$parse$92 = s + " is not a valid media range";
                throw new IllegalArgumentException($i$a$-require-MediaRange$Companion$parse$92.toString());
            }
            if (!(!Intrinsics.areEqual((Object)type, (Object)MediaRange.WILDCARD) || Intrinsics.areEqual((Object)subtype, (Object)MediaRange.WILDCARD))) {
                boolean $i$a$-require-MediaRange$Companion$parse$102 = false;
                String $i$a$-require-MediaRange$Companion$parse$102 = s + " is not a valid media range";
                throw new IllegalArgumentException($i$a$-require-MediaRange$Companion$parse$102.toString());
            }
            if (typeParametersAndExtensions.size() == 1) {
                return new MediaRange(type, subtype, null, 0.0, null, null, s, 60, null);
            }
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)typeParametersAndExtensions, (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.parseNameValue((String)it));
            }
            List parametersAndExtensions = (List)destination$iv$iv;
            LinkedHashMap parameters = new LinkedHashMap();
            LinkedHashMap extensions = new LinkedHashMap();
            Charset charset = null;
            double qualityFactor = 1.0;
            boolean inParameters = true;
            for (Pair p : parametersAndExtensions) {
                if (Intrinsics.areEqual((Object)p.getFirst(), (Object)"q")) {
                    if (!inParameters) {
                        boolean $i$a$-require-MediaRange$Companion$parse$112 = false;
                        String $i$a$-require-MediaRange$Companion$parse$112 = s + " is not a valid media range; quality factor specified multiple times";
                        throw new IllegalArgumentException($i$a$-require-MediaRange$Companion$parse$112.toString());
                    }
                    qualityFactor = Double.parseDouble((String)p.getSecond());
                    inParameters = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)p.getFirst(), (Object)"charset")) {
                    if (!inParameters) {
                        boolean bl = false;
                        String string = s + " is not a valid media range; encountered charset parameter in extensions";
                        throw new IllegalArgumentException(string.toString());
                    }
                    String string = ((String)p.getSecond()).toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase()");
                    charset = Charset.forName(string);
                    continue;
                }
                if (inParameters) {
                    ((Map)parameters).put(p.getFirst(), p.getSecond());
                    continue;
                }
                ((Map)extensions).put(p.getFirst(), p.getSecond());
            }
            return new MediaRange(type, subtype, charset, qualityFactor, MapsKt.toMap((Map)parameters), MapsKt.toMap((Map)extensions), s);
        }

        private final Pair<String, String> parseNameValue(String s) {
            char[] cArray = new char[]{'='};
            List parts = StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (!(parts.size() == 2)) {
                boolean $i$a$-require-MediaRange$Companion$parseNameValue$42 = false;
                String $i$a$-require-MediaRange$Companion$parseNameValue$42 = s + " is not a valid name/value pair";
                throw new IllegalArgumentException($i$a$-require-MediaRange$Companion$parseNameValue$42.toString());
            }
            String name = ((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString();
            String value = ((Object)StringsKt.trim((CharSequence)((String)parts.get(1)))).toString();
            if (!(((CharSequence)name).length() > 0)) {
                boolean $i$a$-require-MediaRange$Companion$parseNameValue$52 = false;
                String $i$a$-require-MediaRange$Companion$parseNameValue$52 = s + " is not a valid name/value pair";
                throw new IllegalArgumentException($i$a$-require-MediaRange$Companion$parseNameValue$52.toString());
            }
            if (!(((CharSequence)value).length() > 0)) {
                boolean bl = false;
                String string = s + " is not a valid name/value pair";
                throw new IllegalArgumentException(string.toString());
            }
            return TuplesKt.to((Object)name, (Object)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lmisk/web/mediatype/MediaRange$Matcher;", "", "mediaRange", "Lmisk/web/mediatype/MediaRange;", "matchesCharset", "", "(Lmisk/web/mediatype/MediaRange;Z)V", "getMatchesCharset", "()Z", "getMediaRange", "()Lmisk/web/mediatype/MediaRange;", "compareTo", "", "other", "toString", "", "misk-core"})
    public static final class Matcher
    implements Comparable<Matcher> {
        @NotNull
        private final MediaRange mediaRange;
        private final boolean matchesCharset;

        @JvmOverloads
        public Matcher(@NotNull MediaRange mediaRange, boolean matchesCharset) {
            Intrinsics.checkNotNullParameter((Object)mediaRange, (String)"mediaRange");
            this.mediaRange = mediaRange;
            this.matchesCharset = matchesCharset;
        }

        public /* synthetic */ Matcher(MediaRange mediaRange, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(mediaRange, bl);
        }

        @NotNull
        public final MediaRange getMediaRange() {
            return this.mediaRange;
        }

        public final boolean getMatchesCharset() {
            return this.matchesCharset;
        }

        @Override
        public int compareTo(@NotNull Matcher other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int mediaRangeComparison = this.mediaRange.compareTo(other.mediaRange);
            if (mediaRangeComparison != 0) {
                return mediaRangeComparison;
            }
            if (this.matchesCharset && !other.matchesCharset) {
                return -1;
            }
            if (!this.matchesCharset && other.matchesCharset) {
                return 1;
            }
            return 0;
        }

        @NotNull
        public String toString() {
            return this.mediaRange + "; charset-match " + this.matchesCharset;
        }

        @JvmOverloads
        public Matcher(@NotNull MediaRange mediaRange) {
            Intrinsics.checkNotNullParameter((Object)mediaRange, (String)"mediaRange");
            this(mediaRange, false, 2, null);
        }
    }
}

