/*
 * Decompiled with CFR 0.152.
 */
package misk.web.mediatype;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import misk.web.mediatype.MediaTypesKt;
import okhttp3.MediaType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\bR\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\bR\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\bR\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\bR\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\b\u00a8\u0006-"}, d2={"Lmisk/web/mediatype/MediaTypes;", "", "()V", "ALL", "", "ALL_MEDIA_TYPE", "Lokhttp3/MediaType;", "getALL_MEDIA_TYPE", "()Lokhttp3/MediaType;", "APPLICATION_FORM_URLENCODED", "APPLICATION_GRPC", "APPLICATION_GRPC_MEDIA_TYPE", "getAPPLICATION_GRPC_MEDIA_TYPE", "APPLICATION_JAVASCRIPT", "APPLICATION_JAVASCRIPT_MEDIA_TYPE", "getAPPLICATION_JAVASCRIPT_MEDIA_TYPE", "APPLICATION_JSON", "APPLICATION_JSON_MEDIA_TYPE", "getAPPLICATION_JSON_MEDIA_TYPE", "APPLICATION_OCTETSTREAM", "APPLICATION_OCTETSTREAM_MEDIA_TYPE", "getAPPLICATION_OCTETSTREAM_MEDIA_TYPE", "APPLICATION_PROTOBUF", "APPLICATION_PROTOBUF_MEDIA_TYPE", "getAPPLICATION_PROTOBUF_MEDIA_TYPE", "IMAGE_PNG", "IMAGE_PNG_MEDIA_TYPE", "getIMAGE_PNG_MEDIA_TYPE", "IMAGE_SVG", "IMAGE_SVG_MEDIA_TYPE", "getIMAGE_SVG_MEDIA_TYPE", "TEXT_CSS", "TEXT_CSS_MEDIA_TYPE", "getTEXT_CSS_MEDIA_TYPE", "TEXT_HTML", "TEXT_HTML_MEDIA_TYPE", "getTEXT_HTML_MEDIA_TYPE", "TEXT_PLAIN_UTF8", "TEXT_PLAIN_UTF8_MEDIA_TYPE", "getTEXT_PLAIN_UTF8_MEDIA_TYPE", "TURBO_STREAM", "TURBO_STREAM_MEDIA_TYPE", "getTURBO_STREAM_MEDIA_TYPE", "fromFileExtension", "ext", "misk-core"})
public final class MediaTypes {
    @NotNull
    public static final MediaTypes INSTANCE = new MediaTypes();
    @NotNull
    public static final String APPLICATION_JSON = "application/json;charset=utf-8";
    @NotNull
    private static final MediaType APPLICATION_JSON_MEDIA_TYPE = MediaTypesKt.asMediaType("application/json;charset=utf-8");
    @NotNull
    public static final String TEXT_PLAIN_UTF8 = "text/plain;charset=utf-8";
    @NotNull
    private static final MediaType TEXT_PLAIN_UTF8_MEDIA_TYPE = MediaTypesKt.asMediaType("text/plain;charset=utf-8");
    @NotNull
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded;charset=utf-8";
    @NotNull
    public static final String ALL = "*/*";
    @NotNull
    private static final MediaType ALL_MEDIA_TYPE = MediaTypesKt.asMediaType("*/*");
    @NotNull
    public static final String APPLICATION_JAVASCRIPT = "application/javascript";
    @NotNull
    private static final MediaType APPLICATION_JAVASCRIPT_MEDIA_TYPE = MediaTypesKt.asMediaType("application/javascript");
    @NotNull
    public static final String APPLICATION_OCTETSTREAM = "application/octetstream";
    @NotNull
    private static final MediaType APPLICATION_OCTETSTREAM_MEDIA_TYPE = MediaTypesKt.asMediaType("application/octetstream");
    @NotNull
    public static final String APPLICATION_PROTOBUF = "application/x-protobuf";
    @NotNull
    private static final MediaType APPLICATION_PROTOBUF_MEDIA_TYPE = MediaTypesKt.asMediaType("application/x-protobuf");
    @NotNull
    public static final String TEXT_CSS = "text/css";
    @NotNull
    private static final MediaType TEXT_CSS_MEDIA_TYPE = MediaTypesKt.asMediaType("text/css");
    @NotNull
    public static final String TEXT_HTML = "text/html";
    @NotNull
    private static final MediaType TEXT_HTML_MEDIA_TYPE = MediaTypesKt.asMediaType("text/html");
    @NotNull
    public static final String IMAGE_PNG = "image/png";
    @NotNull
    private static final MediaType IMAGE_PNG_MEDIA_TYPE = MediaTypesKt.asMediaType("image/png");
    @NotNull
    public static final String IMAGE_SVG = "image/svg+xml";
    @NotNull
    private static final MediaType IMAGE_SVG_MEDIA_TYPE = MediaTypesKt.asMediaType("image/svg+xml");
    @NotNull
    public static final String APPLICATION_GRPC = "application/grpc";
    @NotNull
    private static final MediaType APPLICATION_GRPC_MEDIA_TYPE = MediaTypesKt.asMediaType("application/grpc");
    @NotNull
    public static final String TURBO_STREAM = "text/vnd.turbo-stream.html";
    @NotNull
    private static final MediaType TURBO_STREAM_MEDIA_TYPE = MediaTypesKt.asMediaType("text/vnd.turbo-stream.html");

    private MediaTypes() {
    }

    @NotNull
    public final MediaType getAPPLICATION_JSON_MEDIA_TYPE() {
        return APPLICATION_JSON_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getTEXT_PLAIN_UTF8_MEDIA_TYPE() {
        return TEXT_PLAIN_UTF8_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getALL_MEDIA_TYPE() {
        return ALL_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getAPPLICATION_JAVASCRIPT_MEDIA_TYPE() {
        return APPLICATION_JAVASCRIPT_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getAPPLICATION_OCTETSTREAM_MEDIA_TYPE() {
        return APPLICATION_OCTETSTREAM_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getAPPLICATION_PROTOBUF_MEDIA_TYPE() {
        return APPLICATION_PROTOBUF_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getTEXT_CSS_MEDIA_TYPE() {
        return TEXT_CSS_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getTEXT_HTML_MEDIA_TYPE() {
        return TEXT_HTML_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getIMAGE_PNG_MEDIA_TYPE() {
        return IMAGE_PNG_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getIMAGE_SVG_MEDIA_TYPE() {
        return IMAGE_SVG_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getAPPLICATION_GRPC_MEDIA_TYPE() {
        return APPLICATION_GRPC_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType getTURBO_STREAM_MEDIA_TYPE() {
        return TURBO_STREAM_MEDIA_TYPE;
    }

    @NotNull
    public final MediaType fromFileExtension(@NotNull String ext) {
        MediaType mediaType;
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        switch (ext) {
            case "css": {
                mediaType = TEXT_CSS_MEDIA_TYPE;
                break;
            }
            case "htm": 
            case "html": {
                mediaType = TEXT_HTML_MEDIA_TYPE;
                break;
            }
            case "js": {
                mediaType = APPLICATION_JAVASCRIPT_MEDIA_TYPE;
                break;
            }
            case "png": {
                mediaType = IMAGE_PNG_MEDIA_TYPE;
                break;
            }
            case "svg": {
                mediaType = IMAGE_SVG_MEDIA_TYPE;
                break;
            }
            default: {
                mediaType = APPLICATION_OCTETSTREAM_MEDIA_TYPE;
            }
        }
        return mediaType;
    }
}

