/*
 * Decompiled with CFR 0.152.
 */
package misk.grpc.protocclient;

import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.Closeable;
import java.net.SocketAddress;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import misk.resources.ResourceLoader;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lmisk/grpc/protocclient/GrpcChannelFactory;", "", "resourceLoader", "Lmisk/resources/ResourceLoader;", "(Lmisk/resources/ResourceLoader;)V", "getResourceLoader", "()Lmisk/resources/ResourceLoader;", "createClientChannel", "Lio/grpc/ManagedChannel;", "serverAddress", "Ljava/net/SocketAddress;", "serverCertResource", "", "createClientSslContext", "Lio/netty/handler/ssl/SslContext;", "misk-grpc-tests"})
public final class GrpcChannelFactory {
    @NotNull
    private final ResourceLoader resourceLoader;

    @Inject
    public GrpcChannelFactory(@NotNull ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.resourceLoader = resourceLoader;
    }

    @NotNull
    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public final ManagedChannel createClientChannel(@NotNull SocketAddress serverAddress, @NotNull String serverCertResource) {
        Intrinsics.checkNotNullParameter((Object)serverAddress, (String)"serverAddress");
        Intrinsics.checkNotNullParameter((Object)serverCertResource, (String)"serverCertResource");
        ManagedChannel managedChannel = NettyChannelBuilder.forAddress((SocketAddress)serverAddress).sslContext(this.createClientSslContext(serverCertResource)).useTransportSecurity().build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"forAddress(serverAddress\u2026Security()\n      .build()");
        return managedChannel;
    }

    public static /* synthetic */ ManagedChannel createClientChannel$default(GrpcChannelFactory grpcChannelFactory, SocketAddress socketAddress, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "classpath:/ssl/server_cert.pem";
        }
        return grpcChannelFactory.createClientChannel(socketAddress, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SslContext createClientSslContext(String serverCertResource) {
        SslContextBuilder builder = SslContextBuilder.forClient();
        BufferedSource bufferedSource = this.resourceLoader.open(serverCertResource);
        Intrinsics.checkNotNull((Object)bufferedSource);
        Closeable closeable = (Closeable)bufferedSource;
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl = false;
            SslContextBuilder sslContextBuilder = builder.trustManager(it.inputStream());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        GrpcSslContexts.configure((SslContextBuilder)builder);
        return builder.build();
    }
}

