/*
 * Decompiled with CFR 0.152.
 */
package misk.grpc.miskserver;

import com.squareup.wire.AnyMessage;
import com.squareup.wire.GrpcStatus;
import com.squareup.wire.Message;
import jakarta.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import misk.exceptions.WebActionException;
import misk.web.actions.WebAction;
import misk.web.interceptors.LogRequestResponse;
import org.jetbrains.annotations.NotNull;
import routeguide.Feature;
import routeguide.Point;
import routeguide.Rectangle;
import routeguide.RouteGuideGetFeatureBlockingServer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\b"}, d2={"Lmisk/grpc/miskserver/GetFeatureGrpcAction;", "Lmisk/web/actions/WebAction;", "Lrouteguide/RouteGuideGetFeatureBlockingServer;", "()V", "GetFeature", "Lrouteguide/Feature;", "request", "Lrouteguide/Point;", "misk-grpc-tests"})
public final class GetFeatureGrpcAction
implements WebAction,
RouteGuideGetFeatureBlockingServer {
    @Inject
    public GetFeatureGrpcAction() {
    }

    @Override
    @LogRequestResponse(bodySampling=1.0, errorBodySampling=1.0)
    @NotNull
    public Feature GetFeature(@NotNull Point request) {
        int longitude;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Integer n = request.latitude;
        int n2 = -1;
        if (n != null && n == n2) {
            Integer n3 = request.longitude;
            throw new WebActionException(n3 != null ? n3 : 500, "unexpected latitude error!", null, 4, null);
        }
        Integer n4 = request.latitude;
        int latitude = n4 != null ? n4 : 0;
        Integer n5 = request.longitude;
        int n6 = longitude = n5 != null ? n5 : 0;
        if (latitude < -90 || latitude > 90 || longitude < -180 || longitude > 180) {
            Object[] objectArray = new AnyMessage[]{AnyMessage.Companion.pack((Message)new Rectangle(new Point(-90, -180, null, 4, null), new Point(90, 180, null, 4, null), null, 4, null)), AnyMessage.Companion.pack((Message)new Point(latitude, longitude, null, 4, null))};
            throw new WebActionException(400, "invalid coordinates", "invalid coordinates", null, GrpcStatus.INVALID_ARGUMENT, CollectionsKt.listOf((Object[])objectArray), 8, null);
        }
        return new Feature("maple tree", request, null, 4, null);
    }
}

