/*
 * Decompiled with CFR 0.152.
 */
package misk.grpc.protocserver;

import com.google.common.util.concurrent.AbstractIdleService;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import misk.resources.ResourceLoader;
import okhttp3.HttpUrl;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0013H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lmisk/grpc/protocserver/ProtocGrpcService;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "services", "", "Lio/grpc/BindableService;", "resourceLoader", "Lmisk/resources/ResourceLoader;", "(Ljava/util/List;Lmisk/resources/ResourceLoader;)V", "server", "Lio/grpc/Server;", "getServer", "()Lio/grpc/Server;", "setServer", "(Lio/grpc/Server;)V", "url", "Lokhttp3/HttpUrl;", "getUrl", "()Lokhttp3/HttpUrl;", "shutDown", "", "startUp", "misk-grpc-tests"})
public final class ProtocGrpcService
extends AbstractIdleService {
    @NotNull
    private final List<BindableService> services;
    @NotNull
    private final ResourceLoader resourceLoader;
    public Server server;

    @Inject
    public ProtocGrpcService(@NotNull List<? extends BindableService> services, @NotNull ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.services = services;
        this.resourceLoader = resourceLoader;
    }

    @NotNull
    public final Server getServer() {
        Server server = this.server;
        if (server != null) {
            return server;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"server");
        return null;
    }

    public final void setServer(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"<set-?>");
        this.server = server;
    }

    @NotNull
    public final HttpUrl getUrl() {
        return new HttpUrl.Builder().scheme("https").host("127.0.0.1").port(this.getServer().getPort()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUp() {
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)0);
        BufferedSource bufferedSource = this.resourceLoader.open("classpath:/ssl/server_cert.pem");
        Intrinsics.checkNotNull((Object)bufferedSource);
        Closeable closeable = (Closeable)bufferedSource;
        Throwable throwable = null;
        try {
            ServerBuilder serverBuilder2;
            BufferedSource certificate = (BufferedSource)closeable;
            boolean bl = false;
            BufferedSource bufferedSource2 = this.resourceLoader.open("classpath:/ssl/server_key.pem");
            Intrinsics.checkNotNull((Object)bufferedSource2);
            Closeable closeable2 = (Closeable)bufferedSource2;
            Throwable throwable2 = null;
            try {
                BufferedSource privateKey = (BufferedSource)closeable2;
                boolean bl2 = false;
                serverBuilder2 = serverBuilder.useTransportSecurity(certificate.inputStream(), privateKey.inputStream());
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            ServerBuilder serverBuilder3 = serverBuilder2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        for (BindableService service : this.services) {
            serverBuilder.addService(service);
        }
        Server server = serverBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"build(...)");
        this.setServer(server);
        this.getServer().start();
    }

    protected void shutDown() {
        this.getServer().shutdown();
        this.getServer().awaitTermination();
    }
}

