/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.hibernate.DbChild;
import misk.hibernate.Gid;
import misk.hibernate.Id;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.AbstractPostInsertGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmisk/hibernate/GidGenerator;", "Lorg/hibernate/id/AbstractPostInsertGenerator;", "Lorg/hibernate/id/Configurable;", "()V", "rootColumn", "", "configure", "", "type", "Lorg/hibernate/type/Type;", "params", "Ljava/util/Properties;", "serviceRegistry", "Lorg/hibernate/service/ServiceRegistry;", "getInsertGeneratedIdentifierDelegate", "Lorg/hibernate/id/insert/InsertGeneratedIdentifierDelegate;", "persister", "Lorg/hibernate/id/PostInsertIdentityPersister;", "dialect", "Lorg/hibernate/dialect/Dialect;", "isGetGeneratedKeysEnabled", "", "GetGeneratedKeysDelegate", "IdentifierGeneratingWithParentInsert", "misk-hibernate"})
public final class GidGenerator
extends AbstractPostInsertGenerator
implements Configurable {
    private String rootColumn;

    public void configure(@NotNull Type type, @NotNull Properties params, @NotNull ServiceRegistry serviceRegistry) throws MappingException {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)serviceRegistry, (String)"serviceRegistry");
        String string = params.getProperty("rootColumn");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.getProperty(\"rootColumn\")");
        this.rootColumn = string;
        String string2 = this.rootColumn;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootColumn");
            string2 = null;
        }
    }

    @NotNull
    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(@NotNull PostInsertIdentityPersister persister, @NotNull Dialect dialect, boolean isGetGeneratedKeysEnabled) throws HibernateException {
        Intrinsics.checkNotNullParameter((Object)persister, (String)"persister");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        String string = this.rootColumn;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootColumn");
            string = null;
        }
        return new GetGeneratedKeysDelegate(persister, dialect, string);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J4\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001cH\u0002J \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lmisk/hibernate/GidGenerator$GetGeneratedKeysDelegate;", "Lorg/hibernate/id/insert/InsertGeneratedIdentifierDelegate;", "persister", "Lorg/hibernate/id/PostInsertIdentityPersister;", "dialect", "Lorg/hibernate/dialect/Dialect;", "rootColumn", "", "(Lorg/hibernate/id/PostInsertIdentityPersister;Lorg/hibernate/dialect/Dialect;Ljava/lang/String;)V", "getDialect", "()Lorg/hibernate/dialect/Dialect;", "Lorg/hibernate/persister/entity/SingleTableEntityPersister;", "getRootColumn", "()Ljava/lang/String;", "executeAndExtract", "Ljava/io/Serializable;", "parentId", "Lmisk/hibernate/Id;", "", "insert", "Ljava/sql/PreparedStatement;", "session", "Lorg/hibernate/engine/spi/SharedSessionContractImplementor;", "performIdentityGeneratingInsert", "insertSQL", "binder", "Lorg/hibernate/id/insert/Binder;", "entity", "Lmisk/hibernate/DbChild;", "performInsert", "prepare", "prepareIdentifierGeneratingInsert", "Lorg/hibernate/id/insert/IdentifierGeneratingInsert;", "releaseStatement", "", "misk-hibernate"})
    @SourceDebugExtension(value={"SMAP\nGidGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GidGenerator.kt\nmisk/hibernate/GidGenerator$GetGeneratedKeysDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
    private static final class GetGeneratedKeysDelegate
    implements InsertGeneratedIdentifierDelegate {
        @NotNull
        private final Dialect dialect;
        @NotNull
        private final String rootColumn;
        @NotNull
        private final SingleTableEntityPersister persister;

        public GetGeneratedKeysDelegate(@NotNull PostInsertIdentityPersister persister, @NotNull Dialect dialect, @NotNull String rootColumn) {
            Intrinsics.checkNotNullParameter((Object)persister, (String)"persister");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)rootColumn, (String)"rootColumn");
            this.dialect = dialect;
            this.rootColumn = rootColumn;
            if (!(persister instanceof SingleTableEntityPersister)) {
                boolean bl = false;
                String string = "Single table entities supported only";
                throw new IllegalArgumentException(string.toString());
            }
            this.persister = (SingleTableEntityPersister)persister;
        }

        @NotNull
        public final Dialect getDialect() {
            return this.dialect;
        }

        @NotNull
        public final String getRootColumn() {
            return this.rootColumn;
        }

        @NotNull
        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            IdentifierGeneratingWithParentInsert insert2 = new IdentifierGeneratingWithParentInsert(this.dialect, this.rootColumn);
            insert2.addIdentityColumn(this.persister.getRootTableKeyColumnNames()[0]);
            return insert2;
        }

        @NotNull
        public Serializable performInsert(@NotNull String insertSQL, @NotNull SharedSessionContractImplementor session, @NotNull Binder binder) {
            Intrinsics.checkNotNullParameter((Object)insertSQL, (String)"insertSQL");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
            Object object = binder.getEntity();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type misk.hibernate.DbChild<kotlin.Nothing, kotlin.Nothing>");
            DbChild entity = (DbChild)object;
            return this.performIdentityGeneratingInsert(insertSQL, session, binder, entity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Serializable performIdentityGeneratingInsert(String insertSQL, SharedSessionContractImplementor session, Binder binder, DbChild entity) {
            Id parentId = entity.getRootId();
            try {
                PreparedStatement insert2 = this.prepare(insertSQL, session);
                try {
                    binder.bindValues(insert2);
                    insert2.setLong(insert2.getParameterMetaData().getParameterCount(), parentId.getId());
                    Serializable serializable = this.executeAndExtract(parentId, insert2, session);
                    return serializable;
                }
                finally {
                    this.releaseStatement(insert2, session);
                }
            }
            catch (SQLException sqle) {
                JDBCException jDBCException = ((JdbcServices)session.getFactory().getServiceRegistry().getService(JdbcServices.class)).getSqlExceptionHelper().convert(sqle, "could not insert: " + MessageHelper.infoString((EntityPersister)((EntityPersister)this.persister)), insertSQL);
                Intrinsics.checkNotNullExpressionValue((Object)jDBCException, (String)"session.factory.serviceR\u2026      insertSQL\n        )");
                throw (Throwable)jDBCException;
            }
        }

        private final void releaseStatement(PreparedStatement insert2, SharedSessionContractImplementor session) throws SQLException {
            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release((Statement)insert2);
            session.getJdbcCoordinator().afterStatementExecution();
        }

        private final PreparedStatement prepare(String insertSQL, SharedSessionContractImplementor session) throws SQLException {
            PreparedStatement preparedStatement = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(insertSQL, 1);
            Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"session.jdbcCoordinator.\u2026nt.RETURN_GENERATED_KEYS)");
            return preparedStatement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Serializable executeAndExtract(Id parentId, PreparedStatement insert2, SharedSessionContractImplementor session) throws SQLException {
            Serializable serializable;
            session.getJdbcCoordinator().getResultSetReturn().executeUpdate(insert2);
            ResultSet rs = null;
            try {
                ResultSet resultSet = rs = insert2.getGeneratedKeys();
                Intrinsics.checkNotNull((Object)resultSet);
                resultSet.next();
                Id id = new Id(rs.getLong(1));
                serializable = new Gid(parentId, id);
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(rs, (Statement)insert2);
                    session.getJdbcCoordinator().afterStatementExecution();
                }
                throw throwable;
            }
            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(rs, (Statement)insert2);
            session.getJdbcCoordinator().afterStatementExecution();
            return serializable;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmisk/hibernate/GidGenerator$IdentifierGeneratingWithParentInsert;", "Lorg/hibernate/id/insert/IdentifierGeneratingInsert;", "dialect", "Lorg/hibernate/dialect/Dialect;", "rootColumn", "", "(Lorg/hibernate/dialect/Dialect;Ljava/lang/String;)V", "rootColumnAdded", "", "toStatementString", "misk-hibernate"})
    private static final class IdentifierGeneratingWithParentInsert
    extends IdentifierGeneratingInsert {
        @NotNull
        private final String rootColumn;
        private boolean rootColumnAdded;

        public IdentifierGeneratingWithParentInsert(@NotNull Dialect dialect, @NotNull String rootColumn) {
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)rootColumn, (String)"rootColumn");
            super(dialect);
            this.rootColumn = rootColumn;
        }

        @NotNull
        public String toStatementString() {
            if (!this.rootColumnAdded) {
                this.addColumn(this.rootColumn);
                this.rootColumnAdded = true;
            }
            String string = super.toStatementString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.toStatementString()");
            return string;
        }
    }
}

