/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u001a\u001c\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000b*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001c\u0010\u0014\u001a\u00020\u0013*\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001c\u0010\u0014\u001a\u00020\u0013*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u001c\u0010\u0014\u001a\u00020\u0013*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0000\"(\u0010\u0000\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\t\u00a8\u0006\u0019"}, d2={"allProperties", "Lcom/google/common/collect/Multimap;", "Ljava/lang/Class;", "Lorg/hibernate/mapping/Property;", "Lorg/hibernate/boot/Metadata;", "getAllProperties", "(Lorg/hibernate/boot/Metadata;)Lcom/google/common/collect/Multimap;", "", "Lorg/hibernate/mapping/PersistentClass;", "(Lorg/hibernate/mapping/PersistentClass;)Ljava/util/List;", "field", "Ljava/lang/reflect/Field;", "entityClass", "property", "getField", "Ljava/util/Properties;", "name", "", "setField", "", "setTypeParameter", "Lorg/hibernate/mapping/SimpleValue;", "key", "value", "", "misk-hibernate"})
public final class HibernateKt {
    private static final List<Property> getAllProperties(PersistentClass $this$allProperties) {
        List result = new ArrayList();
        Property property = $this$allProperties.getIdentifierProperty();
        if (property != null) {
            Property it = property;
            boolean bl = false;
            result.add(it);
        }
        Iterator iterator = $this$allProperties.getPropertyIterator();
        Intrinsics.checkNotNull((Object)iterator, (String)"null cannot be cast to non-null type kotlin.collections.MutableIterator<org.hibernate.mapping.Property>");
        Iterator i = TypeIntrinsics.asMutableIterator((Object)iterator);
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    @NotNull
    public static final Multimap<Class<?>, Property> getAllProperties(@NotNull org.hibernate.boot.Metadata $this$allProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$allProperties, (String)"<this>");
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        for (PersistentClass entityBinding : $this$allProperties.getEntityBindings()) {
            Intrinsics.checkNotNullExpressionValue((Object)entityBinding, (String)"entityBinding");
            for (Property property : HibernateKt.getAllProperties(entityBinding)) {
                Value value = property.getValue();
                if (value instanceof Component) {
                    Iterator iterator;
                    Intrinsics.checkNotNullExpressionValue((Object)((Component)value).getPropertyIterator(), (String)"value.propertyIterator");
                    while (iterator.hasNext()) {
                        Object subProperty = iterator.next();
                        if (!(subProperty instanceof Property)) continue;
                        result.put(Class.forName(((Component)value).getComponentClass().getName()), subProperty);
                    }
                    continue;
                }
                result.put(Class.forName(entityBinding.getClassName()), (Object)property);
            }
        }
        ImmutableMultimap immutableMultimap = result.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMultimap, (String)"result.build()");
        return (Multimap)immutableMultimap;
    }

    @NotNull
    public static final Field field(@NotNull Class<?> entityClass, @NotNull Property property) {
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        try {
            Field field = entityClass.getDeclaredField(property.getName());
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"entityClass.getDeclaredField(property.name)");
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = entityClass.getSuperclass();
            if (superclass != null) {
                return HibernateKt.field(superclass, property);
            }
            throw new IllegalStateException("expected a field for " + property.getName() + " in " + entityClass.getName(), e);
        }
    }

    public static final void setField(@NotNull Properties $this$setField, @NotNull String name, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)$this$setField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        $this$setField.setProperty(name + "DeclaringClass", field.getDeclaringClass().getName());
        $this$setField.setProperty(name + "Name", field.getName());
    }

    @Nullable
    public static final Field getField(@NotNull Properties $this$getField, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$getField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = $this$getField.getProperty(name + "DeclaringClass");
        if (string == null) {
            return null;
        }
        String declaringClassName = string;
        String string2 = $this$getField.getProperty(name + "Name");
        if (string2 == null) {
            return null;
        }
        String fieldName = string2;
        Class<?> entityClass = Class.forName(declaringClassName);
        return entityClass.getDeclaredField(fieldName);
    }

    public static final void setTypeParameter(@NotNull SimpleValue $this$setTypeParameter, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$setTypeParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if ($this$setTypeParameter.getTypeParameters() == null) {
            $this$setTypeParameter.setTypeParameters(new Properties());
        }
        $this$setTypeParameter.getTypeParameters().setProperty(key, value);
    }

    public static final void setTypeParameter(@NotNull SimpleValue $this$setTypeParameter, @NotNull String name, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)$this$setTypeParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if ($this$setTypeParameter.getTypeParameters() == null) {
            $this$setTypeParameter.setTypeParameters(new Properties());
        }
        Properties properties = $this$setTypeParameter.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"typeParameters");
        HibernateKt.setField(properties, name, field);
    }

    public static final void setTypeParameter(@NotNull SimpleValue $this$setTypeParameter, @NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)$this$setTypeParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if ($this$setTypeParameter.getTypeParameters() == null) {
            $this$setTypeParameter.setTypeParameters(new Properties());
        }
        Properties properties = $this$setTypeParameter.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"typeParameters");
        ((Map)properties).put(key, value);
    }
}

