/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import javax.persistence.metamodel.Metamodel;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import misk.hibernate.DbEntity;
import org.hibernate.SessionFactory;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\"\u000e\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\t2\u0014\u0010\n\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\b0\t0\u000bJ,\u0010\f\u001a\u00020\u0007\"\u000e\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\t2\u0014\u0010\n\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\b0\t0\u000bJ.\u0010\r\u001a\u00020\u000e\"\u000e\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\t2\u0014\u0010\n\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\b0\t0\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lmisk/hibernate/PersistenceMetadata;", "", "sessionFactory", "Lorg/hibernate/SessionFactory;", "(Lorg/hibernate/SessionFactory;)V", "getColumnNames", "Lcom/google/common/collect/ImmutableSet;", "", "T", "Lmisk/hibernate/DbEntity;", "entityType", "Lkotlin/reflect/KClass;", "getTableName", "hibernateMetadataForClass", "Lorg/hibernate/persister/entity/AbstractEntityPersister;", "misk-hibernate"})
public final class PersistenceMetadata {
    @NotNull
    private final SessionFactory sessionFactory;

    public PersistenceMetadata(@NotNull SessionFactory sessionFactory) {
        Intrinsics.checkNotNullParameter((Object)sessionFactory, (String)"sessionFactory");
        this.sessionFactory = sessionFactory;
    }

    @NotNull
    public final <T extends DbEntity<T>> String getTableName(@NotNull KClass<? extends DbEntity<T>> entityType) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        String string = this.hibernateMetadataForClass(entityType).getTableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hibernateMetadataForClass(entityType).tableName");
        return string;
    }

    @NotNull
    public final <T extends DbEntity<T>> ImmutableSet<String> getColumnNames(@NotNull KClass<? extends DbEntity<T>> entityType) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        ImmutableSet.Builder result = ImmutableSet.builder();
        AbstractEntityPersister classMetadata = this.hibernateMetadataForClass(entityType);
        String[] stringArray = classMetadata.getIdentifierColumnNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"classMetadata.identifierColumnNames");
        for (String column : stringArray) {
            result.add((Object)column);
        }
        String[] propertyNames = classMetadata.getPropertyNames();
        int n = propertyNames.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = classMetadata.getPropertyColumnNames(i);
            result.add((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
        }
        ImmutableSet immutableSet = result.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"result.build()");
        return immutableSet;
    }

    private final <T extends DbEntity<T>> AbstractEntityPersister hibernateMetadataForClass(KClass<? extends DbEntity<T>> entityType) {
        Metamodel metamodel = this.sessionFactory.getMetamodel();
        Intrinsics.checkNotNull((Object)metamodel, (String)"null cannot be cast to non-null type org.hibernate.metamodel.spi.MetamodelImplementor");
        MetamodelImplementor metaModel = (MetamodelImplementor)metamodel;
        EntityPersister entityPersister = metaModel.entityPersister(JvmClassMappingKt.getJavaClass(entityType));
        if (!(entityPersister != null)) {
            boolean $i$a$-check-PersistenceMetadata$hibernateMetadataForClass$32 = false;
            String $i$a$-check-PersistenceMetadata$hibernateMetadataForClass$32 = entityType.getQualifiedName() + " does not map to a known entity type";
            throw new IllegalStateException($i$a$-check-PersistenceMetadata$hibernateMetadataForClass$32.toString());
        }
        if (!(entityPersister instanceof AbstractEntityPersister)) {
            boolean bl = false;
            String string = entityType.getQualifiedName() + " does not map to a persistent class";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)entityPersister, (String)"entityPersister");
        return (AbstractEntityPersister)entityPersister;
    }
}

