/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import misk.healthchecks.HealthCheck;
import misk.healthchecks.HealthStatus;
import misk.hibernate.SchemaValidator;
import misk.hibernate.SessionFactoryService;
import misk.hibernate.Transacter;
import misk.hibernate.ValidationReport;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B3\b\u0000\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lmisk/hibernate/SchemaValidatorService;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lmisk/healthchecks/HealthCheck;", "qualifier", "Lkotlin/reflect/KClass;", "", "sessionFactoryServiceProvider", "Lcom/google/inject/Provider;", "Lmisk/hibernate/SessionFactoryService;", "transacterProvider", "Lmisk/hibernate/Transacter;", "(Lkotlin/reflect/KClass;Lcom/google/inject/Provider;Lcom/google/inject/Provider;)V", "report", "Lmisk/hibernate/ValidationReport;", "shutDown", "", "startUp", "status", "Lmisk/healthchecks/HealthStatus;", "Companion", "misk-hibernate"})
public final class SchemaValidatorService
extends AbstractIdleService
implements HealthCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final Provider<SessionFactoryService> sessionFactoryServiceProvider;
    @NotNull
    private final Provider<Transacter> transacterProvider;
    private ValidationReport report;
    @NotNull
    private static final Map<KClass<? extends Annotation>, ValidationReport> reports;

    public SchemaValidatorService(@NotNull KClass<? extends Annotation> qualifier, @NotNull Provider<SessionFactoryService> sessionFactoryServiceProvider, @NotNull Provider<Transacter> transacterProvider) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter(sessionFactoryServiceProvider, (String)"sessionFactoryServiceProvider");
        Intrinsics.checkNotNullParameter(transacterProvider, (String)"transacterProvider");
        this.qualifier = qualifier;
        this.sessionFactoryServiceProvider = sessionFactoryServiceProvider;
        this.transacterProvider = transacterProvider;
    }

    protected void startUp() {
        ValidationReport validationReport = reports.computeIfAbsent(this.qualifier, arg_0 -> SchemaValidatorService.startUp$lambda$0((Function1)new Function1<KClass<? extends Annotation>, ValidationReport>(this){
            final /* synthetic */ SchemaValidatorService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ValidationReport invoke(@NotNull KClass<? extends Annotation> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                SchemaValidator validator = new SchemaValidator();
                SessionFactoryService sessionFactoryService = (SessionFactoryService)SchemaValidatorService.access$getSessionFactoryServiceProvider$p(this.this$0).get();
                Object object = SchemaValidatorService.access$getTransacterProvider$p(this.this$0).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"transacterProvider.get()");
                return validator.validate$misk_hibernate((Transacter)object, sessionFactoryService.getHibernateMetadata());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)validationReport, (String)"override fun startUp() {\u2026ernateMetadata)\n    }\n  }");
        this.report = validationReport;
    }

    protected void shutDown() {
    }

    @NotNull
    public HealthStatus status() {
        Service.State state = this.state();
        if (state != Service.State.RUNNING) {
            String[] stringArray = new String[]{"SchemaValidatorService: " + this.qualifier.getSimpleName() + " is " + state};
            return HealthStatus.Companion.unhealthy(stringArray);
        }
        String[] stringArray = new String[1];
        String string = this.qualifier.getSimpleName();
        ValidationReport validationReport = this.report;
        if (validationReport == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"report");
            validationReport = null;
        }
        Set<String> set = validationReport.getSchemas();
        ValidationReport validationReport2 = this.report;
        if (validationReport2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"report");
            validationReport2 = null;
        }
        Set<String> set2 = validationReport2.getTables();
        ValidationReport validationReport3 = this.report;
        if (validationReport3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"report");
            validationReport3 = null;
        }
        int n = validationReport3.getColumns().size();
        ValidationReport validationReport4 = this.report;
        if (validationReport4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"report");
            validationReport4 = null;
        }
        stringArray[0] = "SchemaValidatorService: " + string + " is valid: schemas=" + set + " tables=" + set2 + " columnCount=" + n + " columns=" + validationReport4.getColumns();
        return HealthStatus.Companion.healthy(stringArray);
    }

    private static final ValidationReport startUp$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ValidationReport)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Provider access$getSessionFactoryServiceProvider$p(SchemaValidatorService $this) {
        return $this.sessionFactoryServiceProvider;
    }

    public static final /* synthetic */ Provider access$getTransacterProvider$p(SchemaValidatorService $this) {
        return $this.transacterProvider;
    }

    static {
        Map map = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(mutableM\u2026on>, ValidationReport>())");
        reports = map;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lmisk/hibernate/SchemaValidatorService$Companion;", "", "()V", "reports", "", "Lkotlin/reflect/KClass;", "", "Lmisk/hibernate/ValidationReport;", "misk-hibernate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

