/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.sql.DataSource;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KClassesJvm;
import kotlin.text.StringsKt;
import misk.hibernate.AggregateListener;
import misk.hibernate.BoxedStringType;
import misk.hibernate.ByteStringType;
import misk.hibernate.HibernateEntity;
import misk.hibernate.HibernateInjectorAccess;
import misk.hibernate.HibernateKt;
import misk.hibernate.Id;
import misk.hibernate.IdType;
import misk.hibernate.JsonColumn;
import misk.hibernate.JsonColumnType;
import misk.hibernate.ListenerRegistration;
import misk.hibernate.ProtoColumn;
import misk.hibernate.ProtoColumnType;
import misk.hibernate.SecretColumn;
import misk.hibernate.SecretColumnType;
import misk.hibernate.SessionFactoryServiceKt;
import misk.hibernate.TransacterService;
import misk.hibernate.TransformedColumnType;
import misk.hibernate.TransformedType;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceConnector;
import misk.jdbc.DataSourceType;
import okio.ByteString;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.usertype.UserType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004BS\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010 \u001a\u0004\u0018\u00010!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\b\u0010#\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0\u00062\u0006\u0010&\u001a\u00020'H\u0002J\u001c\u0010(\u001a\u00020)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020)H\u0014J\b\u0010/\u001a\u00020)H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00060"}, d2={"Lmisk/hibernate/SessionFactoryService;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lcom/google/inject/Provider;", "Lorg/hibernate/SessionFactory;", "Lmisk/hibernate/TransacterService;", "qualifier", "Lkotlin/reflect/KClass;", "", "connector", "Lmisk/jdbc/DataSourceConnector;", "dataSource", "Ljavax/sql/DataSource;", "hibernateInjectorAccess", "Lmisk/hibernate/HibernateInjectorAccess;", "entityClasses", "", "Lmisk/hibernate/HibernateEntity;", "listenerRegistrations", "Lmisk/hibernate/ListenerRegistration;", "(Lkotlin/reflect/KClass;Lmisk/jdbc/DataSourceConnector;Lcom/google/inject/Provider;Lmisk/hibernate/HibernateInjectorAccess;Ljava/util/Set;Ljava/util/Set;)V", "hibernateMetadata", "Lorg/hibernate/boot/Metadata;", "getHibernateMetadata", "()Lorg/hibernate/boot/Metadata;", "setHibernateMetadata", "(Lorg/hibernate/boot/Metadata;)V", "sessionFactory", "threadInTransaction", "Ljava/lang/ThreadLocal;", "", "getThreadInTransaction", "()Ljava/lang/ThreadLocal;", "findUserType", "Lorg/hibernate/usertype/UserType;", "propertyType", "get", "kClassForName", "", "name", "", "processPropertyAnnotations", "", "persistentClass", "Ljava/lang/Class;", "property", "Lorg/hibernate/mapping/Property;", "shutDown", "startUp", "misk-hibernate"})
@SourceDebugExtension(value={"SMAP\nSessionFactoryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionFactoryService.kt\nmisk/hibernate/SessionFactoryService\n+ 2 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n20#2:277\n288#3,2:278\n1603#3,9:281\n1855#3:290\n1856#3:292\n1612#3:293\n1#4:280\n1#4:291\n*S KotlinDebug\n*F\n+ 1 SessionFactoryService.kt\nmisk/hibernate/SessionFactoryService\n*L\n208#1:277\n208#1:278,2\n223#1:281,9\n223#1:290\n223#1:292\n223#1:293\n223#1:291\n*E\n"})
public final class SessionFactoryService
extends AbstractIdleService
implements Provider<SessionFactory>,
TransacterService {
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final DataSourceConnector connector;
    @NotNull
    private final Provider<DataSource> dataSource;
    @NotNull
    private final HibernateInjectorAccess hibernateInjectorAccess;
    @NotNull
    private final Set<HibernateEntity> entityClasses;
    @NotNull
    private final Set<ListenerRegistration> listenerRegistrations;
    @Nullable
    private SessionFactory sessionFactory;
    @NotNull
    private final ThreadLocal<Boolean> threadInTransaction;
    public Metadata hibernateMetadata;

    public SessionFactoryService(@NotNull KClass<? extends Annotation> qualifier, @NotNull DataSourceConnector connector, @NotNull Provider<DataSource> dataSource, @NotNull HibernateInjectorAccess hibernateInjectorAccess, @NotNull Set<HibernateEntity> entityClasses, @NotNull Set<ListenerRegistration> listenerRegistrations) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter(dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)hibernateInjectorAccess, (String)"hibernateInjectorAccess");
        Intrinsics.checkNotNullParameter(entityClasses, (String)"entityClasses");
        Intrinsics.checkNotNullParameter(listenerRegistrations, (String)"listenerRegistrations");
        this.qualifier = qualifier;
        this.connector = connector;
        this.dataSource = dataSource;
        this.hibernateInjectorAccess = hibernateInjectorAccess;
        this.entityClasses = entityClasses;
        this.listenerRegistrations = listenerRegistrations;
        this.threadInTransaction = new ThreadLocal<Boolean>(){

            @NotNull
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    public /* synthetic */ SessionFactoryService(KClass kClass, DataSourceConnector dataSourceConnector, Provider provider, HibernateInjectorAccess hibernateInjectorAccess, Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x20) != 0) {
            set2 = SetsKt.emptySet();
        }
        this((KClass<? extends Annotation>)kClass, dataSourceConnector, (Provider<DataSource>)provider, hibernateInjectorAccess, set, set2);
    }

    @NotNull
    public final ThreadLocal<Boolean> getThreadInTransaction() {
        return this.threadInTransaction;
    }

    @NotNull
    public final Metadata getHibernateMetadata() {
        Metadata metadata = this.hibernateMetadata;
        if (metadata != null) {
            return metadata;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"hibernateMetadata");
        return null;
    }

    public final void setHibernateMetadata(@NotNull Metadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"<set-?>");
        this.hibernateMetadata = metadata;
    }

    protected void startUp() {
        String[] value;
        Stopwatch stopwatch = Stopwatch.createStarted();
        SessionFactoryServiceKt.access$getLogger$p().info("Starting @" + this.qualifier.getSimpleName() + " Hibernate");
        if (!(this.sessionFactory == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Integrator integrator2 = new Integrator(this){
            final /* synthetic */ SessionFactoryService this$0;
            {
                this.this$0 = $receiver;
            }

            public void integrate(@NotNull Metadata metadata, @NotNull SessionFactoryImplementor sessionFactory, @NotNull SessionFactoryServiceRegistry serviceRegistry) {
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                Intrinsics.checkNotNullParameter((Object)sessionFactory, (String)"sessionFactory");
                Intrinsics.checkNotNullParameter((Object)serviceRegistry, (String)"serviceRegistry");
                EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
                AggregateListener aggregateListener = new AggregateListener(SessionFactoryService.access$getListenerRegistrations$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)eventListenerRegistry, (String)"eventListenerRegistry");
                aggregateListener.registerAll(eventListenerRegistry);
                this.this$0.setHibernateMetadata(metadata);
            }

            public void disintegrate(@NotNull SessionFactoryImplementor sessionFactory, @NotNull SessionFactoryServiceRegistry serviceRegistry) {
                Intrinsics.checkNotNullParameter((Object)sessionFactory, (String)"sessionFactory");
                Intrinsics.checkNotNullParameter((Object)serviceRegistry, (String)"serviceRegistry");
            }
        };
        BootstrapServiceRegistry bootstrapRegistryBuilder = new BootstrapServiceRegistryBuilder().applyIntegrator(integrator2).build();
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder(bootstrapRegistryBuilder);
        registryBuilder.addInitiator((StandardServiceInitiator)this.hibernateInjectorAccess);
        DataSourceConfig config = this.connector.config();
        StandardServiceRegistryBuilder $this$startUp_u24lambda_u241 = registryBuilder;
        boolean bl = false;
        $this$startUp_u24lambda_u241.applySetting("hibernate.connection.datasource", this.dataSource.get());
        $this$startUp_u24lambda_u241.applySetting("hibernate.dialect", (Object)config.getType().getHibernateDialect());
        $this$startUp_u24lambda_u241.applySetting("hibernate.show_sql", (Object)config.getShow_sql());
        $this$startUp_u24lambda_u241.applySetting("hibernate.generate_statistics", (Object)config.getGenerate_hibernate_stats());
        $this$startUp_u24lambda_u241.applySetting("hibernate.use_sql_comments", (Object)"true");
        $this$startUp_u24lambda_u241.applySetting("hibernate.jdbc.use_get_generated_keys", (Object)"true");
        $this$startUp_u24lambda_u241.applySetting("hibernate.id.new_generator_mappings", (Object)"false");
        $this$startUp_u24lambda_u241.applySetting("hibernate.jdbc.time_zone", (Object)"UTC");
        if (config.getType() != DataSourceType.VITESS_MYSQL) {
            $this$startUp_u24lambda_u241.applySetting("hibernate.connection.provider_disables_autocommit", (Object)"true");
        }
        if (config.getQuery_timeout() != null) {
            Duration duration = config.getQuery_timeout();
            Intrinsics.checkNotNull((Object)duration);
            $this$startUp_u24lambda_u241.applySetting("javax.persistence.query.timeout", (Object)((int)duration.toMillis()));
        }
        if (config.getJdbc_statement_batch_size() != null) {
            Integer n = config.getJdbc_statement_batch_size();
            Intrinsics.checkNotNull((Object)n);
            if (!(n > 0)) {
                boolean $i$a$-require-SessionFactoryService$startUp$1$22 = false;
                String $i$a$-require-SessionFactoryService$startUp$1$22 = "Invalid jdbc_statement_batch_size: must be > 0.";
                throw new IllegalArgumentException($i$a$-require-SessionFactoryService$startUp$1$22.toString());
            }
            $this$startUp_u24lambda_u241.applySetting("hibernate.jdbc.batch_size", (Object)config.getJdbc_statement_batch_size());
        }
        StandardServiceRegistry registry = registryBuilder.build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)registry);
        for (HibernateEntity entityClass : this.entityClasses) {
            metadataSources.addAnnotatedClass(JvmClassMappingKt.getJavaClass(entityClass.getEntity()));
        }
        MetadataBuilder metadataDraftBuilder = metadataSources.getMetadataBuilder();
        Metadata metadata = metadataDraftBuilder.build();
        Intrinsics.checkNotNull((Object)metadata, (String)"null cannot be cast to non-null type org.hibernate.boot.spi.MetadataImplementor");
        MetadataImplementor metadataDraft = (MetadataImplementor)metadata;
        Set allPropertyTypes = new LinkedHashSet();
        for (Object object : HibernateKt.getAllProperties((Metadata)metadataDraft).entries()) {
            String string;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"metadataDraft.allProperties.entries()");
            Class persistentClass = (Class)object.getKey();
            Property property = (Property)object.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)persistentClass, (String)"persistentClass");
            Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
            this.processPropertyAnnotations(persistentClass, property);
            value = property.getValue();
            if (!(value instanceof SimpleValue) || (string = ((SimpleValue)value).getTypeName()) == null) continue;
            String typeName = string;
            ((Collection)allPropertyTypes).add(this.kClassForName(typeName));
        }
        metadataDraft.getTypeConfiguration().sessionFactoryClosed(null);
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        for (KClass propertyType : allPropertyTypes) {
            UserType userType = this.findUserType(propertyType);
            if (userType == null) continue;
            value = new String[]{KClassesJvm.getJvmName((KClass)propertyType)};
            metadataBuilder.applyBasicType(userType, value);
        }
        Metadata metadata2 = metadataBuilder.build();
        Intrinsics.checkNotNull((Object)metadata2, (String)"null cannot be cast to non-null type org.hibernate.boot.spi.MetadataImplementor");
        MetadataImplementor metadata3 = (MetadataImplementor)metadata2;
        for (Map.Entry entry : HibernateKt.getAllProperties((Metadata)metadata3).entries()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"metadata.allProperties.entries()");
            Class persistentClass = (Class)entry.getKey();
            Property property = (Property)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)persistentClass, (String)"persistentClass");
            Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
            this.processPropertyAnnotations(persistentClass, property);
        }
        this.sessionFactory = metadata3.buildSessionFactory();
        SessionFactoryServiceKt.access$getLogger$p().info("Started @" + this.qualifier.getSimpleName() + " Hibernate in " + stopwatch);
    }

    /*
     * WARNING - void declaration
     */
    private final void processPropertyAnnotations(Class<?> persistentClass, Property property) {
        Annotation[] annotationArray = property.getValue();
        SimpleValue simpleValue = annotationArray instanceof SimpleValue ? (SimpleValue)annotationArray : null;
        if (simpleValue == null) {
            return;
        }
        SimpleValue value = simpleValue;
        Field field = HibernateKt.field(persistentClass, property);
        if (field.isAnnotationPresent(JsonColumn.class)) {
            value.setTypeName(JsonColumnType.class.getName());
            HibernateKt.setTypeParameter(value, "jsonColumnField", field);
        } else if (field.isAnnotationPresent(ProtoColumn.class)) {
            value.setTypeName(ProtoColumnType.class.getName());
            HibernateKt.setTypeParameter(value, "protoColumnField", field);
        } else if (field.isAnnotationPresent(SecretColumn.class)) {
            value.setTypeName(SecretColumnType.class.getName());
            HibernateKt.setTypeParameter(value, "key_name", field.getAnnotation(SecretColumn.class).keyName());
            HibernateKt.setTypeParameter(value, "indexable", String.valueOf(field.getAnnotation(SecretColumn.class).indexable()));
        } else {
            Class<?> clazz = field.getType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"field.type");
            if (BoxedStringType.Companion.isBoxedString(JvmClassMappingKt.getKotlinClass(clazz))) {
                value.setTypeName(BoxedStringType.class.getName());
                HibernateKt.setTypeParameter(value, "boxedStringField", field);
            } else {
                Annotation[] annotationArray2 = field.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"field.annotations");
                annotationArray = annotationArray2;
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    void $this$mapNotNullTo$iv$iv;
                    Object object;
                    TransformedType transformerAnnotation;
                    Object v3;
                    Object it$iv;
                    Object $this$firstOrNull$iv$iv;
                    Annotation annotation;
                    block14: {
                        Intrinsics.checkNotNullExpressionValue((Object)annotationArray[i], (String)"field.annotations");
                        KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)JvmClassMappingKt.getAnnotationClass((Annotation)annotation);
                        boolean $i$f$findAnnotation = false;
                        $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                        boolean $i$f$firstOrNull = false;
                        Iterator iterator = $this$firstOrNull$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv$iv = iterator.next();
                            it$iv = (Annotation)element$iv$iv;
                            boolean bl = false;
                            if (!(it$iv instanceof TransformedType)) continue;
                            v3 = element$iv$iv;
                            break block14;
                        }
                        v3 = null;
                    }
                    if ((TransformedType)((Annotation)v3) == null) continue;
                    value.setTypeName(TransformedColumnType.class.getName());
                    KClass transformer = Reflection.getOrCreateKotlinClass(transformerAnnotation.transformer());
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getTRANSFORMER_CLASS(), transformer);
                    String tableName = persistentClass.getAnnotation(Table.class).name();
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getTABLE_NAME(), tableName);
                    $this$firstOrNull$iv$iv = field.getAnnotation(Column.class).name();
                    if ($this$firstOrNull$iv$iv.length() == 0) {
                        boolean bl = false;
                        object = field.getName();
                    } else {
                        object = $this$firstOrNull$iv$iv;
                    }
                    String columnName = (String)object;
                    String string = TransformedColumnType.Companion.getCOLUMN_NAME();
                    Intrinsics.checkNotNullExpressionValue((Object)columnName, (String)"columnName");
                    HibernateKt.setTypeParameter(value, string, columnName);
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getFIELD(), field);
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getTARGET_TYPE(), Reflection.getOrCreateKotlinClass(transformerAnnotation.targetType()));
                    Collection memberProperties = KClasses.getDeclaredMemberProperties((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                    Iterable $this$mapNotNull$iv = memberProperties;
                    boolean $i$f$mapNotNull = false;
                    it$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Pair it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        KProperty1 prop = (KProperty1)element$iv$iv;
                        boolean bl2 = false;
                        if (((prop instanceof KProperty1 ? prop : null) == null ? null : TuplesKt.to((Object)prop.getName(), (Object)prop.get((Object)annotation))) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Map argMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getARGUMENTS(), argMap);
                }
            }
        }
    }

    private final UserType findUserType(KClass<?> propertyType) {
        KClass<?> kClass = propertyType;
        return Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Id.class)) ? (UserType)new IdType() : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(ByteString.class)) ? (UserType)ByteStringType.INSTANCE : null);
    }

    private final KClass<? extends Object> kClassForName(String name) {
        KClass kClass;
        switch (name) {
            case "boolean": {
                kClass = Reflection.getOrCreateKotlinClass(Boolean.TYPE);
                break;
            }
            case "byte": {
                kClass = Reflection.getOrCreateKotlinClass(Byte.TYPE);
                break;
            }
            case "short": {
                kClass = Reflection.getOrCreateKotlinClass(Short.TYPE);
                break;
            }
            case "int": {
                kClass = Reflection.getOrCreateKotlinClass(Integer.TYPE);
                break;
            }
            case "long": {
                kClass = Reflection.getOrCreateKotlinClass(Long.TYPE);
                break;
            }
            case "char": {
                kClass = Reflection.getOrCreateKotlinClass(Character.TYPE);
                break;
            }
            case "float": {
                kClass = Reflection.getOrCreateKotlinClass(Float.TYPE);
                break;
            }
            case "double": {
                kClass = Reflection.getOrCreateKotlinClass(Double.TYPE);
                break;
            }
            case "materialized_clob": {
                kClass = Reflection.getOrCreateKotlinClass(String.class);
                break;
            }
            default: {
                Class<?> clazz = Class.forName(name);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(name)");
                kClass = JvmClassMappingKt.getKotlinClass(clazz);
            }
        }
        return kClass;
    }

    protected void shutDown() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        SessionFactoryServiceKt.access$getLogger$p().info("Stopping @" + this.qualifier.getSimpleName() + " Hibernate");
        if (!(this.sessionFactory != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SessionFactory sessionFactory = this.sessionFactory;
        Intrinsics.checkNotNull((Object)sessionFactory);
        sessionFactory.close();
        SessionFactoryServiceKt.access$getLogger$p().info("Stopped @" + this.qualifier.getSimpleName() + " Hibernate in " + stopwatch);
    }

    @NotNull
    public SessionFactory get() {
        SessionFactory sessionFactory = this.sessionFactory;
        if (sessionFactory == null) {
            throw new IllegalStateException(StringsKt.trimMargin$default((String)("\n      |@" + this.qualifier.getSimpleName() + " Hibernate not connected: did you forget to start the service?\n      |    If this is a test, then annotate your test class with @MiskTest(startService = true)\n      |"), null, (int)1, null));
        }
        return sessionFactory;
    }

    public static final /* synthetic */ Set access$getListenerRegistrations$p(SessionFactoryService $this) {
        return $this.listenerRegistrations;
    }
}

