/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import misk.hibernate.DbTimestampedEntity;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lmisk/hibernate/TimestampListener;", "Lorg/hibernate/event/spi/PreInsertEventListener;", "Lorg/hibernate/event/spi/PreUpdateEventListener;", "()V", "clock", "Ljava/time/Clock;", "getClock", "()Ljava/time/Clock;", "setClock", "(Ljava/time/Clock;)V", "onPreInsert", "", "event", "Lorg/hibernate/event/spi/PreInsertEvent;", "onPreUpdate", "Lorg/hibernate/event/spi/PreUpdateEvent;", "misk-hibernate"})
public final class TimestampListener
implements PreInsertEventListener,
PreUpdateEventListener {
    @Inject
    public Clock clock;

    @Inject
    public TimestampListener() {
    }

    @NotNull
    public final Clock getClock() {
        Clock clock = this.clock;
        if (clock != null) {
            return clock;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"clock");
        return null;
    }

    public final void setClock(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"<set-?>");
        this.clock = clock;
    }

    public boolean onPreInsert(@NotNull PreInsertEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object entity = event.getEntity();
        if (entity instanceof DbTimestampedEntity) {
            Instant instant = this.getClock().instant();
            Intrinsics.checkNotNull((Object)instant);
            Instant now = instant;
            ((DbTimestampedEntity)entity).setCreated_at(now);
            ((DbTimestampedEntity)entity).setUpdated_at(now);
            Object[] objectArray = event.getState();
            String[] stringArray = event.getPersister().getPropertyNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"event.persister.propertyNames");
            objectArray[ArraysKt.indexOf((Object[])((Object[])stringArray), (Object)"created_at")] = now;
            Object[] objectArray2 = event.getState();
            String[] stringArray2 = event.getPersister().getPropertyNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"event.persister.propertyNames");
            objectArray2[ArraysKt.indexOf((Object[])((Object[])stringArray2), (Object)"updated_at")] = now;
        }
        return false;
    }

    public boolean onPreUpdate(@NotNull PreUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object entity = event.getEntity();
        if (entity instanceof DbTimestampedEntity) {
            Instant instant = this.getClock().instant();
            Intrinsics.checkNotNull((Object)instant);
            Instant now = instant;
            ((DbTimestampedEntity)entity).setUpdated_at(now);
            Object[] objectArray = event.getState();
            String[] stringArray = event.getPersister().getPropertyNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"event.persister.propertyNames");
            objectArray[ArraysKt.indexOf((Object[])((Object[])stringArray), (Object)"updated_at")] = now;
        }
        return false;
    }
}

