/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.google.inject.Injector;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import misk.hibernate.HibernateInjectorAccessKt;
import misk.hibernate.HibernateKt;
import misk.hibernate.TransformedColumnTypeKt;
import misk.hibernate.Transformer;
import misk.hibernate.TransformerContext;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0000\u0018\u0000 A2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u001c\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00182\b\u0010\"\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010#\u001a\u00020\u0012H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\u0018H\u0016J\b\u0010&\u001a\u00020 H\u0016J=\u0010'\u001a\u0004\u0018\u00010\u00182\b\u0010(\u001a\u0004\u0018\u00010)2\u000e\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010/J,\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u00104\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J(\u00105\u001a\u0004\u0018\u00010\u00182\b\u00106\u001a\u0004\u0018\u00010\u00182\b\u00107\u001a\u0004\u0018\u00010\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0016J\f\u00108\u001a\u0006\u0012\u0002\b\u000309H\u0016J\u0010\u0010:\u001a\u0002012\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u0002012\u0006\u0010>\u001a\u00020\u0012H\u0016J\b\u0010?\u001a\u00020@H\u0016R\u001e\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006B"}, d2={"Lmisk/hibernate/TransformedColumnType;", "Lorg/hibernate/usertype/UserType;", "Lorg/hibernate/usertype/ParameterizedType;", "Lorg/hibernate/type/spi/TypeConfigurationAware;", "()V", "retClass", "Lkotlin/reflect/KClass;", "getRetClass", "()Lkotlin/reflect/KClass;", "setRetClass", "(Lkotlin/reflect/KClass;)V", "transformer", "Lmisk/hibernate/Transformer;", "getTransformer", "()Lmisk/hibernate/Transformer;", "setTransformer", "(Lmisk/hibernate/Transformer;)V", "typeConfig", "Lorg/hibernate/type/spi/TypeConfiguration;", "getTypeConfig", "()Lorg/hibernate/type/spi/TypeConfiguration;", "setTypeConfig", "(Lorg/hibernate/type/spi/TypeConfiguration;)V", "assemble", "", "cached", "Ljava/io/Serializable;", "owner", "deepCopy", "value", "disassemble", "equals", "", "x", "y", "getTypeConfiguration", "hashCode", "", "isMutable", "nullSafeGet", "rs", "Ljava/sql/ResultSet;", "names", "", "", "session", "Lorg/hibernate/engine/spi/SharedSessionContractImplementor;", "(Ljava/sql/ResultSet;[Ljava/lang/String;Lorg/hibernate/engine/spi/SharedSessionContractImplementor;Ljava/lang/Object;)Ljava/lang/Object;", "nullSafeSet", "", "st", "Ljava/sql/PreparedStatement;", "index", "replace", "original", "target", "returnedClass", "Ljava/lang/Class;", "setParameterValues", "parameters", "Ljava/util/Properties;", "setTypeConfiguration", "typeConfiguration", "sqlTypes", "", "Companion", "misk-hibernate"})
public final class TransformedColumnType
implements UserType,
ParameterizedType,
TypeConfigurationAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public KClass<?> retClass;
    public Transformer transformer;
    public TypeConfiguration typeConfig;
    @NotNull
    private static final String TRANSFORMER_CLASS = "transformerClass";
    @NotNull
    private static final String TABLE_NAME = "tableName";
    @NotNull
    private static final String COLUMN_NAME = "columnName";
    @NotNull
    private static final String FIELD = "field";
    @NotNull
    private static final String TARGET_TYPE = "targetType";
    @NotNull
    private static final String ARGUMENTS = "arguments";

    @NotNull
    public final KClass<?> getRetClass() {
        KClass<?> kClass = this.retClass;
        if (kClass != null) {
            return kClass;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"retClass");
        return null;
    }

    public final void setRetClass(@NotNull KClass<?> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"<set-?>");
        this.retClass = kClass;
    }

    @NotNull
    public final Transformer getTransformer() {
        Transformer transformer = this.transformer;
        if (transformer != null) {
            return transformer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"transformer");
        return null;
    }

    public final void setTransformer(@NotNull Transformer transformer) {
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"<set-?>");
        this.transformer = transformer;
    }

    @NotNull
    public final TypeConfiguration getTypeConfig() {
        TypeConfiguration typeConfiguration = this.typeConfig;
        if (typeConfiguration != null) {
            return typeConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"typeConfig");
        return null;
    }

    public final void setTypeConfig(@NotNull TypeConfiguration typeConfiguration) {
        Intrinsics.checkNotNullParameter((Object)typeConfiguration, (String)"<set-?>");
        this.typeConfig = typeConfiguration;
    }

    public int hashCode(@NotNull Object x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return x.hashCode();
    }

    @Nullable
    public Object deepCopy(@Nullable Object value) {
        return value;
    }

    @Nullable
    public Object replace(@Nullable Object original, @Nullable Object target2, @Nullable Object owner) {
        return original;
    }

    public boolean equals(@Nullable Object x, @Nullable Object y) {
        return Intrinsics.areEqual((Object)x, (Object)y);
    }

    @NotNull
    public Class<?> returnedClass() {
        return JvmClassMappingKt.getJavaClass(this.getRetClass());
    }

    @NotNull
    public Object assemble(@NotNull Serializable cached, @NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)cached, (String)"cached");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return this.getTransformer().assemble(owner, cached);
    }

    @NotNull
    public Serializable disassemble(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.getTransformer().disassemble(value);
    }

    public void nullSafeSet(@NotNull PreparedStatement st, @Nullable Object value, int index, @Nullable SharedSessionContractImplementor session) {
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        if (value == null) {
            st.setNull(index, ArraysKt.first((int[])this.sqlTypes()));
        } else {
            Serializable disassembled = this.getTransformer().disassemble(value);
            TransformedColumnTypeKt.setByType(st, this.getRetClass(), index, disassembled);
        }
    }

    @Nullable
    public Object nullSafeGet(@Nullable ResultSet rs, @NotNull String[] names, @Nullable SharedSessionContractImplementor session, @Nullable Object owner) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        Object object = rs;
        if (object == null || (object = TransformedColumnTypeKt.getByType((ResultSet)object, this.getRetClass(), names[0])) == null) {
            return null;
        }
        Object disassembled = object;
        return this.getTransformer().assemble(owner, (Serializable)disassembled);
    }

    public boolean isMutable() {
        return false;
    }

    @NotNull
    public int[] sqlTypes() {
        int n;
        int[] nArray = new int[1];
        KClass<?> kClass = this.getRetClass();
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
            n = -3;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            n = 12;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            n = 4;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            n = -5;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            n = 5;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            n = 16;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            n = 8;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            n = 6;
        } else {
            throw new HibernateException("Unsupported sql type");
        }
        nArray[0] = n;
        return nArray;
    }

    public void setParameterValues(@NotNull Properties parameters) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Object object = parameters.get(TARGET_TYPE);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
        this.setRetClass((KClass)object);
        Field field = HibernateKt.getField(parameters, FIELD);
        Intrinsics.checkNotNull((Object)field);
        Field field2 = field;
        Object object2 = parameters.get(ARGUMENTS);
        Map map = object2 instanceof Map ? (Map)object2 : null;
        if (map == null) {
            throw new HibernateException("Bad Transformer arguments");
        }
        Map ctorArgs = map;
        Object object3 = parameters.get(TABLE_NAME);
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object3;
        Object object4 = parameters.get(COLUMN_NAME);
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
        String string2 = (String)object4;
        Class<?> clazz = field2.getType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"field.type");
        TransformerContext context = new TransformerContext(string, string2, ctorArgs, JvmClassMappingKt.getKotlinClass(clazz));
        Object object5 = parameters.get(TRANSFORMER_CLASS);
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<out misk.hibernate.Transformer>");
        KClass transformerClass = (KClass)object5;
        Object object6 = KClasses.getPrimaryConstructor((KClass)transformerClass);
        if (object6 == null || (object6 = (Transformer)object6.call(objectArray = new Object[]{context})) == null) {
            throw new HibernateException("Transformer class missing primary constructor");
        }
        this.setTransformer((Transformer)object6);
        StandardServiceRegistry standardServiceRegistry = this.getTypeConfig().getMetadataBuildingContext().getBootstrapContext().getServiceRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)standardServiceRegistry, (String)"typeConfig.metadataBuild\u2026apContext.serviceRegistry");
        Injector injector = HibernateInjectorAccessKt.getInjector((ServiceRegistry)standardServiceRegistry);
        injector.injectMembers((Object)this.getTransformer());
    }

    public void setTypeConfiguration(@NotNull TypeConfiguration typeConfiguration) {
        Intrinsics.checkNotNullParameter((Object)typeConfiguration, (String)"typeConfiguration");
        this.setTypeConfig(typeConfiguration);
    }

    @NotNull
    public TypeConfiguration getTypeConfiguration() {
        return this.getTypeConfig();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lmisk/hibernate/TransformedColumnType$Companion;", "", "()V", "ARGUMENTS", "", "getARGUMENTS", "()Ljava/lang/String;", "COLUMN_NAME", "getCOLUMN_NAME", "FIELD", "getFIELD", "TABLE_NAME", "getTABLE_NAME", "TARGET_TYPE", "getTARGET_TYPE", "TRANSFORMER_CLASS", "getTRANSFORMER_CLASS", "misk-hibernate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTRANSFORMER_CLASS() {
            return TRANSFORMER_CLASS;
        }

        @NotNull
        public final String getTABLE_NAME() {
            return TABLE_NAME;
        }

        @NotNull
        public final String getCOLUMN_NAME() {
            return COLUMN_NAME;
        }

        @NotNull
        public final String getFIELD() {
            return FIELD;
        }

        @NotNull
        public final String getTARGET_TYPE() {
            return TARGET_TYPE;
        }

        @NotNull
        public final String getARGUMENTS() {
            return ARGUMENTS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

