/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate.actions;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import misk.MiskCaller;
import misk.exceptions.BadRequestException;
import misk.exceptions.UnauthorizedException;
import misk.hibernate.DbEntity;
import misk.hibernate.Operator;
import misk.hibernate.Query;
import misk.hibernate.ReflectionQuery;
import misk.hibernate.Session;
import misk.hibernate.Transacter;
import misk.hibernate.actions.HibernateDatabaseQueryWebActionModule;
import misk.hibernate.actions.HibernateQuery;
import misk.inject.GuiceKt;
import misk.scope.ActionScoped;
import misk.web.Post;
import misk.web.RequestBody;
import misk.web.RequestContentType;
import misk.web.ResponseContentType;
import misk.web.actions.WebAction;
import misk.web.dashboard.AdminDashboardAccess;
import misk.web.metadata.database.DatabaseQueryMetadata;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0001\u0018\u0000 (2\u00020\u0001:\u0003()*BC\b\u0007\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ0\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017H\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0007JH\u0010\u001b\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0006\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u00060\u00060\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J<\u0010\u001b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001d0!0\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J<\u0010$\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00180%*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00180%2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'H\u0002R\u001e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lmisk/hibernate/actions/HibernateDatabaseQueryStaticAction;", "Lmisk/web/actions/WebAction;", "callerProvider", "Lmisk/scope/ActionScoped;", "Lmisk/MiskCaller;", "databaseQueryMetadata", "", "Lmisk/web/metadata/database/DatabaseQueryMetadata;", "queries", "Lmisk/hibernate/actions/HibernateQuery;", "injector", "Lcom/google/inject/Injector;", "queryLimitsConfig", "Lmisk/hibernate/ReflectionQuery$QueryLimitsConfig;", "(Lmisk/scope/ActionScoped;Ljava/util/List;Ljava/util/List;Lcom/google/inject/Injector;Lmisk/hibernate/ReflectionQuery$QueryLimitsConfig;)V", "getCallerProvider$annotations", "()V", "getStaticSelectPaths", "", "request", "Lmisk/hibernate/actions/HibernateDatabaseQueryStaticAction$Request;", "metadata", "dbEntity", "Lkotlin/reflect/KClass;", "Lmisk/hibernate/DbEntity;", "query", "Lmisk/hibernate/actions/HibernateDatabaseQueryStaticAction$Response;", "runStaticQuery", "Lkotlin/Pair;", "", "session", "Lmisk/hibernate/Session;", "principal", "", "transacter", "Lmisk/hibernate/Transacter;", "configureStatic", "Lmisk/hibernate/Query;", "rowLimit", "", "Companion", "Request", "Response", "misk-hibernate"})
@SourceDebugExtension(value={"SMAP\nHibernateDatabaseQueryStaticAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HibernateDatabaseQueryStaticAction.kt\nmisk/hibernate/actions/HibernateDatabaseQueryStaticAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,171:1\n1549#2:172\n1620#2,3:173\n288#2,2:177\n1#3:176\n215#4,2:179\n12#5:181\n*S KotlinDebug\n*F\n+ 1 HibernateDatabaseQueryStaticAction.kt\nmisk/hibernate/actions/HibernateDatabaseQueryStaticAction\n*L\n86#1:172\n86#1:173,3\n117#1:177,2\n134#1:179,2\n166#1:181\n*E\n"})
public final class HibernateDatabaseQueryStaticAction
implements WebAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActionScoped<MiskCaller> callerProvider;
    @NotNull
    private final List<DatabaseQueryMetadata> databaseQueryMetadata;
    @NotNull
    private final List<HibernateQuery> queries;
    @NotNull
    private final Injector injector;
    @NotNull
    private final ReflectionQuery.QueryLimitsConfig queryLimitsConfig;
    @NotNull
    private static final KLogger logger;
    @NotNull
    public static final String HIBERNATE_QUERY_STATIC_WEBACTION_PATH = "/api/database/query/hibernate/static";

    @Inject
    public HibernateDatabaseQueryStaticAction(@NotNull ActionScoped<MiskCaller> callerProvider, @NotNull List<DatabaseQueryMetadata> databaseQueryMetadata, @NotNull List<HibernateQuery> queries, @NotNull Injector injector, @NotNull ReflectionQuery.QueryLimitsConfig queryLimitsConfig) {
        Intrinsics.checkNotNullParameter(callerProvider, (String)"callerProvider");
        Intrinsics.checkNotNullParameter(databaseQueryMetadata, (String)"databaseQueryMetadata");
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        Intrinsics.checkNotNullParameter((Object)injector, (String)"injector");
        Intrinsics.checkNotNullParameter((Object)queryLimitsConfig, (String)"queryLimitsConfig");
        this.callerProvider = callerProvider;
        this.databaseQueryMetadata = databaseQueryMetadata;
        this.queries = queries;
        this.injector = injector;
        this.queryLimitsConfig = queryLimitsConfig;
    }

    @JvmSuppressWildcards
    private static /* synthetic */ void getCallerProvider$annotations() {
    }

    @Post(pathPattern="/api/database/query/hibernate/static")
    @RequestContentType(value={"application/json;charset=utf-8"})
    @ResponseContentType(value={"application/json;charset=utf-8"})
    @AdminDashboardAccess
    @NotNull
    public final Response query(@RequestBody @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this.callerProvider.get();
        Intrinsics.checkNotNull((Object)object);
        MiskCaller caller = (MiskCaller)object;
        String queryClass = request.getQueryClass();
        HibernateDatabaseQueryWebActionModule.Companion.checkQueryMatchesAction(queryClass, false);
        DatabaseQueryMetadata metadata = HibernateDatabaseQueryWebActionModule.Companion.findDatabaseQueryMetadata(this.databaseQueryMetadata, queryClass);
        Transacter transacter = HibernateDatabaseQueryWebActionModule.Companion.getTransacterForDatabaseQueryAction(this.injector, metadata);
        if (!caller.isAllowed(metadata.getAllowedCapabilities(), metadata.getAllowedServices())) {
            throw new UnauthorizedException("Unauthorized to query [dbEntity=" + metadata.getEntityClass() + "]", null, 2, null);
        }
        List<Map<String, Object>> results = this.runStaticQuery(transacter, caller.getPrincipal(), request, metadata);
        return new Response(results);
    }

    private final List<Map<String, Object>> runStaticQuery(Transacter transacter, String principal, Request request, DatabaseQueryMetadata metadata) {
        return (List)transacter.transaction((Function1)new Function1<Session, List<? extends Map<String, ? extends Object>>>(this, principal, request, metadata){
            final /* synthetic */ HibernateDatabaseQueryStaticAction this$0;
            final /* synthetic */ String $principal;
            final /* synthetic */ Request $request;
            final /* synthetic */ DatabaseQueryMetadata $metadata;
            {
                this.this$0 = $receiver;
                this.$principal = $principal;
                this.$request = $request;
                this.$metadata = $metadata;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Map<String, Object>> invoke(@NotNull Session session) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Pair pair = HibernateDatabaseQueryStaticAction.access$runStaticQuery(this.this$0, session, this.$principal, this.$request, this.$metadata);
                List selectPaths = (List)pair.component1();
                List rows2 = (List)pair.component2();
                Iterable $this$map$iv = rows2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapIndexedTo$iv$iv;
                    void row;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$mapIndexed$iv = (Iterable)row;
                    boolean $i$f$mapIndexed = false;
                    Iterable iterable2 = $this$mapIndexed$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (T item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                        void cell;
                        void index;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        T t = item$iv$iv2;
                        int n2 = n;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(TuplesKt.to(selectPaths.get((int)index), (Object)cell));
                    }
                    collection.add(MapsKt.toMap((Iterable)((List)destination$iv$iv2)));
                }
                return (List)destination$iv$iv;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<String>, List<List<Object>>> runStaticQuery(Session session, String principal, Request request, DatabaseQueryMetadata metadata) {
        Collection<Object> collection;
        Object $i$f$map22;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv;
        block3: {
            $this$map$iv = this.queries;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection<Object> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                HibernateQuery hibernateQuery = (HibernateQuery)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getQuery());
            }
            $i$f$map22 = (Type[])((List)destination$iv$iv);
            $this$mapTo$iv$iv = $i$f$map22.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                destination$iv$iv = $this$mapTo$iv$iv.next();
                KClass it = (KClass)destination$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSimpleName(), (Object)metadata.getQueryClass())) continue;
                collection = destination$iv$iv;
                break block3;
            }
            collection = null;
        }
        KClass kClass = (KClass)collection;
        if (kClass == null) {
            throw new BadRequestException("[query=" + metadata.getQueryClass() + "] does not exist", null, 2, null);
        }
        KClass query = kClass;
        $this$mapTo$iv$iv = GuiceKt.typeLiteral((KClass)query).getSupertype(Query.class).getType();
        Intrinsics.checkNotNull((Object)$this$mapTo$iv$iv, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        $i$f$map22 = ((ParameterizedType)$this$mapTo$iv$iv).getActualTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$map22, (String)"query.typeLiteral().getS\u2026    ).actualTypeArguments");
        $this$map$iv = ArraysKt.first((Object[])((Object[])$i$f$map22));
        Intrinsics.checkNotNull((Object)$this$map$iv, (String)"null cannot be cast to non-null type java.lang.Class<misk.hibernate.DbEntity<*>>");
        KClass dbEntity = JvmClassMappingKt.getKotlinClass((Class)((Class)$this$map$iv));
        Map map = (Map)request.getQuery().get("Config/Query");
        $i$f$map22 = (Double)(map != null ? map.get("maxRows") : null);
        int maxRows = $i$f$map22 != null ? (int)((Double)$i$f$map22).doubleValue() : this.queryLimitsConfig.getMaxMaxRows();
        Query<DbEntity<?>> configuredQuery = this.configureStatic((Query<? extends DbEntity<?>>)new ReflectionQuery.Factory(this.queryLimitsConfig).newQuery(query), request, metadata, maxRows);
        List<String> selectPaths = this.getStaticSelectPaths(request, metadata, dbEntity);
        logger.info("Query sent from dashboard [principal=" + principal + "][dbEntity=" + request.getEntityClass() + "][selectPaths=" + selectPaths + "] " + request.getQuery());
        List<List<Object>> rows2 = configuredQuery.dynamicList(session, selectPaths);
        return new Pair(selectPaths, rows2);
    }

    private final List<String> getStaticSelectPaths(Request request, DatabaseQueryMetadata metadata, KClass<DbEntity<?>> dbEntity) {
        DatabaseQueryMetadata.SelectMetadata selectMetadata;
        DatabaseQueryMetadata.SelectMetadata selectMetadata2;
        Object v0;
        Object object;
        block4: {
            Iterable $this$firstOrNull$iv = request.getQuery().entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String[] stringArray;
                object = (Map.Entry)element$iv;
                boolean bl = false;
                String key = (String)object.getKey();
                if (!Intrinsics.areEqual((Object)CollectionsKt.first((List)StringsKt.split$default((CharSequence)key, (String[])(stringArray = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)), (Object)"Select")) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry != null) {
            Object v1;
            block5: {
                Map.Entry entry2 = entry;
                boolean bl = false;
                String key = (String)entry2.getKey();
                object = metadata.getSelects();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    DatabaseQueryMetadata.SelectMetadata it = (DatabaseQueryMetadata.SelectMetadata)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getParametersTypeName(), (Object)key)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            selectMetadata2 = v1;
        } else {
            selectMetadata2 = null;
        }
        DatabaseQueryMetadata.SelectMetadata selectMetadata3 = selectMetadata = selectMetadata2;
        return HibernateDatabaseQueryWebActionModule.Companion.validateSelectPathsOrDefault(dbEntity, selectMetadata3 != null ? selectMetadata3.getPaths() : null);
    }

    private final Query<? extends DbEntity<?>> configureStatic(Query<? extends DbEntity<?>> $this$configureStatic, Request request, DatabaseQueryMetadata metadata, int rowLimit) {
        Query<DbEntity<?>> query;
        Query<DbEntity<?>> $this$configureStatic_u24lambda_u2410 = query = $this$configureStatic;
        boolean bl = false;
        $this$configureStatic_u24lambda_u2410.setMaxRows(rowLimit);
        Map<String, Object> $this$forEach$iv = request.getQuery();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object v3;
            Iterable it;
            block5: {
                DatabaseQueryMetadata.ConstraintMetadata it2;
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = entry.getKey();
                Object value = entry.getValue();
                String[] stringArray = new String[]{"/"};
                String string = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)key, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                if (Intrinsics.areEqual((Object)string, (Object)"Constraint")) {
                    Object v0;
                    block4: {
                        Iterable iterable = metadata.getConstraints();
                        for (Object t : iterable) {
                            it2 = (DatabaseQueryMetadata.ConstraintMetadata)t;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it2.getParametersTypeName(), (Object)key)) continue;
                            v0 = t;
                            break block4;
                        }
                        v0 = null;
                    }
                    if ((DatabaseQueryMetadata.ConstraintMetadata)v0 == null) continue;
                    boolean bl4 = false;
                    String string2 = it.getPath();
                    Operator operator = Operator.valueOf(it.getOperator());
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                    $this$configureStatic_u24lambda_u2410.dynamicAddConstraint(string2, operator, ((Map)value).get(it.getName()));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"Order")) continue;
                it = metadata.getOrders();
                for (Object t : it) {
                    it2 = (DatabaseQueryMetadata.OrderMetadata)t;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it2.getParametersTypeName(), (Object)key)) continue;
                    v3 = t;
                    break block5;
                }
                v3 = null;
            }
            DatabaseQueryMetadata.OrderMetadata orderMetadata = v3;
            if (orderMetadata == null) continue;
            it = orderMetadata;
            boolean bl6 = false;
            $this$configureStatic_u24lambda_u2410.dynamicAddOrder(it.getPath(), it.getAscending());
        }
        return query;
    }

    public static final /* synthetic */ Pair access$runStaticQuery(HibernateDatabaseQueryStaticAction $this, Session session, String principal, Request request, DatabaseQueryMetadata metadata) {
        return $this.runStaticQuery(session, principal, request, metadata);
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(HibernateDatabaseQueryStaticAction.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lmisk/hibernate/actions/HibernateDatabaseQueryStaticAction$Companion;", "", "()V", "HIBERNATE_QUERY_STATIC_WEBACTION_PATH", "", "logger", "Lmu/KLogger;", "misk-hibernate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006H\u00c6\u0003J3\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lmisk/hibernate/actions/HibernateDatabaseQueryStaticAction$Request;", "", "entityClass", "", "queryClass", "query", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getEntityClass", "()Ljava/lang/String;", "getQuery", "()Ljava/util/Map;", "getQueryClass", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "misk-hibernate"})
    public static final class Request {
        @NotNull
        private final String entityClass;
        @NotNull
        private final String queryClass;
        @NotNull
        private final Map<String, Object> query;

        public Request(@NotNull String entityClass, @NotNull String queryClass, @NotNull Map<String, ? extends Object> query) {
            Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
            Intrinsics.checkNotNullParameter((Object)queryClass, (String)"queryClass");
            Intrinsics.checkNotNullParameter(query, (String)"query");
            this.entityClass = entityClass;
            this.queryClass = queryClass;
            this.query = query;
        }

        @NotNull
        public final String getEntityClass() {
            return this.entityClass;
        }

        @NotNull
        public final String getQueryClass() {
            return this.queryClass;
        }

        @NotNull
        public final Map<String, Object> getQuery() {
            return this.query;
        }

        @NotNull
        public final String component1() {
            return this.entityClass;
        }

        @NotNull
        public final String component2() {
            return this.queryClass;
        }

        @NotNull
        public final Map<String, Object> component3() {
            return this.query;
        }

        @NotNull
        public final Request copy(@NotNull String entityClass, @NotNull String queryClass, @NotNull Map<String, ? extends Object> query) {
            Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
            Intrinsics.checkNotNullParameter((Object)queryClass, (String)"queryClass");
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return new Request(entityClass, queryClass, query);
        }

        public static /* synthetic */ Request copy$default(Request request, String string, String string2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = request.entityClass;
            }
            if ((n & 2) != 0) {
                string2 = request.queryClass;
            }
            if ((n & 4) != 0) {
                map = request.query;
            }
            return request.copy(string, string2, map);
        }

        @NotNull
        public String toString() {
            return "Request(entityClass=" + this.entityClass + ", queryClass=" + this.queryClass + ", query=" + this.query + ")";
        }

        public int hashCode() {
            int result = this.entityClass.hashCode();
            result = result * 31 + this.queryClass.hashCode();
            result = result * 31 + ((Object)this.query).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Request)) {
                return false;
            }
            Request request = (Request)other;
            if (!Intrinsics.areEqual((Object)this.entityClass, (Object)request.entityClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.queryClass, (Object)request.queryClass)) {
                return false;
            }
            return Intrinsics.areEqual(this.query, request.query);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u0019\u0010\b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lmisk/hibernate/actions/HibernateDatabaseQueryStaticAction$Response;", "", "results", "", "(Ljava/util/List;)V", "getResults", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "misk-hibernate"})
    public static final class Response {
        @NotNull
        private final List<Object> results;

        public Response(@NotNull List<? extends Object> results) {
            Intrinsics.checkNotNullParameter(results, (String)"results");
            this.results = results;
        }

        @NotNull
        public final List<Object> getResults() {
            return this.results;
        }

        @NotNull
        public final List<Object> component1() {
            return this.results;
        }

        @NotNull
        public final Response copy(@NotNull List<? extends Object> results) {
            Intrinsics.checkNotNullParameter(results, (String)"results");
            return new Response(results);
        }

        public static /* synthetic */ Response copy$default(Response response, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = response.results;
            }
            return response.copy(list);
        }

        @NotNull
        public String toString() {
            return "Response(results=" + this.results + ")";
        }

        public int hashCode() {
            return ((Object)this.results).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Response)) {
                return false;
            }
            Response response = (Response)other;
            return Intrinsics.areEqual(this.results, response.results);
        }
    }
}

