/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate.migrate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import misk.hibernate.DbChild;
import misk.hibernate.DbRoot;
import misk.hibernate.DbTimestampedEntity;
import misk.hibernate.Id;
import misk.hibernate.PersistenceMetadata;
import misk.hibernate.Session;
import misk.hibernate.Transacter;
import misk.hibernate.TransacterKt;
import misk.hibernate.migrate.BulkShardMigrator;
import misk.jdbc.Check;
import misk.jdbc.DataSourceType;
import misk.vitess.Keyspace;
import misk.vitess.Shard;
import mu.KLogger;
import mu.KotlinLogging;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\t\u0018\u0000 S*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005:\u0007STUVWXYB3\b\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J(\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020(H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u000fH\u0002J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b00H\u0002J\u001e\u00101\u001a\u00020,2\u0006\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0002J\u0012\u00107\u001a\u00020,2\b\b\u0002\u00108\u001a\u00020\u0011H\u0007J\u0010\u00109\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u0011H\u0002J\b\u0010:\u001a\u00020,H\u0002J\u0016\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0002J\u001d\u0010>\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010?\u001a\u00020\u001bH\u0086\u0002J@\u0010'\u001a\u00020,2\u0006\u0010@\u001a\u00020A2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001d0\u001a2\f\u0010C\u001a\b\u0012\u0004\u0012\u0002060D2\u0006\u00108\u001a\u00020\u0011H\u0002J\u0010\u0010E\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\b\u0010F\u001a\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0014\u001a\u00020\u0011J\"\u0010G\u001a\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001d0\u001a2\u0006\u00102\u001a\u000203H\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010\u00172\u0006\u0010&\u001a\u00020\u001bH\u0002J\u001a\u0010I\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010?\u001a\u00020\u001bJ\u001a\u0010J\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010&\u001a\u00020\u001bJ1\u0010K\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010?\u001a\u00020\u001b2\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050MH\u0086\u0002J%\u0010K\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u0005H\u0086\u0002J \u0010N\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"J\b\u0010O\u001a\u00020\u001bH\u0002J \u0010P\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"J3\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010$\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050Q\"\u00020\u0005\u00a2\u0006\u0002\u0010RJ&\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010$\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lmisk/hibernate/migrate/BulkShardMigrator;", "R", "Lmisk/hibernate/DbRoot;", "C", "Lmisk/hibernate/DbChild;", "", "rootClass", "Lkotlin/reflect/KClass;", "sessionFactory", "Lorg/hibernate/SessionFactory;", "transacter", "Lmisk/hibernate/Transacter;", "childClass", "(Lkotlin/reflect/KClass;Lorg/hibernate/SessionFactory;Lmisk/hibernate/Transacter;Lkotlin/reflect/KClass;)V", "batchSize", "", "batched", "", "keyspace", "Lmisk/vitess/Keyspace;", "latestBatchOnly", "mutations", "Ljava/util/ArrayList;", "Lmisk/hibernate/migrate/BulkShardMigrator$Mutation;", "Lkotlin/collections/ArrayList;", "mutationsByColumnName", "", "", "parameters", "", "persistenceMetadata", "Lmisk/hibernate/PersistenceMetadata;", "rootColumnName", "sourceRoot", "Lmisk/hibernate/Id;", "targetRoot", "where", "bindInsert", "columnName", "insert", "Ljava/sql/PreparedStatement;", "parameterIndex", "value", "bindWhereClause", "", "select", "startIndex", "columnNames", "Lcom/google/common/collect/ImmutableSet;", "delete", "session", "Lmisk/hibernate/Session;", "idsToDelete", "", "", "execute", "insertIgnore", "executeBatch", "executeUnshardedMigration", "getShard", "Lmisk/vitess/Shard;", "id", "inc", "column", "connection", "Ljava/sql/Connection;", "resultSet", "existingIds", "", "insertValueSql", "isShardLocal", "loadSourceRecords", "mutationNamed", "now", "rootColumn", "set", "valueMapper", "Ljava/util/function/Function;", "source", "tableName", "target", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lmisk/hibernate/migrate/BulkShardMigrator;", "Companion", "Factory", "IncMutation", "Mutation", "NowMutation", "SetMappingMutation", "SetMutation", "misk-hibernate"})
@SourceDebugExtension(value={"SMAP\nBulkShardMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BulkShardMigrator.kt\nmisk/hibernate/migrate/BulkShardMigrator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,561:1\n1#2:562\n1549#3:563\n1620#3,3:564\n12#4:567\n*S KotlinDebug\n*F\n+ 1 BulkShardMigrator.kt\nmisk/hibernate/migrate/BulkShardMigrator\n*L\n414#1:563\n414#1:564,3\n558#1:567\n*E\n"})
public final class BulkShardMigrator<R extends DbRoot<R>, C extends DbChild<R, C>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<R> rootClass;
    @NotNull
    private final Transacter transacter;
    @NotNull
    private final KClass<C> childClass;
    @NotNull
    private final PersistenceMetadata persistenceMetadata;
    @NotNull
    private final Keyspace keyspace;
    @NotNull
    private final ArrayList<Mutation> mutations;
    @Nullable
    private String where;
    @Nullable
    private List<?> parameters;
    @NotNull
    private String rootColumnName;
    @Nullable
    private Id<R> sourceRoot;
    @Nullable
    private Id<R> targetRoot;
    private boolean batched;
    private boolean latestBatchOnly;
    private int batchSize;
    @Nullable
    private Map<String, ? extends Mutation> mutationsByColumnName;
    @NotNull
    private static final KLogger logger;

    private BulkShardMigrator(KClass<R> rootClass, SessionFactory sessionFactory, Transacter transacter, KClass<C> childClass) {
        this.rootClass = rootClass;
        this.transacter = transacter;
        this.childClass = childClass;
        this.mutations = new ArrayList();
        this.rootColumnName = "customer_id";
        this.batched = true;
        this.batchSize = 100;
        if (KClasses.isSubclassOf(this.childClass, (KClass)Reflection.getOrCreateKotlinClass(DbTimestampedEntity.class))) {
            this.now("updated_at");
        }
        this.persistenceMetadata = new PersistenceMetadata(sessionFactory);
        misk.hibernate.annotation.Keyspace keyspace = JvmClassMappingKt.getJavaClass(this.rootClass).getAnnotation(misk.hibernate.annotation.Keyspace.class);
        if (keyspace == null) {
            throw new NullPointerException(this.rootClass + " requires the Keyspace annotation to use BulkShardMigrator. If using with MySQL annotate with @Keyspace(\"keyspace\")");
        }
        misk.hibernate.annotation.Keyspace annotation = keyspace;
        this.keyspace = new Keyspace(annotation.value());
    }

    @NotNull
    public final BulkShardMigrator<R, C> rootColumn(@NotNull String columnName) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        this.rootColumnName = columnName;
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> source(@NotNull Id<R> sourceRoot) {
        Intrinsics.checkNotNullParameter(sourceRoot, (String)"sourceRoot");
        this.sourceRoot = sourceRoot;
        if (this.where == null) {
            Object[] objectArray = new Object[]{sourceRoot.getId()};
            this.where(this.rootColumnName + " = ?", objectArray);
        }
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> target(@NotNull Id<R> targetRoot) {
        Intrinsics.checkNotNullParameter(targetRoot, (String)"targetRoot");
        this.targetRoot = targetRoot;
        this.set(this.rootColumnName, targetRoot.getId());
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> set(@NotNull String column, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mutations.add(new SetMutation(column, value));
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> set(@NotNull String column, @NotNull Function<Object, Object> valueMapper) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter(valueMapper, (String)"valueMapper");
        this.mutations.add(new SetMappingMutation(column, valueMapper));
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> now(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        this.mutations.add(new NowMutation(column));
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> inc(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        this.mutations.add(new IncMutation(column));
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> where(@NotNull String where, Object ... parameters) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        ImmutableList immutableList = ImmutableList.copyOf((Object[])parameters);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(parameters)");
        return this.where(where, (List)immutableList);
    }

    @NotNull
    public final BulkShardMigrator<R, C> where(@NotNull String where, @NotNull List<?> parameters) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.where = where;
        this.parameters = parameters;
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> batched() {
        this.batched = true;
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> latestBatchOnly(boolean latestBatchOnly) {
        if (!this.batched) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.latestBatchOnly = latestBatchOnly;
        return this;
    }

    @NotNull
    public final BulkShardMigrator<R, C> batchSize(int batchSize) {
        if (!this.batched) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.batchSize = batchSize;
        return this;
    }

    @JvmOverloads
    public final void execute(boolean insertIgnore) {
        if (this.targetRoot == null) {
            boolean $i$a$-checkNotNull-BulkShardMigrator$execute$32 = false;
            String $i$a$-checkNotNull-BulkShardMigrator$execute$32 = "You have to specify entity root target";
            throw new IllegalStateException($i$a$-checkNotNull-BulkShardMigrator$execute$32.toString());
        }
        if (this.sourceRoot == null) {
            boolean bl = false;
            String string = "You have to specify entity root source";
            throw new IllegalStateException(string.toString());
        }
        if (this.transacter.config().getType() == DataSourceType.TIDB) {
            this.executeUnshardedMigration();
            return;
        }
        int count2 = 0;
        do {
            count2 = this.executeBatch(insertIgnore);
        } while (this.batched && !this.latestBatchOnly && count2 == this.batchSize);
    }

    public static /* synthetic */ void execute$default(BulkShardMigrator bulkShardMigrator, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        bulkShardMigrator.execute(bl);
    }

    private final void executeUnshardedMigration() {
        if (!(!this.transacter.getInTransaction())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String tableName = this.tableName();
        String setColumns2 = this.mutations.stream().map(arg_0 -> BulkShardMigrator.executeUnshardedMigration$lambda$2(executeUnshardedMigration.setColumns.1.INSTANCE, arg_0)).collect(Collectors.joining(","));
        logger.info("Bulk migrating in " + this.transacter.config().getType() + " entities for table " + tableName);
        this.transacter.transaction((Function1)new Function1<Session, Unit>(this, setColumns2){
            final /* synthetic */ BulkShardMigrator<R, C> this$0;
            final /* synthetic */ String $setColumns;
            {
                this.this$0 = $receiver;
                this.$setColumns = $setColumns;
                super(1);
            }

            public final void invoke(@NotNull Session session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                session.getHibernateSession().doWork(arg_0 -> executeUnshardedMigration.1.invoke$lambda$3(this.this$0, this.$setColumns, arg_0));
            }

            /*
             * WARNING - void declaration
             */
            private static final void invoke$lambda$3(BulkShardMigrator this$0, String $setColumns, Connection connection) {
                void $this$forEachIndexed$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                BulkShardMigrator $this$invoke_u24lambda_u243_u24lambda_u242 = this$0;
                boolean bl = false;
                String update = StringsKt.trimIndent((String)("\n          UPDATE " + BulkShardMigrator.access$tableName($this$invoke_u24lambda_u243_u24lambda_u242) + "\n          SET " + $setColumns + "\n          WHERE " + BulkShardMigrator.access$getWhere$p($this$invoke_u24lambda_u243_u24lambda_u242) + "\n          "));
                PreparedStatement updateStatement = connection.prepareStatement(update);
                int setParametersCount = 0;
                Iterable iterable = BulkShardMigrator.access$getMutations$p($this$invoke_u24lambda_u243_u24lambda_u242);
                boolean $i$f$filter = false;
                void var10_10 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Mutation it = (Mutation)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.isParameterized$misk_hibernate()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void mutation;
                    int n;
                    Object element$iv$iv;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    element$iv$iv = (Mutation)item$iv;
                    int index = n;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)updateStatement, (String)"updateStatement");
                    mutation.bindUpdate(updateStatement, index + 1);
                    ++setParametersCount;
                }
                Intrinsics.checkNotNullExpressionValue((Object)updateStatement, (String)"updateStatement");
                BulkShardMigrator.access$bindWhereClause($this$invoke_u24lambda_u243_u24lambda_u242, updateStatement, setParametersCount);
                updateStatement.executeUpdate();
            }
        });
    }

    private final int executeBatch(boolean insertIgnore) {
        if (!(!this.transacter.getInTransaction())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String tableName = this.tableName();
        logger.info((Function0)new Function0<Object>(tableName, this){
            final /* synthetic */ String $tableName;
            final /* synthetic */ BulkShardMigrator<R, C> this$0;
            {
                this.$tableName = $tableName;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Starting BulkShardMigrator-" + this.$tableName + "-" + BulkShardMigrator.access$getSourceRoot$p(this.this$0) + "-" + BulkShardMigrator.access$getTargetRoot$p(this.this$0) + " batch";
            }
        });
        if (this.isShardLocal()) {
            return ((Number)this.transacter.transaction((Function1)new Function1<Session, Integer>(this, tableName, insertIgnore){
                final /* synthetic */ BulkShardMigrator<R, C> this$0;
                final /* synthetic */ String $tableName;
                final /* synthetic */ boolean $insertIgnore;
                {
                    this.this$0 = $receiver;
                    this.$tableName = $tableName;
                    this.$insertIgnore = $insertIgnore;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull Session session) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Check[] checkArray = new Check[]{Check.COWRITE};
                    return (Integer)session.withoutChecks(checkArray, (Function0)new Function0<Integer>(this.this$0, session, this.$tableName, this.$insertIgnore){
                        final /* synthetic */ BulkShardMigrator<R, C> this$0;
                        final /* synthetic */ Session $session;
                        final /* synthetic */ String $tableName;
                        final /* synthetic */ boolean $insertIgnore;
                        {
                            this.this$0 = $receiver;
                            this.$session = $session;
                            this.$tableName = $tableName;
                            this.$insertIgnore = $insertIgnore;
                            super(0);
                        }

                        @NotNull
                        public final Integer invoke() {
                            int n;
                            Map sourceRecords = BulkShardMigrator.access$loadSourceRecords(this.this$0, this.$session);
                            if (sourceRecords.isEmpty()) {
                                n = 0;
                            } else {
                                BulkShardMigrator.access$getLogger$cp().info("Bulk migrating (same shard) " + sourceRecords.size() + " entities for table " + this.$tableName);
                                BulkShardMigrator.access$delete(this.this$0, this.$session, sourceRecords.keySet());
                                this.$session.getHibernateSession().doWork(arg_0 -> executeBatch.1.invoke$lambda$0(this.this$0, sourceRecords, this.$insertIgnore, arg_0));
                                n = sourceRecords.size();
                            }
                            return n;
                        }

                        private static final void invoke$lambda$0(BulkShardMigrator this$0, Map $sourceRecords, boolean $insertIgnore, Connection connection) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNullParameter((Object)$sourceRecords, (String)"$sourceRecords");
                            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
                            BulkShardMigrator.access$insert(this$0, connection, $sourceRecords, SetsKt.emptySet(), $insertIgnore);
                        }
                    });
                }
            })).intValue();
        }
        Set idsToDelete2 = (Set)this.transacter.transaction((Function1)new Function1<Session, Set<? extends Long>>(this, tableName, insertIgnore){
            final /* synthetic */ BulkShardMigrator<R, C> this$0;
            final /* synthetic */ String $tableName;
            final /* synthetic */ boolean $insertIgnore;
            {
                this.this$0 = $receiver;
                this.$tableName = $tableName;
                this.$insertIgnore = $insertIgnore;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<Long> invoke(@NotNull Session session) {
                Set<K> set;
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Map sourceRecords = BulkShardMigrator.access$loadSourceRecords(this.this$0, session);
                if (sourceRecords.isEmpty()) {
                    set = SetsKt.emptySet();
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    NativeQuery nativeQuery = session.getHibernateSession().createNativeQuery("SELECT id FROM " + this.$tableName + " WHERE " + BulkShardMigrator.access$getRootColumnName$p(this.this$0) + " = :target AND id IN (:ids)");
                    Id id = BulkShardMigrator.access$getTargetRoot$p(this.this$0);
                    Intrinsics.checkNotNull((Object)id);
                    List list = nativeQuery.setParameter("target", (Object)id.getId()).setParameterList("ids", (Collection)sourceRecords.keySet()).getResultList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"session.hibernateSession\u2026ys)\n          .resultList");
                    Iterable iterable = list;
                    boolean $i$f$map = false;
                    void var6_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        T item$iv$iv;
                        T t = item$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type misk.hibernate.Id<*>");
                        collection.add(((Id)it).getId());
                    }
                    Set existingIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    BulkShardMigrator.access$getLogger$cp().info("Bulk migrating (distinct shard) " + sourceRecords.size() + " entities for table " + this.$tableName);
                    session.getHibernateSession().doWork(arg_0 -> executeBatch.idsToDelete.1.invoke$lambda$1(this.this$0, sourceRecords, existingIds, this.$insertIgnore, arg_0));
                    set = sourceRecords.keySet();
                }
                return set;
            }

            private static final void invoke$lambda$1(BulkShardMigrator this$0, Map $sourceRecords, Set $existingIds, boolean $insertIgnore, Connection connection) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$sourceRecords, (String)"$sourceRecords");
                Intrinsics.checkNotNullParameter((Object)$existingIds, (String)"$existingIds");
                Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
                BulkShardMigrator.access$insert(this$0, connection, $sourceRecords, $existingIds, $insertIgnore);
            }
        });
        if (!idsToDelete2.isEmpty()) {
            this.transacter.transaction((Function1)new Function1<Session, Unit>(this, (Set<Long>)idsToDelete2){
                final /* synthetic */ BulkShardMigrator<R, C> this$0;
                final /* synthetic */ Set<Long> $idsToDelete;
                {
                    this.this$0 = $receiver;
                    this.$idsToDelete = $idsToDelete;
                    super(1);
                }

                public final void invoke(@NotNull Session session) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    BulkShardMigrator.access$delete(this.this$0, session, this.$idsToDelete);
                }
            });
        }
        return idsToDelete2.size();
    }

    private final Map<Long, List<Object>> loadSourceRecords(Session session) {
        HashMap map = new HashMap();
        ImmutableList columnNames = this.columnNames().asList();
        session.getHibernateSession().doWork(arg_0 -> BulkShardMigrator.loadSourceRecords$lambda$4(this, columnNames, map, arg_0));
        return map;
    }

    private final boolean isShardLocal() {
        Id<R> id = this.sourceRoot;
        Intrinsics.checkNotNull(id);
        Shard sourceShard = this.getShard(id);
        Id<R> id2 = this.targetRoot;
        Intrinsics.checkNotNull(id2);
        Shard targetShard = this.getShard(id2);
        return Intrinsics.areEqual((Object)sourceShard, (Object)targetShard);
    }

    private final Shard getShard(Id<R> id) {
        Object v0;
        Set<Shard> shards2;
        block2: {
            shards2 = TransacterKt.shards(this.transacter);
            Iterable iterable = shards2;
            for (Object t : iterable) {
                Shard it = (Shard)t;
                boolean bl = false;
                if (!((Intrinsics.areEqual((Object)it.getKeyspace(), (Object)this.keyspace) || Intrinsics.areEqual((Object)it.getKeyspace(), (Object)Shard.Companion.getSINGLE_KEYSPACE())) && it.contains(id.shardKey()))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Shard shard = v0;
        if (shard == null) {
            throw new NoSuchElementException("No shard found for [class=" + this.rootClass + "][id=" + id + "][keyspace=" + this.keyspace + "][shardKey=" + id.shardKey() + "] out of [shards=" + shards2 + "]");
        }
        return shard;
    }

    private final String tableName() {
        return this.persistenceMetadata.getTableName(this.childClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void insert(Connection connection, Map<Long, ? extends List<? extends Object>> resultSet, Set<Long> existingIds, boolean insertIgnore) {
        ImmutableList columnNames = this.columnNames().asList();
        String columnValues2 = this.columnNames().stream().map(arg_0 -> BulkShardMigrator.insert$lambda$6((Function1)new Function1<String, String>(this){
            final /* synthetic */ BulkShardMigrator<R, C> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String invoke(String it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return BulkShardMigrator.access$insertValueSql(this.this$0, it);
            }
        }, arg_0)).collect(Collectors.joining(", "));
        String string = insertIgnore ? "IGNORE " : "";
        String string2 = this.tableName();
        Intrinsics.checkNotNullExpressionValue((Object)columnNames, (String)"columnNames");
        String statement = StringsKt.trimIndent((String)("\n      INSERT " + string + "\n      INTO " + string2 + " (" + CollectionsKt.joinToString$default((Iterable)((Iterable)columnNames), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")\n      VALUES (" + columnValues2 + ")\n    "));
        AutoCloseable autoCloseable = connection.prepareStatement(statement);
        Throwable throwable = null;
        try {
            PreparedStatement insert2 = (PreparedStatement)autoCloseable;
            boolean bl = false;
            int batches = 0;
            for (Map.Entry<Long, ? extends List<? extends Object>> entry : resultSet.entrySet()) {
                long key = ((Number)entry.getKey()).longValue();
                List<? extends Object> resultColumnValues = entry.getValue();
                if (existingIds.contains(key)) continue;
                int parameterIndex = 1;
                int n = columnNames.size();
                for (int i = 0; i < n; ++i) {
                    String columnName = (String)columnNames.get(i);
                    Object value = resultColumnValues.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)columnName, (String)"columnName");
                    Intrinsics.checkNotNullExpressionValue((Object)insert2, (String)"insert");
                    parameterIndex += this.bindInsert(columnName, insert2, parameterIndex, value);
                }
                insert2.addBatch();
                ++batches;
            }
            if (batches > 0) {
                insert2.executeBatch();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final ImmutableSet<String> columnNames() {
        return this.persistenceMetadata.getColumnNames(this.childClass);
    }

    private final void delete(Session session, Collection<Long> idsToDelete2) {
        String tableName = this.tableName();
        NativeQuery nativeQuery = session.getHibernateSession().createNativeQuery(StringsKt.trimIndent((String)("\n          DELETE FROM " + tableName + "\n          WHERE " + this.rootColumnName + " = :source\n          AND id IN (:ids)\n      ")));
        Id<R> id = this.sourceRoot;
        Intrinsics.checkNotNull(id);
        int numRecords = nativeQuery.setParameter("source", (Object)id.getId()).setParameterList("ids", idsToDelete2).executeUpdate();
        if (numRecords != idsToDelete2.size()) {
            Object[] objectArray = new Object[]{tableName, numRecords, idsToDelete2.size()};
            logger.info("Deleted less records than expected from %s (%s < %s) after copying", objectArray);
        }
    }

    private final int bindInsert(String columnName, PreparedStatement insert2, int parameterIndex, Object value) throws SQLException {
        Mutation mutation = this.mutationNamed(columnName);
        if (mutation != null) {
            return mutation.bindInsert(insert2, parameterIndex, value);
        }
        try {
            if (value instanceof byte[]) {
                insert2.setBytes(parameterIndex, (byte[])value);
            } else {
                insert2.setObject(parameterIndex, value);
            }
        }
        catch (SQLException e) {
            String string = "Can't infer type of column %s for value %s";
            Object[] objectArray = new Object[]{columnName, value};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new RuntimeException(string2);
        }
        return 1;
    }

    private final String insertValueSql(String columnName) {
        Mutation mutation = this.mutationNamed(columnName);
        Object object = mutation;
        if (object == null || (object = ((Mutation)object).insertSql()) == null) {
            object = "?";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Mutation mutationNamed(String columnName) {
        if (this.mutationsByColumnName == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.mutations;
            BulkShardMigrator bulkShardMigrator = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Mutation mutation = (Mutation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it.columnName$misk_hibernate(), (Object)it));
            }
            bulkShardMigrator.mutationsByColumnName = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        Map<String, ? extends Mutation> map = this.mutationsByColumnName;
        Intrinsics.checkNotNull(map);
        return map.get(columnName);
    }

    private final void bindWhereClause(PreparedStatement select2) throws SQLException {
        this.bindWhereClause(select2, 0);
    }

    private final void bindWhereClause(PreparedStatement select2, int startIndex) throws SQLException {
        List<?> list = this.parameters;
        Intrinsics.checkNotNull(list);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            List<?> list2 = this.parameters;
            Intrinsics.checkNotNull(list2);
            select2.setObject(startIndex + i + 1, list2.get(i));
        }
    }

    @JvmOverloads
    public final void execute() {
        BulkShardMigrator.execute$default(this, false, 1, null);
    }

    private static final String executeUnshardedMigration$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadSourceRecords$lambda$4(BulkShardMigrator this$0, ImmutableList $columnNames, HashMap $map, Connection connection) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$map, (String)"$map");
        String limit = this$0.batched ? "ORDER BY id DESC LIMIT " + this$0.batchSize : "";
        Intrinsics.checkNotNullExpressionValue((Object)$columnNames, (String)"columnNames");
        AutoCloseable autoCloseable = connection.prepareStatement("SELECT " + CollectionsKt.joinToString$default((Iterable)((Iterable)$columnNames), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " FROM " + this$0.tableName() + " WHERE " + this$0.where + " " + limit);
        Throwable throwable = null;
        try {
            PreparedStatement select2 = (PreparedStatement)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)select2, (String)"select");
            this$0.bindWhereClause(select2);
            ResultSet resultSet = select2.executeQuery();
            while (resultSet.next()) {
                long id = resultSet.getLong("id");
                ArrayList<Object> values = new ArrayList<Object>();
                int n = $columnNames.size();
                for (int i = 0; i < n; ++i) {
                    values.add(resultSet.getObject(i + 1));
                }
                Long l = id;
                ((Map)$map).put(l, values);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final String insert$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$tableName(BulkShardMigrator $this) {
        return $this.tableName();
    }

    public static final /* synthetic */ String access$getWhere$p(BulkShardMigrator $this) {
        return $this.where;
    }

    public static final /* synthetic */ ArrayList access$getMutations$p(BulkShardMigrator $this) {
        return $this.mutations;
    }

    public static final /* synthetic */ void access$bindWhereClause(BulkShardMigrator $this, PreparedStatement select2, int startIndex) {
        $this.bindWhereClause(select2, startIndex);
    }

    public static final /* synthetic */ Id access$getSourceRoot$p(BulkShardMigrator $this) {
        return $this.sourceRoot;
    }

    public static final /* synthetic */ Id access$getTargetRoot$p(BulkShardMigrator $this) {
        return $this.targetRoot;
    }

    public static final /* synthetic */ Map access$loadSourceRecords(BulkShardMigrator $this, Session session) {
        return $this.loadSourceRecords(session);
    }

    public static final /* synthetic */ KLogger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$delete(BulkShardMigrator $this, Session session, Collection idsToDelete2) {
        $this.delete(session, idsToDelete2);
    }

    public static final /* synthetic */ void access$insert(BulkShardMigrator $this, Connection connection, Map resultSet, Set existingIds, boolean insertIgnore) {
        $this.insert(connection, resultSet, existingIds, insertIgnore);
    }

    public static final /* synthetic */ String access$getRootColumnName$p(BulkShardMigrator $this) {
        return $this.rootColumnName;
    }

    public static final /* synthetic */ String access$insertValueSql(BulkShardMigrator $this, String columnName) {
        return $this.insertValueSql(columnName);
    }

    public /* synthetic */ BulkShardMigrator(KClass rootClass, SessionFactory sessionFactory, Transacter transacter, KClass childClass, DefaultConstructorMarker $constructor_marker) {
        this(rootClass, sessionFactory, transacter, childClass);
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(BulkShardMigrator.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmisk/hibernate/migrate/BulkShardMigrator$Companion;", "", "()V", "logger", "Lmu/KLogger;", "misk-hibernate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Singleton
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002Jd\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u000e\b\u0002\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0007\"\u0014\b\u0003\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000e\u00a8\u0006\u0010"}, d2={"Lmisk/hibernate/migrate/BulkShardMigrator$Factory;", "", "()V", "create", "Lmisk/hibernate/migrate/BulkShardMigrator;", "R", "C", "Lmisk/hibernate/DbRoot;", "Lmisk/hibernate/DbChild;", "transacter", "Lmisk/hibernate/Transacter;", "sessionFactory", "Lorg/hibernate/SessionFactory;", "rootClass", "Lkotlin/reflect/KClass;", "childClass", "misk-hibernate"})
    public static final class Factory {
        @Inject
        public Factory() {
        }

        @NotNull
        public final <R extends DbRoot<R>, C extends DbChild<R, C>> BulkShardMigrator<R, C> create(@NotNull Transacter transacter, @NotNull SessionFactory sessionFactory, @NotNull KClass<R> rootClass, @NotNull KClass<C> childClass) {
            Intrinsics.checkNotNullParameter((Object)transacter, (String)"transacter");
            Intrinsics.checkNotNullParameter((Object)sessionFactory, (String)"sessionFactory");
            Intrinsics.checkNotNullParameter(rootClass, (String)"rootClass");
            Intrinsics.checkNotNullParameter(childClass, (String)"childClass");
            return new BulkShardMigrator(rootClass, sessionFactory, transacter, childClass, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\r\u0010\u000e\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmisk/hibernate/migrate/BulkShardMigrator$IncMutation;", "Lmisk/hibernate/migrate/BulkShardMigrator$Mutation;", "column", "", "(Ljava/lang/String;)V", "bindInsert", "", "insert", "Ljava/sql/PreparedStatement;", "parameterIndex", "value", "", "bindUpdate", "update", "columnName", "columnName$misk_hibernate", "updateSql", "misk-hibernate"})
    public static final class IncMutation
    extends Mutation {
        @NotNull
        private final String column;

        public IncMutation(@NotNull String column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            this.column = column;
        }

        @Override
        @NotNull
        public String columnName$misk_hibernate() {
            return this.column;
        }

        @Override
        public int bindInsert(@NotNull PreparedStatement insert2, int parameterIndex, @NotNull Object value) throws SQLException {
            Intrinsics.checkNotNullParameter((Object)insert2, (String)"insert");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            insert2.setObject(parameterIndex, ((Number)value).longValue() + 1L);
            return 1;
        }

        @Override
        public int bindUpdate(@NotNull PreparedStatement update, int parameterIndex) {
            Intrinsics.checkNotNullParameter((Object)update, (String)"update");
            return 0;
        }

        @Override
        @NotNull
        public String updateSql() {
            return this.column + " = " + this.column + " + 1";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0001H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H&J\r\u0010\u000b\u001a\u00020\fH \u00a2\u0006\u0002\b\rJ\b\u0010\u000e\u001a\u00020\fH\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\fH\u0016\u00a8\u0006\u0013"}, d2={"Lmisk/hibernate/migrate/BulkShardMigrator$Mutation;", "", "()V", "bindInsert", "", "insert", "Ljava/sql/PreparedStatement;", "parameterIndex", "value", "bindUpdate", "update", "columnName", "", "columnName$misk_hibernate", "insertSql", "isParameterized", "", "isParameterized$misk_hibernate", "updateSql", "misk-hibernate"})
    public static abstract class Mutation {
        @NotNull
        public abstract String columnName$misk_hibernate();

        @NotNull
        public String insertSql() {
            return "?";
        }

        public int bindInsert(@NotNull PreparedStatement insert2, int parameterIndex, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)insert2, (String)"insert");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            insert2.setObject(parameterIndex, value);
            return 1;
        }

        public abstract int bindUpdate(@NotNull PreparedStatement var1, int var2);

        @NotNull
        public String updateSql() {
            return this.columnName$misk_hibernate() + " = ?";
        }

        public final boolean isParameterized$misk_hibernate() {
            return StringsKt.contains$default((CharSequence)this.updateSql(), (char)'?', (boolean)false, (int)2, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\r\u0010\u000e\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmisk/hibernate/migrate/BulkShardMigrator$NowMutation;", "Lmisk/hibernate/migrate/BulkShardMigrator$Mutation;", "column", "", "(Ljava/lang/String;)V", "bindInsert", "", "insert", "Ljava/sql/PreparedStatement;", "parameterIndex", "value", "", "bindUpdate", "update", "columnName", "columnName$misk_hibernate", "insertSql", "updateSql", "misk-hibernate"})
    public static final class NowMutation
    extends Mutation {
        @NotNull
        private final String column;

        public NowMutation(@NotNull String column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            this.column = column;
        }

        @Override
        @NotNull
        public String columnName$misk_hibernate() {
            return this.column;
        }

        @Override
        public int bindInsert(@NotNull PreparedStatement insert2, int parameterIndex, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)insert2, (String)"insert");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return 0;
        }

        @Override
        public int bindUpdate(@NotNull PreparedStatement update, int parameterIndex) {
            Intrinsics.checkNotNullParameter((Object)update, (String)"update");
            return 0;
        }

        @Override
        @NotNull
        public String insertSql() {
            return "now()";
        }

        @Override
        @NotNull
        public String updateSql() {
            return this.column + " = now()";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\r\u0010\u0010\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmisk/hibernate/migrate/BulkShardMigrator$SetMappingMutation;", "Lmisk/hibernate/migrate/BulkShardMigrator$Mutation;", "column", "", "valueMapper", "Ljava/util/function/Function;", "", "(Ljava/lang/String;Ljava/util/function/Function;)V", "bindInsert", "", "insert", "Ljava/sql/PreparedStatement;", "parameterIndex", "value", "bindUpdate", "update", "columnName", "columnName$misk_hibernate", "misk-hibernate"})
    public static final class SetMappingMutation
    extends Mutation {
        @NotNull
        private final String column;
        @NotNull
        private final Function<Object, Object> valueMapper;

        public SetMappingMutation(@NotNull String column, @NotNull Function<Object, Object> valueMapper) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            Intrinsics.checkNotNullParameter(valueMapper, (String)"valueMapper");
            this.column = column;
            this.valueMapper = valueMapper;
        }

        @Override
        @NotNull
        public String columnName$misk_hibernate() {
            return this.column;
        }

        @Override
        public int bindInsert(@NotNull PreparedStatement insert2, int parameterIndex, @NotNull Object value) throws SQLException {
            Intrinsics.checkNotNullParameter((Object)insert2, (String)"insert");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            insert2.setObject(parameterIndex, this.valueMapper.apply(value));
            return 1;
        }

        @Override
        public int bindUpdate(@NotNull PreparedStatement update, int parameterIndex) {
            Intrinsics.checkNotNullParameter((Object)update, (String)"update");
            throw new UnsupportedOperationException("Cannot apply updates using SetMappingMutation");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\r\u0010\u000e\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmisk/hibernate/migrate/BulkShardMigrator$SetMutation;", "Lmisk/hibernate/migrate/BulkShardMigrator$Mutation;", "column", "", "value", "", "(Ljava/lang/String;Ljava/lang/Object;)V", "bindInsert", "", "insert", "Ljava/sql/PreparedStatement;", "parameterIndex", "bindUpdate", "update", "columnName", "columnName$misk_hibernate", "misk-hibernate"})
    public static final class SetMutation
    extends Mutation {
        @NotNull
        private final String column;
        @NotNull
        private final Object value;

        public SetMutation(@NotNull String column, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.column = column;
            this.value = value;
        }

        @Override
        @NotNull
        public String columnName$misk_hibernate() {
            return this.column;
        }

        @Override
        public int bindInsert(@NotNull PreparedStatement insert2, int parameterIndex, @NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)insert2, (String)"insert");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            insert2.setObject(parameterIndex, this.value);
            return 1;
        }

        @Override
        public int bindUpdate(@NotNull PreparedStatement update, int parameterIndex) {
            Intrinsics.checkNotNullParameter((Object)update, (String)"update");
            update.setObject(parameterIndex, this.value);
            return 1;
        }
    }
}

