/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.google.common.util.concurrent.Service;
import com.google.inject.Provider;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.Temporal;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import misk.healthchecks.HealthCheck;
import misk.healthchecks.HealthStatus;
import misk.hibernate.HibernateHealthCheck;
import misk.hibernate.SessionFactoryService;
import mu.KLogger;
import mu.KotlinLogging;
import org.hibernate.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB+\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmisk/hibernate/HibernateHealthCheck;", "Lmisk/healthchecks/HealthCheck;", "qualifier", "Lkotlin/reflect/KClass;", "", "sessionFactoryService", "Lcom/google/inject/Provider;", "Lmisk/hibernate/SessionFactoryService;", "clock", "Ljava/time/Clock;", "(Lkotlin/reflect/KClass;Lcom/google/inject/Provider;Ljava/time/Clock;)V", "status", "Lmisk/healthchecks/HealthStatus;", "Companion", "misk-hibernate"})
@SourceDebugExtension(value={"SMAP\nHibernateHealthCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HibernateHealthCheck.kt\nmisk/hibernate/HibernateHealthCheck\n+ 2 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,63:1\n12#2:64\n*S KotlinDebug\n*F\n+ 1 HibernateHealthCheck.kt\nmisk/hibernate/HibernateHealthCheck\n*L\n58#1:64\n*E\n"})
public final class HibernateHealthCheck
implements HealthCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final Provider<SessionFactoryService> sessionFactoryService;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final Duration CLOCK_SKEW_WARN_THRESHOLD;
    @NotNull
    private static final Duration CLOCK_SKEW_UNHEALTHY_THRESHOLD;

    public HibernateHealthCheck(@NotNull KClass<? extends Annotation> qualifier, @NotNull Provider<SessionFactoryService> sessionFactoryService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter(sessionFactoryService, (String)"sessionFactoryService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.qualifier = qualifier;
        this.sessionFactoryService = sessionFactoryService;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public HealthStatus status() {
        HealthStatus healthStatus;
        String[] stringArray;
        Object sessionFactory;
        Service.State state = ((SessionFactoryService)this.sessionFactoryService.get()).state();
        if (state != Service.State.RUNNING) {
            String[] stringArray2 = new String[]{"Hibernate: " + this.qualifier.getSimpleName() + " database service is " + state};
            return HealthStatus.Companion.unhealthy(stringArray2);
        }
        try {
            Timestamp timestamp;
            sessionFactory = ((SessionFactoryService)this.sessionFactoryService.get()).getSessionFactory();
            Closeable closeable = (Closeable)sessionFactory.openSession();
            stringArray = null;
            try {
                Session session = (Session)closeable;
                boolean bl = false;
                Object object = session.createNativeQuery("SELECT NOW()").uniqueResult();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.sql.Timestamp");
                timestamp = (Timestamp)object;
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)stringArray);
            }
            sessionFactory = timestamp.toInstant();
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Function0)status.databaseInstant.2.INSTANCE);
            String[] stringArray3 = new String[]{"Hibernate: failed to query " + this.qualifier.getSimpleName() + " database"};
            return HealthStatus.Companion.unhealthy(stringArray3);
        }
        Object databaseInstant2 = sessionFactory;
        Duration delta = Duration.between(this.clock.instant(), (Temporal)databaseInstant2).abs();
        String driftMessage = "Hibernate: host and " + this.qualifier.getSimpleName() + " database clocks have drifted " + delta.getSeconds() + "s apart";
        if (delta.compareTo(CLOCK_SKEW_UNHEALTHY_THRESHOLD) > 0) {
            stringArray = new String[]{driftMessage};
            healthStatus = HealthStatus.Companion.unhealthy(stringArray);
        } else if (delta.compareTo(CLOCK_SKEW_WARN_THRESHOLD) > 0) {
            logger.warn((Function0)new Function0<Object>(driftMessage){
                final /* synthetic */ String $driftMessage;
                {
                    this.$driftMessage = $driftMessage;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$driftMessage;
                }
            });
            stringArray = new String[]{driftMessage};
            healthStatus = HealthStatus.Companion.healthy(stringArray);
        } else {
            stringArray = new String[]{"Hibernate: " + this.qualifier.getSimpleName() + " database"};
            healthStatus = HealthStatus.Companion.healthy(stringArray);
        }
        return healthStatus;
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(HibernateHealthCheck.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        CLOCK_SKEW_WARN_THRESHOLD = duration;
        Duration duration2 = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        CLOCK_SKEW_UNHEALTHY_THRESHOLD = duration2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lmisk/hibernate/HibernateHealthCheck$Companion;", "", "()V", "CLOCK_SKEW_UNHEALTHY_THRESHOLD", "Ljava/time/Duration;", "getCLOCK_SKEW_UNHEALTHY_THRESHOLD", "()Ljava/time/Duration;", "CLOCK_SKEW_WARN_THRESHOLD", "getCLOCK_SKEW_WARN_THRESHOLD", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "misk-hibernate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        @NotNull
        public final Duration getCLOCK_SKEW_WARN_THRESHOLD() {
            return CLOCK_SKEW_WARN_THRESHOLD;
        }

        @NotNull
        public final Duration getCLOCK_SKEW_UNHEALTHY_THRESHOLD() {
            return CLOCK_SKEW_UNHEALTHY_THRESHOLD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

