/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate.actions;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import misk.MiskCaller;
import misk.exceptions.BadRequestException;
import misk.exceptions.UnauthorizedException;
import misk.hibernate.DbEntity;
import misk.hibernate.Operator;
import misk.hibernate.Query;
import misk.hibernate.ReflectionQuery;
import misk.hibernate.Session;
import misk.hibernate.Transacter;
import misk.hibernate.actions.HibernateDatabaseQueryMetadataFactory;
import misk.hibernate.actions.HibernateDatabaseQueryWebActionModule;
import misk.scope.ActionScoped;
import misk.web.Post;
import misk.web.RequestBody;
import misk.web.RequestContentType;
import misk.web.ResponseContentType;
import misk.web.actions.WebAction;
import misk.web.dashboard.AdminDashboardAccess;
import misk.web.metadata.database.DatabaseQueryMetadata;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0001\u0018\u0000 %2\u00020\u0001:\u0003%&'B5\b\u0007\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007JT\u0010\u0013\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0006\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00060\u00060\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\u0012\u0010\u001a\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J<\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u001d0\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0007H\u0002J4\u0010!\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0\"*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0\"2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0002R\u001e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lmisk/hibernate/actions/HibernateDatabaseQueryDynamicAction;", "Lmisk/web/actions/WebAction;", "callerProvider", "Lmisk/scope/ActionScoped;", "Lmisk/MiskCaller;", "databaseQueryMetadata", "", "Lmisk/web/metadata/database/DatabaseQueryMetadata;", "injector", "Lcom/google/inject/Injector;", "queryLimitsConfig", "Lmisk/hibernate/ReflectionQuery$QueryLimitsConfig;", "(Lmisk/scope/ActionScoped;Ljava/util/List;Lcom/google/inject/Injector;Lmisk/hibernate/ReflectionQuery$QueryLimitsConfig;)V", "getCallerProvider$annotations", "()V", "query", "Lmisk/hibernate/actions/HibernateDatabaseQueryDynamicAction$Response;", "request", "Lmisk/hibernate/actions/HibernateDatabaseQueryDynamicAction$Request;", "runDynamicQuery", "Lkotlin/Pair;", "", "", "session", "Lmisk/hibernate/Session;", "principal", "dbEntity", "Lkotlin/reflect/KClass;", "Lmisk/hibernate/DbEntity;", "", "transacter", "Lmisk/hibernate/Transacter;", "metadata", "configureDynamic", "Lmisk/hibernate/Query;", "rowLimit", "", "Companion", "Request", "Response", "misk-hibernate"})
@SourceDebugExtension(value={"SMAP\nHibernateDatabaseQueryDynamicAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HibernateDatabaseQueryDynamicAction.kt\nmisk/hibernate/actions/HibernateDatabaseQueryDynamicAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,128:1\n1855#2,2:129\n1855#2,2:131\n12#3:133\n*S KotlinDebug\n*F\n+ 1 HibernateDatabaseQueryDynamicAction.kt\nmisk/hibernate/actions/HibernateDatabaseQueryDynamicAction\n*L\n100#1:129,2\n105#1:131,2\n123#1:133\n*E\n"})
public final class HibernateDatabaseQueryDynamicAction
implements WebAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActionScoped<MiskCaller> callerProvider;
    @NotNull
    private final List<DatabaseQueryMetadata> databaseQueryMetadata;
    @NotNull
    private final Injector injector;
    @NotNull
    private final ReflectionQuery.QueryLimitsConfig queryLimitsConfig;
    @NotNull
    private static final KLogger logger;
    @NotNull
    public static final String HIBERNATE_QUERY_DYNAMIC_WEBACTION_PATH = "/api/database/query/hibernate/dynamic";

    @Inject
    public HibernateDatabaseQueryDynamicAction(@NotNull ActionScoped<MiskCaller> callerProvider, @NotNull List<DatabaseQueryMetadata> databaseQueryMetadata, @NotNull Injector injector, @NotNull ReflectionQuery.QueryLimitsConfig queryLimitsConfig) {
        Intrinsics.checkNotNullParameter(callerProvider, (String)"callerProvider");
        Intrinsics.checkNotNullParameter(databaseQueryMetadata, (String)"databaseQueryMetadata");
        Intrinsics.checkNotNullParameter((Object)injector, (String)"injector");
        Intrinsics.checkNotNullParameter((Object)queryLimitsConfig, (String)"queryLimitsConfig");
        this.callerProvider = callerProvider;
        this.databaseQueryMetadata = databaseQueryMetadata;
        this.injector = injector;
        this.queryLimitsConfig = queryLimitsConfig;
    }

    @JvmSuppressWildcards
    private static /* synthetic */ void getCallerProvider$annotations() {
    }

    @Post(pathPattern="/api/database/query/hibernate/dynamic")
    @RequestContentType(value={"application/json;charset=utf-8"})
    @ResponseContentType(value={"application/json;charset=utf-8"})
    @AdminDashboardAccess
    @NotNull
    public final Response query(@RequestBody @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this.callerProvider.get();
        Intrinsics.checkNotNull((Object)object);
        MiskCaller caller = (MiskCaller)object;
        String queryClass = request.getQueryClass();
        HibernateDatabaseQueryWebActionModule.Companion.checkQueryMatchesAction(queryClass, true);
        DatabaseQueryMetadata metadata = HibernateDatabaseQueryWebActionModule.Companion.findDatabaseQueryMetadata(this.databaseQueryMetadata, queryClass);
        Transacter transacter = HibernateDatabaseQueryWebActionModule.Companion.getTransacterForDatabaseQueryAction(this.injector, metadata);
        if (!caller.isAllowed(metadata.getAllowedCapabilities(), metadata.getAllowedServices())) {
            throw new UnauthorizedException("Unauthorized to query [dbEntity=" + metadata.getEntityClass() + "]", null, 2, null);
        }
        List<Map<String, Object>> results = this.runDynamicQuery(transacter, caller.getPrincipal(), request, metadata);
        return new Response(results);
    }

    private final List<Map<String, Object>> runDynamicQuery(Transacter transacter, String principal, Request request, DatabaseQueryMetadata metadata) {
        return (List)transacter.transaction((Function1)new Function1<Session, List<? extends Map<String, ? extends Object>>>(transacter, metadata, this, principal, request){
            final /* synthetic */ Transacter $transacter;
            final /* synthetic */ DatabaseQueryMetadata $metadata;
            final /* synthetic */ HibernateDatabaseQueryDynamicAction this$0;
            final /* synthetic */ String $principal;
            final /* synthetic */ Request $request;
            {
                this.$transacter = $transacter;
                this.$metadata = $metadata;
                this.this$0 = $receiver;
                this.$principal = $principal;
                this.$request = $request;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Map<String, Object>> invoke(@NotNull Session session) {
                void $this$mapTo$iv$iv;
                Object v0;
                Object object2;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Iterable iterable = this.$transacter.entities();
                    Request request = this.$request;
                    Iterable iterable2 = iterable;
                    for (Object object2 : iterable2) {
                        KClass it = (KClass)object2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSimpleName(), (Object)request.getEntityClass())) continue;
                        v0 = object2;
                        break block5;
                    }
                    v0 = null;
                }
                KClass kClass = v0;
                if (kClass == null) {
                    throw new BadRequestException("[dbEntity=" + this.$metadata.getEntityClass() + "] is not an installed HibernateEntity", null, 2, null);
                }
                KClass dbEntity = kClass;
                Pair pair = HibernateDatabaseQueryDynamicAction.access$runDynamicQuery(this.this$0, session, this.$principal, dbEntity, this.$request);
                List selectPaths = (List)pair.component1();
                List rows2 = (List)pair.component2();
                Iterable $this$map$iv = rows2;
                boolean $i$f$map = false;
                object2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$mapIndexedTo$iv$iv;
                    void row;
                    List list = (List)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$mapIndexed$iv = (Iterable)row;
                    boolean $i$f$mapIndexed = false;
                    Iterable iterable = $this$mapIndexed$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (T item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                        void cell;
                        void index;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        T t = item$iv$iv2;
                        int n2 = n;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(TuplesKt.to(selectPaths.get((int)index), (Object)cell));
                    }
                    collection.add(MapsKt.toMap((Iterable)((List)destination$iv$iv2)));
                }
                return (List)destination$iv$iv;
            }
        });
    }

    private final Pair<List<String>, List<List<Object>>> runDynamicQuery(Session session, String principal, KClass<? extends DbEntity<?>> dbEntity, Request request) {
        Object object = request.getQuery().getQueryConfig();
        int maxRows = object != null && (object = ((HibernateDatabaseQueryMetadataFactory.Companion.QueryConfig)object).getMaxRows()) != null ? ((Integer)object).intValue() : this.queryLimitsConfig.getMaxMaxRows();
        Query<DbEntity<?>> configuredQuery = this.configureDynamic(new ReflectionQuery.Factory(this.queryLimitsConfig).dynamicQuery(dbEntity), request, maxRows);
        HibernateDatabaseQueryMetadataFactory.Companion.DynamicQuerySelect dynamicQuerySelect = request.getQuery().getSelect();
        List<String> selectPaths = HibernateDatabaseQueryWebActionModule.Companion.validateSelectPathsOrDefault(dbEntity, dynamicQuerySelect != null ? dynamicQuerySelect.getPaths() : null);
        logger.info("Query sent from dashboard [principal=" + principal + "][dbEntity=" + request.getEntityClass() + "][selectPaths=" + selectPaths + "] " + request.getQuery());
        List<List<Object>> rows2 = configuredQuery.dynamicList(session, selectPaths);
        return new Pair(selectPaths, rows2);
    }

    private final Query<? extends DbEntity<?>> configureDynamic(Query<? extends DbEntity<?>> $this$configureDynamic, Request request, int rowLimit) {
        Query<DbEntity<?>> query;
        block7: {
            String path;
            Object object;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Query<DbEntity<?>> $this$configureDynamic_u24lambda_u242 = query = $this$configureDynamic;
            boolean bl = false;
            $this$configureDynamic_u24lambda_u242.setMaxRows(rowLimit);
            List<HibernateDatabaseQueryMetadataFactory.Companion.DynamicQueryConstraint> list = request.getQuery().getConstraints();
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    object = (HibernateDatabaseQueryMetadataFactory.Companion.DynamicQueryConstraint)element$iv;
                    boolean bl2 = false;
                    path = ((HibernateDatabaseQueryMetadataFactory.Companion.DynamicQueryConstraint)object).component1();
                    Operator operator = ((HibernateDatabaseQueryMetadataFactory.Companion.DynamicQueryConstraint)object).component2();
                    String value = ((HibernateDatabaseQueryMetadataFactory.Companion.DynamicQueryConstraint)object).component3();
                    if (path == null) {
                        throw new BadRequestException("Constraint path must be non-null", null, 2, null);
                    }
                    if (operator == null) {
                        throw new BadRequestException("Constraint operator must be non-null", null, 2, null);
                    }
                    $this$configureDynamic_u24lambda_u242.dynamicAddConstraint(path, operator, value);
                }
            }
            List<HibernateDatabaseQueryMetadataFactory.Companion.DynamicQueryOrder> list2 = request.getQuery().getOrders();
            if (list2 == null) break block7;
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                object = (HibernateDatabaseQueryMetadataFactory.Companion.DynamicQueryOrder)element$iv;
                boolean bl3 = false;
                path = ((HibernateDatabaseQueryMetadataFactory.Companion.DynamicQueryOrder)object).component1();
                Boolean ascending = ((HibernateDatabaseQueryMetadataFactory.Companion.DynamicQueryOrder)object).component2();
                if (path == null) {
                    throw new BadRequestException("Order path must be non-null", null, 2, null);
                }
                if (ascending == null) {
                    throw new BadRequestException("Order ascending must be non-null", null, 2, null);
                }
                $this$configureDynamic_u24lambda_u242.dynamicAddOrder(path, ascending);
            }
        }
        return query;
    }

    public static final /* synthetic */ Pair access$runDynamicQuery(HibernateDatabaseQueryDynamicAction $this, Session session, String principal, KClass dbEntity, Request request) {
        return $this.runDynamicQuery(session, principal, dbEntity, request);
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(HibernateDatabaseQueryDynamicAction.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lmisk/hibernate/actions/HibernateDatabaseQueryDynamicAction$Companion;", "", "()V", "HIBERNATE_QUERY_DYNAMIC_WEBACTION_PATH", "", "logger", "Lmu/KLogger;", "misk-hibernate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lmisk/hibernate/actions/HibernateDatabaseQueryDynamicAction$Request;", "", "entityClass", "", "queryClass", "query", "Lmisk/hibernate/actions/HibernateDatabaseQueryMetadataFactory$Companion$DynamicQuery;", "(Ljava/lang/String;Ljava/lang/String;Lmisk/hibernate/actions/HibernateDatabaseQueryMetadataFactory$Companion$DynamicQuery;)V", "getEntityClass", "()Ljava/lang/String;", "getQuery", "()Lmisk/hibernate/actions/HibernateDatabaseQueryMetadataFactory$Companion$DynamicQuery;", "getQueryClass", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "misk-hibernate"})
    public static final class Request {
        @NotNull
        private final String entityClass;
        @NotNull
        private final String queryClass;
        @NotNull
        private final HibernateDatabaseQueryMetadataFactory.Companion.DynamicQuery query;

        public Request(@NotNull String entityClass, @NotNull String queryClass, @NotNull HibernateDatabaseQueryMetadataFactory.Companion.DynamicQuery query) {
            Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
            Intrinsics.checkNotNullParameter((Object)queryClass, (String)"queryClass");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.entityClass = entityClass;
            this.queryClass = queryClass;
            this.query = query;
        }

        @NotNull
        public final String getEntityClass() {
            return this.entityClass;
        }

        @NotNull
        public final String getQueryClass() {
            return this.queryClass;
        }

        @NotNull
        public final HibernateDatabaseQueryMetadataFactory.Companion.DynamicQuery getQuery() {
            return this.query;
        }

        @NotNull
        public final String component1() {
            return this.entityClass;
        }

        @NotNull
        public final String component2() {
            return this.queryClass;
        }

        @NotNull
        public final HibernateDatabaseQueryMetadataFactory.Companion.DynamicQuery component3() {
            return this.query;
        }

        @NotNull
        public final Request copy(@NotNull String entityClass, @NotNull String queryClass, @NotNull HibernateDatabaseQueryMetadataFactory.Companion.DynamicQuery query) {
            Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
            Intrinsics.checkNotNullParameter((Object)queryClass, (String)"queryClass");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new Request(entityClass, queryClass, query);
        }

        public static /* synthetic */ Request copy$default(Request request, String string, String string2, HibernateDatabaseQueryMetadataFactory.Companion.DynamicQuery dynamicQuery, int n, Object object) {
            if ((n & 1) != 0) {
                string = request.entityClass;
            }
            if ((n & 2) != 0) {
                string2 = request.queryClass;
            }
            if ((n & 4) != 0) {
                dynamicQuery = request.query;
            }
            return request.copy(string, string2, dynamicQuery);
        }

        @NotNull
        public String toString() {
            return "Request(entityClass=" + this.entityClass + ", queryClass=" + this.queryClass + ", query=" + this.query + ")";
        }

        public int hashCode() {
            int result = this.entityClass.hashCode();
            result = result * 31 + this.queryClass.hashCode();
            result = result * 31 + this.query.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Request)) {
                return false;
            }
            Request request = (Request)other;
            if (!Intrinsics.areEqual((Object)this.entityClass, (Object)request.entityClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.queryClass, (Object)request.queryClass)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.query, (Object)request.query);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u0019\u0010\b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lmisk/hibernate/actions/HibernateDatabaseQueryDynamicAction$Response;", "", "results", "", "(Ljava/util/List;)V", "getResults", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "misk-hibernate"})
    public static final class Response {
        @NotNull
        private final List<Object> results;

        public Response(@NotNull List<? extends Object> results) {
            Intrinsics.checkNotNullParameter(results, (String)"results");
            this.results = results;
        }

        @NotNull
        public final List<Object> getResults() {
            return this.results;
        }

        @NotNull
        public final List<Object> component1() {
            return this.results;
        }

        @NotNull
        public final Response copy(@NotNull List<? extends Object> results) {
            Intrinsics.checkNotNullParameter(results, (String)"results");
            return new Response(results);
        }

        public static /* synthetic */ Response copy$default(Response response, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = response.results;
            }
            return response.copy(list);
        }

        @NotNull
        public String toString() {
            return "Response(results=" + this.results + ")";
        }

        public int hashCode() {
            return ((Object)this.results).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Response)) {
                return false;
            }
            Response response = (Response)other;
            return Intrinsics.areEqual(this.results, response.results);
        }
    }
}

