/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.google.common.collect.LinkedHashMultiset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import misk.hibernate.ColumnDeclaration;
import misk.hibernate.DatabaseDeclaration;
import misk.hibernate.Declaration;
import misk.hibernate.Message;
import misk.hibernate.Path;
import misk.hibernate.SchemaValidator;
import misk.hibernate.Session;
import misk.hibernate.TableDeclaration;
import misk.hibernate.Transacter;
import misk.hibernate.TransacterKt;
import misk.hibernate.ValidationReport;
import misk.jdbc.Check;
import misk.vitess.Shard;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.jetbrains.annotations.NotNull;

@kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0002J^\u0010\u001a\u001a2\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u001c\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001d0\u001e0\u001c0\u001b\"\b\b\u0000\u0010\u001d*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001cH\u0002J\b\u0010\"\u001a\u00020\fH\u0002J\u001e\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u001d\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b(J \u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u0018\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0013H\u0002J\u0018\u00102\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u00020+H\u0002J\u001e\u00104\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00070\u0007 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lmisk/hibernate/SchemaValidator;", "", "()V", "messages", "", "Lmisk/hibernate/Message;", "path", "Lmisk/hibernate/Path;", "validatedPaths", "Lcom/google/common/collect/LinkedHashMultiset;", "kotlin.jvm.PlatformType", "checkWarning", "", "expression", "", "lambda", "Lkotlin/Function0;", "", "readDeclarationFromDatabase", "Lmisk/hibernate/DatabaseDeclaration;", "connection", "Ljava/sql/Connection;", "readDeclarationFromHibernate", "metadata", "Lorg/hibernate/boot/Metadata;", "reportString", "splitChildren", "Lkotlin/Triple;", "", "C", "Lkotlin/Pair;", "Lmisk/hibernate/Declaration;", "firstSchemaChildren", "secondSchemaChildren", "throwIfErrorsFound", "validate", "Lmisk/hibernate/ValidationReport;", "transacter", "Lmisk/hibernate/Transacter;", "hibernateMetadata", "validate$misk_hibernate", "validateColumns", "dbTable", "Lmisk/hibernate/TableDeclaration;", "dbColumn", "Lmisk/hibernate/ColumnDeclaration;", "hibernateColumn", "validateDatabase", "dbSchema", "hibernateSchema", "validateTables", "hibernateTable", "withDeclaration", "misk-hibernate"})
@SourceDebugExtension(value={"SMAP\nSchemaValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaValidator.kt\nmisk/hibernate/SchemaValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,359:1\n1855#2,2:360\n1603#2,9:362\n1855#2:371\n1856#2:373\n1612#2:374\n1603#2,9:375\n1855#2:384\n1856#2:386\n1612#2:387\n1747#2,3:388\n1726#2,3:391\n1549#2:448\n1620#2,3:449\n3190#2,10:452\n1549#2:462\n1620#2,3:463\n3190#2,10:466\n1045#2:476\n1045#2:477\n1#3:372\n1#3:385\n988#4:394\n1017#4,3:395\n1020#4,3:405\n988#4:415\n1017#4,3:416\n1020#4,3:426\n372#5,7:398\n526#5:408\n511#5,6:409\n372#5,7:419\n526#5:429\n511#5,6:430\n76#6:436\n96#6,5:437\n76#6:442\n96#6,5:443\n*S KotlinDebug\n*F\n+ 1 SchemaValidator.kt\nmisk/hibernate/SchemaValidator\n*L\n28#1:360,2\n54#1:362,9\n54#1:371\n54#1:373\n54#1:374\n55#1:375,9\n55#1:384\n55#1:386\n55#1:387\n64#1:388,3\n180#1:391,3\n249#1:448\n249#1:449,3\n251#1:452,10\n256#1:462\n256#1:463,3\n258#1:466,10\n261#1:476\n262#1:477\n54#1:372\n55#1:385\n223#1:394\n223#1:395,3\n223#1:405,3\n235#1:415\n235#1:416,3\n235#1:426,3\n223#1:398,7\n224#1:408\n224#1:409,6\n235#1:419,7\n236#1:429\n236#1:430,6\n245#1:436\n245#1:437,5\n246#1:442\n246#1:443,5\n*E\n"})
public final class SchemaValidator {
    @NotNull
    private final List<Message> messages = new ArrayList();
    @NotNull
    private Path path = new Path(null, null, null);
    private final LinkedHashMultiset<Path> validatedPaths = LinkedHashMultiset.create();

    @NotNull
    public final ValidationReport validate$misk_hibernate(@NotNull Transacter transacter, @NotNull Metadata hibernateMetadata) {
        String it$iv$iv;
        boolean bl;
        Path it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)transacter, (String)"transacter");
        Intrinsics.checkNotNullParameter((Object)hibernateMetadata, (String)"hibernateMetadata");
        DatabaseDeclaration hibernateSchema = this.readDeclarationFromHibernate(hibernateMetadata);
        LinkedHashSet allDbTables = new LinkedHashSet();
        Iterable $this$forEach$iv = TransacterKt.shards(transacter);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shard shard = (Shard)element$iv;
            boolean bl3 = false;
            DatabaseDeclaration dbSchema2 = (DatabaseDeclaration)TransacterKt.transaction(transacter, shard, (Function1)new Function1<Session, DatabaseDeclaration>(this){
                final /* synthetic */ SchemaValidator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final DatabaseDeclaration invoke(@NotNull Session s) {
                    Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                    return (DatabaseDeclaration)s.withoutChecks(new Check[0], (Function0)new Function0<DatabaseDeclaration>(s, this.this$0){
                        final /* synthetic */ Session $s;
                        final /* synthetic */ SchemaValidator this$0;
                        {
                            this.$s = $s;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final DatabaseDeclaration invoke() {
                            return (DatabaseDeclaration)this.$s.getHibernateSession().doReturningWork(arg_0 -> validate.1.dbSchema.1.invoke$lambda$0(this.this$0, arg_0));
                        }

                        private static final DatabaseDeclaration invoke$lambda$0(SchemaValidator this$0, Connection it) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNull((Object)it);
                            return SchemaValidator.access$readDeclarationFromDatabase(this$0, it);
                        }
                    });
                }
            });
            this.withDeclaration(Path.copy$default(this.path, dbSchema2.getName(), null, null, 6, null), (Function0<Unit>)((Function0)new Function0<Unit>(this, dbSchema2, hibernateSchema){
                final /* synthetic */ SchemaValidator this$0;
                final /* synthetic */ DatabaseDeclaration $dbSchema;
                final /* synthetic */ DatabaseDeclaration $hibernateSchema;
                {
                    this.this$0 = $receiver;
                    this.$dbSchema = $dbSchema;
                    this.$hibernateSchema = $hibernateSchema;
                    super(0);
                }

                public final void invoke() {
                    DatabaseDeclaration databaseDeclaration = this.$dbSchema;
                    Intrinsics.checkNotNullExpressionValue((Object)databaseDeclaration, (String)"$dbSchema");
                    SchemaValidator.access$validateDatabase(this.this$0, databaseDeclaration, this.$hibernateSchema);
                }
            }));
            allDbTables.addAll(dbSchema2.getTables());
        }
        Triple<List<TableDeclaration>, List<TableDeclaration>, List<Pair<TableDeclaration, TableDeclaration>>> triple = this.splitChildren(CollectionsKt.toList((Iterable)allDbTables), hibernateSchema.getTables());
        List dbOnly = (List)triple.component1();
        List hibernateOnly = (List)triple.component2();
        this.validate(hibernateOnly.isEmpty(), (Function0<String>)((Function0)new Function0<String>((List<TableDeclaration>)hibernateOnly){
            final /* synthetic */ List<TableDeclaration> $hibernateOnly;
            {
                this.$hibernateOnly = $hibernateOnly;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$hibernateOnly;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TableDeclaration tableDeclaration = (TableDeclaration)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                return "Database missing tables " + (List)destination$iv$iv;
            }
        }));
        this.checkWarning(dbOnly.isEmpty(), (Function0<String>)((Function0)new Function0<String>((List<TableDeclaration>)dbOnly){
            final /* synthetic */ List<TableDeclaration> $dbOnly;
            {
                this.$dbOnly = $dbOnly;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$dbOnly;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TableDeclaration tableDeclaration = (TableDeclaration)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                return "Hibernate missing tables " + (List)destination$iv$iv;
            }
        }));
        this.throwIfErrorsFound();
        LinkedHashMultiset<Path> linkedHashMultiset = this.validatedPaths;
        Intrinsics.checkNotNullExpressionValue(linkedHashMultiset, (String)"validatedPaths");
        Iterable $this$mapNotNull$iv = (Iterable)linkedHashMultiset;
        boolean $i$f$mapNotNull = false;
        Iterable bl3 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (Path)element$iv$iv;
            boolean bl4 = false;
            if (it.getSchema() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        LinkedHashMultiset<Path> linkedHashMultiset2 = this.validatedPaths;
        Intrinsics.checkNotNullExpressionValue(linkedHashMultiset2, (String)"validatedPaths");
        $this$mapNotNull$iv = (Iterable)linkedHashMultiset2;
        Set set2 = set;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach2 = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (Path)element$iv$iv;
            boolean bl5 = false;
            if (it.getTable() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set set3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        LinkedHashMultiset<Path> linkedHashMultiset3 = this.validatedPaths;
        Intrinsics.checkNotNullExpressionValue(linkedHashMultiset3, (String)"validatedPaths");
        Set set4 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)linkedHashMultiset3)), (Function1)validate.6.INSTANCE), (Function1)validate.7.INSTANCE));
        Set set5 = set3;
        Set set6 = set2;
        return new ValidationReport(set6, set5, set4);
    }

    private final void throwIfErrorsFound() {
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.messages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message it = (Message)element$iv;
                    boolean bl2 = false;
                    if (!it.getError()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!(!bl)) {
            boolean bl3 = false;
            String string = this.reportString();
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DatabaseDeclaration readDeclarationFromDatabase(Connection connection) {
        Object object = new String[]{"schema_version"};
        Object[] ignoreTables = object;
        object = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement tablesStmt = (Statement)object;
            boolean bl = false;
            ResultSet tablesRs = tablesStmt.executeQuery("SELECT * FROM information_schema.tables WHERE table_schema = database()");
            List schemaTables = new ArrayList();
            String tableSchema = null;
            while (tablesRs.next()) {
                List list;
                String tableName = tablesRs.getString("TABLE_NAME");
                if (ArraysKt.contains((Object[])ignoreTables, (Object)tableName)) continue;
                tableSchema = tablesRs.getString("TABLE_SCHEMA");
                AutoCloseable autoCloseable = connection.prepareStatement("SELECT * FROM information_schema.columns WHERE table_schema = ? AND table_name = ?");
                Throwable throwable2 = null;
                try {
                    PreparedStatement columnsStmt = (PreparedStatement)autoCloseable;
                    boolean bl2 = false;
                    columnsStmt.setString(1, tableSchema);
                    columnsStmt.setString(2, tableName);
                    ResultSet columnResultSet = columnsStmt.executeQuery();
                    List columns = new ArrayList();
                    while (columnResultSet.next()) {
                        boolean bl3;
                        String string;
                        Collection collection = columns;
                        String string2 = columnResultSet.getString("COLUMN_NAME");
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                        boolean bl4 = Intrinsics.areEqual((Object)columnResultSet.getString("IS_NULLABLE"), (Object)"YES");
                        String string3 = string = columnResultSet.getString("COLUMN_DEFAULT");
                        if (string3 != null) {
                            Intrinsics.checkNotNull((Object)string3);
                            bl3 = !StringsKt.isBlank((CharSequence)string);
                        } else {
                            bl3 = false;
                        }
                        collection.add(new ColumnDeclaration(string2, bl4, bl3));
                    }
                    list = columns;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                List columns = list;
                Collection collection = schemaTables;
                Intrinsics.checkNotNull((Object)tableName);
                collection.add(new TableDeclaration(tableName, columns));
            }
            String string = tableSchema;
            if (string == null) {
                string = "unknown";
            }
            DatabaseDeclaration databaseDeclaration = new DatabaseDeclaration(string, schemaTables);
            return databaseDeclaration;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    private final DatabaseDeclaration readDeclarationFromHibernate(Metadata metadata) {
        List hibernateTables = new ArrayList();
        for (Table table : metadata.collectTableMappings()) {
            String tableName = table.getName();
            Iterator columnsIt = table.getColumnIterator();
            List columns = new ArrayList();
            while (columnsIt.hasNext()) {
                Object e = columnsIt.next();
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.hibernate.mapping.Column");
                Column column = (Column)e;
                Collection collection = columns;
                String string = column.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = column.getDefaultValue();
                collection.add(new ColumnDeclaration(string, column.isNullable(), string2 != null ? !StringsKt.isBlank((CharSequence)string2) : false));
            }
            Collection collection = hibernateTables;
            Intrinsics.checkNotNull((Object)tableName);
            collection.add(new TableDeclaration(tableName, columns));
        }
        return new DatabaseDeclaration("hibernateSchema", hibernateTables);
    }

    private final String reportString() {
        StringBuilder errorReport = new StringBuilder("Failed Schema Validation: \n\n");
        for (Message message : this.messages) {
            if (message.getError()) {
                errorReport.append("ERROR ");
            } else {
                errorReport.append("WARNING ");
            }
            errorReport.append("at " + message.getPath() + ":\n");
            errorReport.append("  " + StringsKt.replace$default((String)message.getText(), (String)"\n", (String)"\n  ", (boolean)false, (int)4, null) + "\n");
            errorReport.append("\n");
        }
        String string = errorReport.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void validateDatabase(DatabaseDeclaration dbSchema2, DatabaseDeclaration hibernateSchema) {
        List intersectionPairs = (List)this.splitChildren(dbSchema2.getTables(), hibernateSchema.getTables()).component3();
        for (Pair pair : intersectionPairs) {
            TableDeclaration dbTable = (TableDeclaration)pair.component1();
            TableDeclaration hibernateTable = (TableDeclaration)pair.component2();
            this.withDeclaration(Path.copy$default(this.path, null, hibernateTable.getSnakeCaseName(), null, 5, null), (Function0<Unit>)((Function0)new Function0<Unit>(this, dbTable, hibernateTable){
                final /* synthetic */ SchemaValidator this$0;
                final /* synthetic */ TableDeclaration $dbTable;
                final /* synthetic */ TableDeclaration $hibernateTable;
                {
                    this.this$0 = $receiver;
                    this.$dbTable = $dbTable;
                    this.$hibernateTable = $hibernateTable;
                    super(0);
                }

                public final void invoke() {
                    SchemaValidator.access$validateTables(this.this$0, this.$dbTable, this.$hibernateTable);
                }
            }));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void validateTables(TableDeclaration dbTable, TableDeclaration hibernateTable) {
        block6: {
            var3_3 = this.splitChildren(dbTable.getColumns(), hibernateTable.getColumns());
            dbOnly = (List)var3_3.component1();
            hibernateOnly = (List)var3_3.component2();
            intersectionPairs = (List)var3_3.component3();
            this.validate(Intrinsics.areEqual((Object)dbTable.getSnakeCaseName(), (Object)dbTable.getName()), (Function0<String>)((Function0)new Function0<String>(dbTable){
                final /* synthetic */ TableDeclaration $dbTable;
                {
                    this.$dbTable = $dbTable;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Database table name \"" + this.$dbTable.getName() + "\" should be in lower_snake_case";
                }
            }));
            this.validate(Intrinsics.areEqual((Object)dbTable.getName(), (Object)hibernateTable.getName()), (Function0<String>)((Function0)new Function0<String>(dbTable, hibernateTable){
                final /* synthetic */ TableDeclaration $dbTable;
                final /* synthetic */ TableDeclaration $hibernateTable;
                {
                    this.$dbTable = $dbTable;
                    this.$hibernateTable = $hibernateTable;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Database table name \"" + this.$dbTable.getName() + "\" should exactly match hibernate \"" + this.$hibernateTable.getName() + "\"";
                }
            }));
            this.validate(hibernateOnly.isEmpty(), (Function0<String>)((Function0)new Function0<String>(dbTable, (List<ColumnDeclaration>)hibernateOnly, hibernateTable){
                final /* synthetic */ TableDeclaration $dbTable;
                final /* synthetic */ List<ColumnDeclaration> $hibernateOnly;
                final /* synthetic */ TableDeclaration $hibernateTable;
                {
                    this.$dbTable = $dbTable;
                    this.$hibernateOnly = $hibernateOnly;
                    this.$hibernateTable = $hibernateTable;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$hibernateOnly;
                    String string = this.$dbTable.getName();
                    boolean $i$f$map = false;
                    void var3_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ColumnDeclaration columnDeclaration = (ColumnDeclaration)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getName());
                    }
                    return "Database table \"" + string + "\" is missing columns " + (List)destination$iv$iv + " found in hibernate \"" + this.$hibernateTable.getName() + "\"";
                }
            }));
            v0 = this;
            if (dbOnly.isEmpty()) ** GOTO lbl-1000
            var7_7 = dbOnly;
            var13_8 = v0;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v1 = true;
            } else {
                for (T element$iv : $this$all$iv) {
                    it = (ColumnDeclaration)element$iv;
                    $i$a$-all-SchemaValidator$validateTables$4 = false;
                    if (it.getHasDefaultValue() != false || it.getNullable() != false) continue;
                    v1 = false;
                    break block6;
                }
                v1 = true;
            }
        }
        var14_15 = v1;
        v0 = var13_8;
        if (var14_15) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        v0.validate(v2, (Function0<String>)((Function0)new Function0<String>(hibernateTable, (List<ColumnDeclaration>)dbOnly, dbTable){
            final /* synthetic */ TableDeclaration $hibernateTable;
            final /* synthetic */ List<ColumnDeclaration> $dbOnly;
            final /* synthetic */ TableDeclaration $dbTable;
            {
                this.$hibernateTable = $hibernateTable;
                this.$dbOnly = $dbOnly;
                this.$dbTable = $dbTable;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ColumnDeclaration it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = this.$dbOnly;
                String string = this.$hibernateTable.getName();
                boolean $i$f$filter = false;
                void var3_4 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ColumnDeclaration)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.getHasDefaultValue() && !it.getNullable())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ColumnDeclaration)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                return "Hibernate entity \"" + string + "\" is missing columns " + (List)destination$iv$iv + " expected in table \"" + this.$dbTable.getName() + "\"";
            }
        }));
        for (Pair var8_10 : intersectionPairs) {
            dbColumn = (ColumnDeclaration)var8_10.component1();
            hibernateColumn = (ColumnDeclaration)var8_10.component2();
            this.withDeclaration(Path.copy$default(this.path, null, null, hibernateColumn.getSnakeCaseName(), 3, null), (Function0<Unit>)((Function0)new Function0<Unit>(this, dbTable, dbColumn, hibernateColumn){
                final /* synthetic */ SchemaValidator this$0;
                final /* synthetic */ TableDeclaration $dbTable;
                final /* synthetic */ ColumnDeclaration $dbColumn;
                final /* synthetic */ ColumnDeclaration $hibernateColumn;
                {
                    this.this$0 = $receiver;
                    this.$dbTable = $dbTable;
                    this.$dbColumn = $dbColumn;
                    this.$hibernateColumn = $hibernateColumn;
                    super(0);
                }

                public final void invoke() {
                    SchemaValidator.access$validateColumns(this.this$0, this.$dbTable, this.$dbColumn, this.$hibernateColumn);
                }
            }));
        }
    }

    private final void validateColumns(TableDeclaration dbTable, ColumnDeclaration dbColumn, ColumnDeclaration hibernateColumn) {
        this.validate(Intrinsics.areEqual((Object)dbColumn.getSnakeCaseName(), (Object)dbColumn.getName()), (Function0<String>)((Function0)new Function0<String>(dbTable, dbColumn){
            final /* synthetic */ TableDeclaration $dbTable;
            final /* synthetic */ ColumnDeclaration $dbColumn;
            {
                this.$dbTable = $dbTable;
                this.$dbColumn = $dbColumn;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Column " + this.$dbTable.getName() + "." + this.$dbColumn.getName() + " should be in lower_snake_case";
            }
        }));
        this.validate(Intrinsics.areEqual((Object)dbColumn.getName(), (Object)hibernateColumn.getName()), (Function0<String>)((Function0)new Function0<String>(dbTable, dbColumn, hibernateColumn){
            final /* synthetic */ TableDeclaration $dbTable;
            final /* synthetic */ ColumnDeclaration $dbColumn;
            final /* synthetic */ ColumnDeclaration $hibernateColumn;
            {
                this.$dbTable = $dbTable;
                this.$dbColumn = $dbColumn;
                this.$hibernateColumn = $hibernateColumn;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Column " + this.$dbTable.getName() + "." + this.$dbColumn.getName() + " should exactly match hibernate " + this.$hibernateColumn.getName();
            }
        }));
        this.validate(dbColumn.getNullable() || !hibernateColumn.getNullable() || dbColumn.getHasDefaultValue(), (Function0<String>)((Function0)new Function0<String>(dbTable, dbColumn, hibernateColumn){
            final /* synthetic */ TableDeclaration $dbTable;
            final /* synthetic */ ColumnDeclaration $dbColumn;
            final /* synthetic */ ColumnDeclaration $hibernateColumn;
            {
                this.$dbTable = $dbTable;
                this.$dbColumn = $dbColumn;
                this.$hibernateColumn = $hibernateColumn;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Column " + this.$dbTable.getName() + "." + this.$dbColumn.getName() + " is NOT NULL in database but " + this.$hibernateColumn.getName() + " is nullable in hibernate";
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final <C extends Declaration> Triple<List<C>, List<C>, List<Pair<C, C>>> splitChildren(List<? extends C> firstSchemaChildren, List<? extends C> secondSchemaChildren) {
        Declaration it;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$flatMapTo$iv$iv2;
        void $this$flatMap$iv2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object element$iv$iv3;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        Object it2;
        Object element$iv$iv22;
        void $this$groupByTo$iv$iv2;
        Map $this$groupBy$iv2;
        Sequence sequence = CollectionsKt.asSequence((Iterable)firstSchemaChildren);
        boolean $i$f$groupBy = false;
        void var6_6 = $this$groupBy$iv2;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv22 : $this$groupByTo$iv$iv2) {
            Object object;
            it2 = (Declaration)element$iv$iv22;
            boolean bl = false;
            String key$iv$iv = ((Declaration)it2).getSnakeCaseName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv22);
        }
        $this$groupBy$iv2 = destination$iv$iv;
        boolean $i$f$filter22 = false;
        $this$groupByTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            it2 = element$iv$iv22 = iterator.next();
            boolean bl = false;
            if (!(((List)it2.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv22.getKey(), element$iv$iv22.getValue());
        }
        Map duplicateFirstChildren = destination$iv$iv;
        this.validate(duplicateFirstChildren.isEmpty(), (Function0<String>)((Function0)new Function0<String>(duplicateFirstChildren){
            final /* synthetic */ Map<String, List<C>> $duplicateFirstChildren;
            {
                this.$duplicateFirstChildren = $duplicateFirstChildren;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void $this$mapTo$iv$iv;
                Map<String, List<C>> $this$map$iv = this.$duplicateFirstChildren;
                boolean $i$f$map = false;
                Map<String, List<C>> map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void $this$mapTo$iv$iv2;
                    void duplicates;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv2 = (Iterable)duplicates.getValue();
                    boolean $i$f$map2 = false;
                    Iterable iterable = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        Declaration declaration = (Declaration)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(it.getName());
                    }
                    collection.add((List)destination$iv$iv2);
                }
                List duplicatesList = (List)destination$iv$iv;
                return "Duplicate identifiers: " + duplicatesList;
            }
        }));
        Sequence $i$f$filter22 = CollectionsKt.asSequence((Iterable)secondSchemaChildren);
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv3 : $this$groupByTo$iv$iv) {
            Object object;
            Declaration it3 = (Declaration)element$iv$iv3;
            boolean bl = false;
            String key$iv$iv = it3.getSnakeCaseName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv3);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$filter32 = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        element$iv$iv22 = $this$filterTo$iv$iv.entrySet().iterator();
        while (element$iv$iv22.hasNext()) {
            Object it4 = element$iv$iv3 = (Map.Entry)element$iv$iv22.next();
            boolean bl = false;
            if (!(((List)it4.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        Map duplicateSecondChildren = destination$iv$iv2;
        this.validate(duplicateSecondChildren.isEmpty(), (Function0<String>)((Function0)new Function0<String>(duplicateSecondChildren){
            final /* synthetic */ Map<String, List<C>> $duplicateSecondChildren;
            {
                this.$duplicateSecondChildren = $duplicateSecondChildren;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void $this$mapTo$iv$iv;
                Map<String, List<C>> $this$map$iv = this.$duplicateSecondChildren;
                boolean $i$f$map = false;
                Map<String, List<C>> map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void $this$mapTo$iv$iv2;
                    void duplicates;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Iterable $this$map$iv2 = (Iterable)duplicates.getValue();
                    boolean $i$f$map2 = false;
                    Iterable iterable = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        Declaration declaration = (Declaration)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(it.getName());
                    }
                    collection.add((List)destination$iv$iv2);
                }
                List duplicatesList = (List)destination$iv$iv;
                return "Duplicate identifiers: " + duplicatesList;
            }
        }));
        Map $i$f$filter32 = duplicateFirstChildren;
        Iterable iterable = firstSchemaChildren;
        boolean $i$f$flatMap22 = false;
        destination$iv$iv2 = $this$flatMap$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        element$iv$iv3 = $this$flatMapTo$iv$iv2.entrySet().iterator();
        while (element$iv$iv3.hasNext()) {
            Map.Entry element$iv$iv4;
            Map.Entry it5 = element$iv$iv4 = (Map.Entry)element$iv$iv3.next();
            boolean bl = false;
            Iterable list$iv$iv = (List)it5.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List uniqueFirstChildren = CollectionsKt.minus((Iterable)iterable, (Iterable)((List)destination$iv$iv3));
        Map $i$f$flatMap22 = duplicateSecondChildren;
        iterable = secondSchemaChildren;
        boolean $i$f$flatMap = false;
        destination$iv$iv3 = $this$flatMap$iv;
        Iterable destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator element$iv$iv4 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (element$iv$iv4.hasNext()) {
            Map.Entry element$iv$iv5;
            Map.Entry it6 = element$iv$iv5 = element$iv$iv4.next();
            boolean bl = false;
            Iterable list$iv$iv = (List)it6.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        List uniqueSecondChildren = CollectionsKt.minus((Iterable)iterable, (Iterable)((List)destination$iv$iv4));
        Iterable $this$map$iv = uniqueSecondChildren;
        boolean $i$f$map = false;
        destination$iv$iv4 = $this$map$iv;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it7;
            Declaration bl = (Declaration)item$iv$iv;
            iterable = destination$iv$iv5;
            boolean bl4 = false;
            iterable.add(it7.getSnakeCaseName());
        }
        List uniqueSecondNames = (List)destination$iv$iv5;
        Iterable $this$partition$iv = uniqueFirstChildren;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Declaration it8 = (Declaration)element$iv;
            boolean bl = false;
            if (uniqueSecondNames.contains(it8.getSnakeCaseName())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List firstIntersection = (List)pair.component1();
        List firstOnly = (List)pair.component2();
        Iterable $this$map$iv2 = uniqueFirstChildren;
        boolean $i$f$map2 = false;
        Iterable element$iv = $this$map$iv2;
        Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Declaration declaration = (Declaration)item$iv$iv;
            iterable = destination$iv$iv6;
            boolean bl = false;
            iterable.add(it.getSnakeCaseName());
        }
        List uniqueFirstNames = (List)destination$iv$iv6;
        Iterable $this$partition$iv2 = uniqueSecondChildren;
        boolean $i$f$partition2 = false;
        ArrayList first$iv2 = new ArrayList();
        ArrayList second$iv2 = new ArrayList();
        for (Object element$iv2 : $this$partition$iv2) {
            it = (Declaration)element$iv2;
            boolean bl = false;
            if (uniqueFirstNames.contains(it.getSnakeCaseName())) {
                first$iv2.add(element$iv2);
                continue;
            }
            second$iv2.add(element$iv2);
        }
        Pair pair2 = new Pair(first$iv2, second$iv2);
        List secondIntersection = (List)pair2.component1();
        List secondOnly = (List)pair2.component2();
        Iterable $this$sortedBy$iv = firstIntersection;
        boolean $i$f$sortedBy = false;
        Iterable iterable2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Declaration it = (Declaration)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getSnakeCaseName());
                it = (Declaration)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSnakeCaseName())));
            }
        });
        $this$sortedBy$iv = secondIntersection;
        $i$f$sortedBy = false;
        List intersectionPairs = CollectionsKt.zip((Iterable)iterable2, (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Declaration it = (Declaration)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getSnakeCaseName());
                it = (Declaration)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSnakeCaseName())));
            }
        }));
        return new Triple((Object)firstOnly, (Object)secondOnly, (Object)intersectionPairs);
    }

    private final void validate(boolean expression, Function0<String> lambda) {
        if (!expression) {
            ((Collection)this.messages).add(new Message(this.path, (String)lambda.invoke(), true));
        }
    }

    private final void checkWarning(boolean expression, Function0<String> lambda) {
        if (!expression) {
            ((Collection)this.messages).add(new Message(this.path, (String)lambda.invoke(), false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withDeclaration(Path path, Function0<Unit> lambda) {
        LinkedHashMultiset<Path> linkedHashMultiset = this.validatedPaths;
        Intrinsics.checkNotNullExpressionValue(linkedHashMultiset, (String)"validatedPaths");
        ((Collection)linkedHashMultiset).add(path);
        Path oldPath = path;
        this.path = path;
        try {
            lambda.invoke();
        }
        finally {
            this.path = oldPath;
        }
    }

    public static final /* synthetic */ void access$validateTables(SchemaValidator $this, TableDeclaration dbTable, TableDeclaration hibernateTable) {
        $this.validateTables(dbTable, hibernateTable);
    }

    public static final /* synthetic */ void access$validateColumns(SchemaValidator $this, TableDeclaration dbTable, ColumnDeclaration dbColumn, ColumnDeclaration hibernateColumn) {
        $this.validateColumns(dbTable, dbColumn, hibernateColumn);
    }

    public static final /* synthetic */ DatabaseDeclaration access$readDeclarationFromDatabase(SchemaValidator $this, Connection connection) {
        return $this.readDeclarationFromDatabase(connection);
    }

    public static final /* synthetic */ void access$validateDatabase(SchemaValidator $this, DatabaseDeclaration dbSchema2, DatabaseDeclaration hibernateSchema) {
        $this.validateDatabase(dbSchema2, hibernateSchema);
    }
}

